/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.designtime.datafactory.editor.model;

import javax.swing.ComboBoxModel;
import javax.swing.event.EventListenerList;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import org.pentaho.reporting.engine.classic.core.designtime.datafactory.editor.model.Query;
import org.pentaho.reporting.engine.classic.core.designtime.datafactory.editor.model.QueryDialogModel;
import org.pentaho.reporting.engine.classic.core.designtime.datafactory.editor.model.QueryDialogModelEvent;
import org.pentaho.reporting.engine.classic.core.designtime.datafactory.editor.model.QueryDialogModelListener;

public class QueryDialogComboBoxModel<T>
implements ComboBoxModel {
    private EventListenerList listeners = new EventListenerList();
    private QueryDialogModel<T> dialogModel;

    public QueryDialogComboBoxModel(QueryDialogModel<T> dialogModel) {
        this.dialogModel = dialogModel;
        this.dialogModel.addQueryDialogModelListener(new UpdateHandler());
    }

    @Override
    public Object getSelectedItem() {
        return this.dialogModel.getSelectedQuery();
    }

    @Override
    public void setSelectedItem(Object anItem) {
        this.dialogModel.setSelectedQuery((Query)anItem);
    }

    @Override
    public int getSize() {
        return this.dialogModel.getQueryCount();
    }

    @Override
    public Query<T> getElementAt(int index) {
        return this.dialogModel.getQuery(index);
    }

    @Override
    public void addListDataListener(ListDataListener l) {
        this.listeners.add(ListDataListener.class, l);
    }

    @Override
    public void removeListDataListener(ListDataListener l) {
        this.listeners.remove(ListDataListener.class, l);
    }

    protected void fireContentsChangedEvent(ListDataEvent event) {
        ListDataListener[] listeners1 = (ListDataListener[])this.listeners.getListeners(ListDataListener.class);
        for (int i = listeners1.length - 1; i >= 0; --i) {
            ListDataListener l = listeners1[i];
            l.contentsChanged(event);
        }
    }

    protected void fireIntervalRemovedEvent(ListDataEvent event) {
        ListDataListener[] listeners1 = (ListDataListener[])this.listeners.getListeners(ListDataListener.class);
        for (int i = listeners1.length - 1; i >= 0; --i) {
            ListDataListener l = listeners1[i];
            l.intervalRemoved(event);
        }
    }

    protected void fireIntervalAddedEvent(ListDataEvent event) {
        ListDataListener[] listeners1 = (ListDataListener[])this.listeners.getListeners(ListDataListener.class);
        for (int i = listeners1.length - 1; i >= 0; --i) {
            ListDataListener l = listeners1[i];
            l.intervalAdded(event);
        }
    }

    private class UpdateHandler
    implements QueryDialogModelListener<T> {
        private UpdateHandler() {
        }

        @Override
        public void globalScriptChanged(QueryDialogModelEvent<T> event) {
        }

        @Override
        public void queryAdded(QueryDialogModelEvent<T> event) {
            QueryDialogComboBoxModel.this.fireIntervalAddedEvent(new ListDataEvent(this, 1, event.getNewIndex(), event.getNewIndex()));
        }

        @Override
        public void queryRemoved(QueryDialogModelEvent<T> event) {
            QueryDialogComboBoxModel.this.fireIntervalRemovedEvent(new ListDataEvent(this, 2, event.getOldIndex(), event.getOldIndex()));
        }

        @Override
        public void queryUpdated(QueryDialogModelEvent<T> event) {
            QueryDialogComboBoxModel.this.fireContentsChangedEvent(new ListDataEvent(this, 0, event.getNewIndex(), event.getNewIndex()));
        }

        @Override
        public void queryDataChanged(QueryDialogModelEvent<T> event) {
            QueryDialogComboBoxModel.this.fireContentsChangedEvent(new ListDataEvent(this, 0, 0, QueryDialogComboBoxModel.this.getSize()));
        }

        @Override
        public void selectionChanged(QueryDialogModelEvent<T> event) {
            QueryDialogComboBoxModel.this.fireContentsChangedEvent(new ListDataEvent(this, 0, -1, -1));
        }
    }
}

