/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core;

import java.util.LinkedHashMap;
import java.util.Map;
import org.pentaho.reporting.engine.classic.core.DataRow;
import org.pentaho.reporting.engine.classic.core.DefaultReportEnvironmentMapping;
import org.pentaho.reporting.engine.classic.core.ReportEnvironment;
import org.pentaho.reporting.engine.classic.core.ReportEnvironmentMapping;
import org.pentaho.reporting.libraries.base.util.CSVTokenizer;
import org.pentaho.reporting.libraries.base.util.StringUtils;

public class ReportEnvironmentDataRow
implements DataRow {
    private ReportEnvironment environment;
    private LinkedHashMap<String, String> columnMap;
    private String[] columnNames;

    public ReportEnvironmentDataRow(ReportEnvironment environment) {
        this(environment, DefaultReportEnvironmentMapping.INSTANCE);
    }

    public ReportEnvironmentDataRow(ReportEnvironment environment, ReportEnvironmentMapping reportEnvironmentMapping) {
        Map<String, String> envMapping = reportEnvironmentMapping.createEnvironmentMapping();
        this.columnMap = new LinkedHashMap();
        for (Map.Entry<String, String> entry : envMapping.entrySet()) {
            String key = entry.getKey();
            String value = entry.getValue();
            if (StringUtils.isEmpty((String)key) || StringUtils.isEmpty((String)value)) continue;
            this.columnMap.put(value, key);
        }
        this.columnNames = this.columnMap.keySet().toArray(new String[this.columnMap.size()]);
        this.environment = environment;
    }

    @Override
    public Object get(String col) {
        String envName = this.columnMap.get(col);
        if (envName == null) {
            return null;
        }
        if (envName.endsWith("-array")) {
            String name = envName.substring(0, envName.length() - 6);
            Object s = this.environment.getEnvironmentProperty(name);
            if (s == null) {
                return new String[0];
            }
            CSVTokenizer csvTokenizer = new CSVTokenizer(String.valueOf(s), ",", "\"", false);
            int length = csvTokenizer.countTokens();
            String[] rolesArray = new String[length];
            for (int i = 0; i < length; ++i) {
                rolesArray[i] = csvTokenizer.nextToken();
            }
            return rolesArray;
        }
        return this.environment.getEnvironmentProperty(envName);
    }

    @Override
    public String[] getColumnNames() {
        return (String[])this.columnNames.clone();
    }

    @Override
    public boolean isChanged(String name) {
        return false;
    }

    public boolean isArray(String columnName) {
        String envName = this.columnMap.get(columnName);
        if (envName == null) {
            return false;
        }
        return envName.endsWith("-array");
    }

    public ReportEnvironment getEnvironment() {
        return this.environment;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("ReportEnvironmentDataRow");
        sb.append("{columnMap=").append(this.columnMap);
        sb.append('}');
        return sb.toString();
    }
}

