/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.designtime.swing.propertyeditors;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.beans.PropertyEditor;
import java.util.EventObject;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.EventListenerList;
import javax.swing.table.TableCellEditor;
import org.pentaho.reporting.libraries.designtime.swing.EllipsisButton;
import org.pentaho.reporting.libraries.designtime.swing.LibSwingUtil;
import org.pentaho.reporting.libraries.designtime.swing.Messages;
import org.pentaho.reporting.libraries.designtime.swing.propertyeditors.AdvancedPropertyEditor;
import org.pentaho.reporting.libraries.designtime.swing.propertyeditors.BasicTextPropertyEditorDialog;
import org.pentaho.reporting.libraries.designtime.swing.propertyeditors.CustomPropertyEditorDialog;

public class PropertyCellEditorWithEllipsis
extends JPanel
implements TableCellEditor {
    private static final String POPUP_EDITOR = "popupEditor";
    private JTextField textField;
    private JButton ellipsisButton;
    private EventListenerList eventListenerList;
    private boolean nullable;
    private PropertyEditor propertyEditor;

    public PropertyCellEditorWithEllipsis() {
        this.setLayout(new BorderLayout());
        this.eventListenerList = new EventListenerList();
        this.ellipsisButton = new EllipsisButton("...");
        this.ellipsisButton.addActionListener(new ExtendedEditorAction());
        this.textField = new JTextField();
        this.textField.getInputMap().put(Messages.getInstance().getKeyStroke("PropertyCellEditorWithEllipsis.PopupEditor.Accelerator"), POPUP_EDITOR);
        this.textField.getActionMap().put(POPUP_EDITOR, new ExtendedEditorAction());
        this.textField.setBorder(BorderFactory.createEmptyBorder());
        this.add((Component)this.textField, "Center");
        this.add((Component)this.ellipsisButton, "East");
        this.nullable = false;
    }

    protected BasicTextPropertyEditorDialog createTextEditorDialog() {
        Window window = LibSwingUtil.getWindowAncestor(this);
        BasicTextPropertyEditorDialog editorDialog = window instanceof Frame ? new BasicTextPropertyEditorDialog((Frame)window) : (window instanceof Dialog ? new BasicTextPropertyEditorDialog((Dialog)window) : new BasicTextPropertyEditorDialog());
        return editorDialog;
    }

    public PropertyEditor getPropertyEditor() {
        return this.propertyEditor;
    }

    public void setPropertyEditor(PropertyEditor propertyEditor) {
        this.propertyEditor = propertyEditor;
        if (propertyEditor instanceof AdvancedPropertyEditor) {
            AdvancedPropertyEditor advancedPropertyEditor = (AdvancedPropertyEditor)propertyEditor;
            this.textField.setEditable(advancedPropertyEditor.supportsText());
        } else {
            this.textField.setEditable(true);
        }
    }

    public boolean isNullable() {
        return this.nullable;
    }

    public void setNullable(boolean nullable) {
        this.nullable = nullable;
    }

    @Override
    public void requestFocus() {
        this.textField.requestFocus();
    }

    public JTextField getTextField() {
        return this.textField;
    }

    public JButton getEllipsisButton() {
        return this.ellipsisButton;
    }

    @Override
    public Object getCellEditorValue() {
        return this.propertyEditor.getValue();
    }

    @Override
    public boolean isCellEditable(EventObject anEvent) {
        return true;
    }

    @Override
    public boolean shouldSelectCell(EventObject anEvent) {
        return true;
    }

    @Override
    public boolean stopCellEditing() {
        try {
            this.propertyEditor.setAsText(this.textField.getText());
            this.fireEditingStopped();
            this.textField.setText(null);
            return true;
        }
        catch (Exception e) {
            this.fireEditingCanceled();
            this.textField.setText(null);
            return true;
        }
    }

    @Override
    public void cancelCellEditing() {
        this.textField.setText(null);
        this.fireEditingCanceled();
    }

    protected void fireEditingCanceled() {
        CellEditorListener[] listeners = (CellEditorListener[])this.eventListenerList.getListeners(CellEditorListener.class);
        ChangeEvent event = new ChangeEvent(this);
        for (int i = 0; i < listeners.length; ++i) {
            CellEditorListener listener = listeners[i];
            listener.editingCanceled(event);
        }
    }

    protected void fireEditingStopped() {
        CellEditorListener[] listeners = (CellEditorListener[])this.eventListenerList.getListeners(CellEditorListener.class);
        ChangeEvent event = new ChangeEvent(this);
        for (int i = 0; i < listeners.length; ++i) {
            CellEditorListener listener = listeners[i];
            listener.editingStopped(event);
        }
    }

    @Override
    public void addCellEditorListener(CellEditorListener l) {
        this.eventListenerList.add(CellEditorListener.class, l);
    }

    @Override
    public void removeCellEditorListener(CellEditorListener l) {
        this.eventListenerList.remove(CellEditorListener.class, l);
    }

    @Override
    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        this.propertyEditor.setValue(value);
        if (value == null) {
            this.textField.setText(null);
        } else {
            this.textField.setText(this.propertyEditor.getAsText());
        }
        return this;
    }

    private class ExtendedEditorAction
    extends AbstractAction {
        private ExtendedEditorAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (PropertyCellEditorWithEllipsis.this.propertyEditor == null) {
                return;
            }
            if (PropertyCellEditorWithEllipsis.this.propertyEditor.supportsCustomEditor()) {
                Window window = LibSwingUtil.getWindowAncestor(PropertyCellEditorWithEllipsis.this);
                CustomPropertyEditorDialog editorDialog = window instanceof Frame ? new CustomPropertyEditorDialog((Frame)window) : (window instanceof Dialog ? new CustomPropertyEditorDialog((Dialog)window) : new CustomPropertyEditorDialog());
                if (editorDialog.performEdit(PropertyCellEditorWithEllipsis.this.propertyEditor)) {
                    PropertyCellEditorWithEllipsis.this.textField.setText(PropertyCellEditorWithEllipsis.this.propertyEditor.getAsText());
                    PropertyCellEditorWithEllipsis.this.stopCellEditing();
                }
            } else {
                BasicTextPropertyEditorDialog editorDialog = PropertyCellEditorWithEllipsis.this.createTextEditorDialog();
                if (editorDialog.performEdit(PropertyCellEditorWithEllipsis.this.propertyEditor)) {
                    PropertyCellEditorWithEllipsis.this.textField.setText(PropertyCellEditorWithEllipsis.this.propertyEditor.getAsText());
                    PropertyCellEditorWithEllipsis.this.stopCellEditing();
                }
            }
        }
    }
}

