/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.designtime.swing.colorchooser;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.Scrollable;
import org.pentaho.reporting.libraries.designtime.swing.colorchooser.AbstractColorChooserPanel;
import org.pentaho.reporting.libraries.designtime.swing.colorchooser.ColorChooserMessages;
import org.pentaho.reporting.libraries.designtime.swing.colorchooser.ColorSchema;
import org.pentaho.reporting.libraries.designtime.swing.colorchooser.ExcelColorSchema;
import org.pentaho.reporting.libraries.designtime.swing.colorchooser.SwingColorSchema;

public class SwatchColorChooser
extends AbstractColorChooserPanel {
    private DefaultComboBoxModel swatches = new DefaultComboBoxModel();
    private SwatchPanel colorList = new SwatchPanel();

    public SwatchColorChooser() {
        this.colorList.addMouseListener(new SwatchPanelSelectionListener());
        JComboBox<Object> comboBox = new JComboBox<Object>(this.swatches);
        comboBox.addItemListener(new SchemaSelectionListener());
        comboBox.setRenderer(new ColorChooserRenderer());
        JPanel selectorPanel = new JPanel();
        selectorPanel.setLayout(new BorderLayout());
        selectorPanel.add(comboBox, "Center");
        selectorPanel.add((Component)new JLabel(ColorChooserMessages.getInstance().getString("ColorSchema")), "West");
        JScrollPane scrollPane = new JScrollPane(this.colorList, 20, 31);
        scrollPane.getViewport().setOpaque(false);
        scrollPane.setOpaque(false);
        this.setLayout(new BorderLayout());
        this.add((Component)selectorPanel, "North");
        this.add((Component)scrollPane, "Center");
        this.addSwatches(new SwingColorSchema());
        this.addSwatches(new ExcelColorSchema());
    }

    public void addSwatches(ColorSchema colorSchema) {
        this.swatches.addElement(colorSchema);
        if (this.swatches.getSize() == 1) {
            this.swatches.setSelectedItem(colorSchema);
        }
    }

    public void removeSwatches(ColorSchema colorSchema) {
        this.swatches.removeElement(colorSchema);
    }

    public void clearSwatches() {
        this.swatches.removeAllElements();
    }

    @Override
    public String getDisplayName() {
        return ColorChooserMessages.getInstance().getString("SwatchesTitle");
    }

    @Override
    public Icon getSmallDisplayIcon() {
        return null;
    }

    @Override
    protected void colorUpdated() {
        this.colorList.repaint();
    }

    private class ColorChooserRenderer
    extends DefaultListCellRenderer {
        private ColorChooserRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            if (value instanceof ColorSchema) {
                ColorSchema cs = (ColorSchema)value;
                return super.getListCellRendererComponent((JList<?>)list, cs.getName(), index, isSelected, cellHasFocus);
            }
            return super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
        }
    }

    private class SwatchPanelSelectionListener
    extends MouseAdapter {
        private SwatchPanelSelectionListener() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            if (e.getButton() != 1) {
                return;
            }
            Color color = SwatchColorChooser.this.colorList.getColorForPosition(e.getPoint());
            if (color != null) {
                SwatchColorChooser.this.getColorSelectionModel().setSelectedColor(color);
            }
        }
    }

    private class SchemaSelectionListener
    implements ItemListener {
        private SchemaSelectionListener() {
        }

        @Override
        public void itemStateChanged(ItemEvent e) {
            ColorSchema selectedKey = (ColorSchema)SwatchColorChooser.this.swatches.getSelectedItem();
            if (selectedKey != null) {
                SwatchColorChooser.this.colorList.setColors(selectedKey.getColors());
            }
        }
    }

    private class SwatchPanel
    extends JPanel
    implements Scrollable {
        private Color[] colors;
        private Dimension swatchSize;
        private Dimension gap;
        private int swatchCountPerRow;

        private SwatchPanel() {
            this(new Color[0]);
        }

        public SwatchPanel(Color[] colors) {
            this.colors = colors;
            this.swatchSize = new Dimension(20, 20);
            this.gap = new Dimension(2, 2);
            this.setOpaque(false);
        }

        public void setColors(Color[] colors) {
            if (colors == null) {
                throw new NullPointerException();
            }
            this.colors = colors;
            this.invalidate();
            this.revalidate();
            this.repaint();
        }

        public Color getColorForPosition(Point p) {
            int width = this.getWidth();
            if (width == 0) {
                return null;
            }
            int y = p.y / (this.swatchSize.height + this.gap.height);
            int cx = (width - 1) / (this.gap.width + this.swatchSize.width);
            int x = p.x / (this.swatchSize.width + this.gap.width);
            if (y * cx + x < this.colors.length) {
                return this.colors[y * cx + x];
            }
            return null;
        }

        @Override
        protected void paintComponent(Graphics g) {
            int width = this.getWidth();
            if (width == 0) {
                return;
            }
            int cx = (width - 1) / (this.gap.width + this.swatchSize.width);
            int cy = (int)Math.ceil(Math.max(1.0f, (float)this.colors.length) / (float)cx);
            Color selectedColor = SwatchColorChooser.this.getColorSelectionModel().getSelectedColor();
            for (int y = 0; y < cy; ++y) {
                for (int x = 0; x < cx; ++x) {
                    int px = x * (this.swatchSize.width + this.gap.width);
                    int py = y * (this.swatchSize.height + this.gap.height);
                    if (y * cx + x >= this.colors.length) continue;
                    Color color = this.colors[y * cx + x];
                    g.setColor(color);
                    g.fillRect(px, py, this.swatchSize.width, this.swatchSize.height);
                    if (selectedColor != null && selectedColor.equals(color)) {
                        g.setColor(Color.white);
                    } else {
                        g.setColor(Color.black);
                    }
                    g.drawRect(px, py, this.swatchSize.width, this.swatchSize.height);
                }
            }
        }

        @Override
        public Dimension getPreferredScrollableViewportSize() {
            return this.getPreferredSize();
        }

        @Override
        public int getScrollableUnitIncrement(Rectangle visibleRect, int orientation, int direction) {
            if (orientation == 1) {
                return this.swatchSize.height;
            }
            return this.swatchSize.width;
        }

        @Override
        public int getScrollableBlockIncrement(Rectangle visibleRect, int orientation, int direction) {
            return 5 * this.getScrollableUnitIncrement(visibleRect, orientation, direction);
        }

        @Override
        public boolean getScrollableTracksViewportWidth() {
            return true;
        }

        @Override
        public boolean getScrollableTracksViewportHeight() {
            return false;
        }

        public int getSwatchCountPerRow() {
            return this.swatchCountPerRow;
        }

        public void setSwatchCountPerRow(int swatchCountPerRow) {
            this.swatchCountPerRow = swatchCountPerRow;
        }

        @Override
        public Dimension getPreferredSize() {
            int preferredSize = this.swatchCountPerRow <= 0 ? (int)Math.ceil(Math.sqrt(this.colors.length)) : this.swatchCountPerRow;
            if (preferredSize == 0) {
                return new Dimension(0, 0);
            }
            int width = (this.gap.width + this.swatchSize.width) * preferredSize + this.gap.width;
            int height = (int)((double)this.gap.height + (double)(this.swatchSize.height + this.gap.height) * Math.ceil(preferredSize / Math.min(1, this.colors.length)));
            return new Dimension(width, height);
        }
    }
}

