/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.designtime.swing;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JTable;
import javax.swing.ListCellRenderer;
import javax.swing.table.TableCellRenderer;
import org.pentaho.reporting.libraries.designtime.swing.ColorUtility;
import org.pentaho.reporting.libraries.designtime.swing.Messages;

public class ColorCellRenderer
extends JLabel
implements ListCellRenderer,
TableCellRenderer {
    private Color color;

    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        Color item = (Color)value;
        if (item != null) {
            this.color = item;
            this.setBackground(item);
            this.setText(ColorUtility.toAttributeValue(item));
            return this;
        }
        this.color = null;
        this.setText(Messages.getInstance().getString("ColorCellRenderer.Automatic"));
        this.setBackground(null);
        return this;
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        try {
            Color item = value instanceof String ? ColorUtility.toPropertyValue((String)value) : (Color)value;
            if (item != null) {
                this.color = item;
                this.setBackground(item);
                this.setText(ColorUtility.toAttributeValue(item));
                return this;
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        this.color = null;
        this.setText(Messages.getInstance().getString("ColorCellRenderer.Automatic"));
        this.setBackground(null);
        return this;
    }

    @Override
    protected void paintComponent(Graphics graphics) {
        if (this.color != null) {
            this.setBackground(this.color);
            graphics.setColor(this.color);
            graphics.fillRect(0, 0, this.getWidth(), this.getHeight());
            this.setForeground(ColorUtility.getBrightness(this.color) > 167 ? Color.BLACK : Color.WHITE);
        }
        super.paintComponent(graphics);
    }
}

