/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.style;

import java.io.ObjectStreamException;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.reporting.engine.classic.core.ClassicEngineBoot;
import org.pentaho.reporting.libraries.base.config.Configuration;
import org.pentaho.reporting.libraries.base.util.ObjectUtilities;

public final class StyleKey
implements Serializable,
Cloneable {
    private static final Log logger = LogFactory.getLog(StyleKey.class);
    private static HashMap definedKeys;
    private static int definedKeySize;
    private static StyleKey[] definedKeysArray;
    private static List<StyleKey> definedKeysList;
    private static boolean locked;
    public final String name;
    private Class valueType;
    public final int identifier;
    private boolean trans;
    private boolean inheritable;

    private StyleKey(String name, Class valueType, boolean trans, boolean inheritable) {
        if (name == null) {
            throw new NullPointerException("StyleKey.setName(...): null not permitted.");
        }
        if (valueType == null) {
            throw new NullPointerException("ValueType must not be null");
        }
        this.valueType = valueType;
        this.name = name;
        this.identifier = definedKeys.size();
        this.trans = trans;
        this.inheritable = inheritable;
    }

    public String getName() {
        return this.name;
    }

    public Class<?> getValueType() {
        return this.valueType;
    }

    public static StyleKey getStyleKey(String name, Class valueType) {
        return StyleKey.getStyleKey(name, valueType, false, true);
    }

    public static synchronized StyleKey getStyleKey(String name, Class valueType, boolean trans, boolean inheritable) {
        StyleKey key;
        if (locked) {
            throw new IllegalStateException("StyleKeys have been locked after booting was completed.");
        }
        if (definedKeys == null) {
            definedKeys = new HashMap();
            definedKeySize = 0;
        }
        if ((key = (StyleKey)definedKeys.get(name)) == null) {
            key = new StyleKey(name, valueType, trans, inheritable);
            definedKeys.put(name, key);
            definedKeySize = definedKeys.size();
            definedKeysArray = null;
            definedKeysList = null;
        }
        return key;
    }

    public static synchronized void lock() {
        locked = true;
    }

    public static synchronized StyleKey getStyleKey(String name) {
        if (definedKeys == null) {
            return null;
        }
        return (StyleKey)definedKeys.get(name);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof StyleKey)) {
            return false;
        }
        StyleKey key = (StyleKey)o;
        if (!this.name.equals(key.name)) {
            return false;
        }
        return this.valueType.equals(key.valueType);
    }

    public int hashCode() {
        return this.identifier;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object readResolve() throws ObjectStreamException {
        Class<StyleKey> clazz = StyleKey.class;
        synchronized (StyleKey.class) {
            StyleKey key = StyleKey.getStyleKey(this.name);
            if (key != null) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return key;
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return StyleKey.getStyleKey(this.name, this.valueType, this.trans, this.inheritable);
        }
    }

    public boolean isTransient() {
        return this.trans;
    }

    public String toString() {
        StringBuffer b = new StringBuffer(100);
        b.append("StyleKey={name='");
        b.append(this.getName());
        b.append("', valueType='");
        b.append(this.getValueType());
        b.append("'}");
        return b.toString();
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    public boolean isInheritable() {
        return this.inheritable;
    }

    public int getIdentifier() {
        return this.identifier;
    }

    public static int getDefinedStyleKeyCount() {
        return definedKeySize;
    }

    public static synchronized List<StyleKey> getDefinedStyleKeysList() {
        if (definedKeysList != null) {
            return definedKeysList;
        }
        definedKeysList = Collections.unmodifiableList(Arrays.asList(StyleKey.getDefinedStyleKeys()));
        return definedKeysList;
    }

    public static synchronized StyleKey[] getDefinedStyleKeys() {
        if (definedKeys == null) {
            throw new IllegalStateException("The engine has not been booted and the default keys have no been registered yet.");
        }
        if (definedKeysArray != null) {
            StyleKey.assertNoNullEntries();
            return (StyleKey[])definedKeysArray.clone();
        }
        StyleKey[] keys = definedKeys.values().toArray(new StyleKey[definedKeys.size()]);
        definedKeysArray = (StyleKey[])keys.clone();
        for (int i = 0; i < keys.length; ++i) {
            StyleKey key;
            StyleKey.definedKeysArray[key.identifier] = key = keys[i];
        }
        StyleKey.assertNoNullEntries();
        return (StyleKey[])definedKeysArray.clone();
    }

    public static void assertNoNullEntries() {
        for (int i = 0; i < definedKeysArray.length; ++i) {
            StyleKey styleKey = definedKeysArray[i];
            if (styleKey != null) continue;
            throw new NullPointerException();
        }
    }

    public static synchronized void registerDefaults() {
        Configuration config = ClassicEngineBoot.getInstance().getGlobalConfig();
        Iterator it = config.findPropertyKeys("org.pentaho.reporting.engine.classic.core.stylekeys.");
        ClassLoader classLoader = ObjectUtilities.getClassLoader(StyleKey.class);
        while (it.hasNext()) {
            String key = (String)it.next();
            String keyClass = config.getConfigProperty(key);
            try {
                Class<?> c = Class.forName(keyClass, false, classLoader);
                StyleKey.registerClass(c);
            }
            catch (ClassNotFoundException e) {
                logger.warn((Object)("Unable to register keys from " + keyClass));
            }
            catch (NullPointerException e) {
                logger.warn((Object)("Unable to register keys from " + keyClass));
            }
        }
    }

    public static synchronized void registerClass(Class c) {
        try {
            Field[] fields = c.getFields();
            for (int i = 0; i < fields.length; ++i) {
                Field field = fields[i];
                int modifiers = field.getModifiers();
                if (!Modifier.isPublic(modifiers) || !Modifier.isStatic(modifiers)) continue;
                if (!Modifier.isFinal(modifiers)) {
                    logger.warn((Object)("Invalid implementation: StyleKeys should be 'public static final': " + c));
                }
                if (!field.getType().isAssignableFrom(StyleKey.class)) continue;
                StyleKey styleKey = (StyleKey)field.get(null);
            }
        }
        catch (IllegalAccessException e) {
            logger.warn((Object)("Unable to register keys from " + c.getName()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    static synchronized StyleKey addTestKey(String name, Class valueType, boolean trans, boolean inheritable) {
        boolean wasLocked = locked;
        try {
            locked = false;
            StyleKey styleKey = StyleKey.getStyleKey(name, valueType, trans, inheritable);
            return styleKey;
        }
        finally {
            locked = wasLocked;
            definedKeysArray = null;
            definedKeysList = null;
        }
    }

    @Deprecated
    static synchronized void removeTestKey(String name) {
        try {
            if (definedKeys != null) {
                definedKeys.remove(name);
            }
            definedKeySize = definedKeys.size();
        }
        finally {
            definedKeysArray = null;
            definedKeysList = null;
        }
    }
}

