/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.states.datarow;

import java.util.Iterator;
import org.pentaho.reporting.engine.classic.core.event.PageEventListener;
import org.pentaho.reporting.engine.classic.core.function.Expression;
import org.pentaho.reporting.engine.classic.core.function.Function;
import org.pentaho.reporting.engine.classic.core.states.datarow.IndirectIndexIterator;
import org.pentaho.reporting.engine.classic.core.states.datarow.LevelStorage;
import org.pentaho.reporting.engine.classic.core.util.IntList;
import org.pentaho.reporting.engine.classic.core.util.IntegerCache;
import org.pentaho.reporting.engine.classic.core.util.LevelList;

public class LevelStorageBackend {
    private static final Integer[] EMPTY_INTEGERARRAY = new Integer[0];
    private int levelNumber;
    private int[] activeExpressions;
    private int[] functions;
    private int[] pageEventListeners;

    public LevelStorageBackend(int levelNumber, int[] activeExpressions, int[] functions, int[] pageEventListeners) {
        if (pageEventListeners == null) {
            throw new NullPointerException();
        }
        if (activeExpressions == null) {
            throw new NullPointerException();
        }
        if (functions == null) {
            throw new NullPointerException();
        }
        this.levelNumber = levelNumber;
        this.activeExpressions = activeExpressions;
        this.functions = functions;
        this.pageEventListeners = pageEventListeners;
    }

    public int getLevelNumber() {
        return this.levelNumber;
    }

    public int[] getFunctions() {
        return this.functions;
    }

    public int[] getActiveExpressions() {
        return this.activeExpressions;
    }

    public int[] getPageEventListeners() {
        return this.pageEventListeners;
    }

    public boolean hasPageEventListeners() {
        return this.pageEventListeners != null && this.pageEventListeners.length > 0;
    }

    public static LevelStorageBackend[] revalidate(Expression[] expressions, int length, boolean includeStructuralProcessing) {
        int dependencyLevel;
        Expression expression;
        int i;
        LevelList levelList = new LevelList();
        int minLevel = Integer.MIN_VALUE;
        for (i = 0; i < length; ++i) {
            expression = expressions[i];
            dependencyLevel = expression.getDependencyLevel();
            levelList.add(IntegerCache.getInteger(i), dependencyLevel);
            if (minLevel >= dependencyLevel) continue;
            minLevel = dependencyLevel;
        }
        if (includeStructuralProcessing && minLevel > Integer.MIN_VALUE) {
            for (i = 0; i < length; ++i) {
                expression = expressions[i];
                dependencyLevel = expression.getDependencyLevel();
                if (dependencyLevel != minLevel || expression instanceof Function) continue;
                levelList.add(IntegerCache.getInteger(i), Integer.MAX_VALUE);
            }
        }
        Integer[] levels = levelList.getLevelsDescendingArray();
        LevelStorageBackend[] levelData = new LevelStorageBackend[levels.length];
        int expressionsCount = levelList.size();
        int capacity = Math.min(20, expressionsCount);
        IntList activeExpressions = new IntList(capacity);
        IntList functions = new IntList(capacity);
        IntList pageEventListeners = new IntList(capacity);
        for (int i2 = 0; i2 < levels.length; ++i2) {
            int currentLevel = levels[i2];
            Integer[] data = (Integer[])levelList.getElementArrayForLevel(currentLevel, EMPTY_INTEGERARRAY);
            for (int x = 0; x < data.length; ++x) {
                Integer position = data[x];
                Expression ex = expressions[position];
                int globalPosition = position;
                if (!(ex instanceof Function)) {
                    if (ex.getName() == null) continue;
                    activeExpressions.add(globalPosition);
                    continue;
                }
                activeExpressions.add(globalPosition);
                functions.add(globalPosition);
                if (!(ex instanceof PageEventListener)) continue;
                pageEventListeners.add(globalPosition);
            }
            levelData[i2] = new LevelStorageBackend(currentLevel, activeExpressions.toArray(), functions.toArray(), pageEventListeners.toArray());
            activeExpressions.clear();
            functions.clear();
            pageEventListeners.clear();
        }
        return levelData;
    }

    public static LevelStorage getLevelStorage(LevelStorageBackend levelStorageBackend, Expression[] expressions) {
        return new LevelStorageImpl(levelStorageBackend, expressions);
    }

    private static class LevelStorageImpl
    implements LevelStorage {
        private LevelStorageBackend levelData;
        private Expression[] expressions;

        private LevelStorageImpl(LevelStorageBackend levelData, Expression[] expressions) {
            this.levelData = levelData;
            this.expressions = expressions;
        }

        @Override
        public int getLevelNumber() {
            return this.levelData.getLevelNumber();
        }

        @Override
        public Iterator<Function> getFunctions() {
            return new IndirectIndexIterator<Function>(this.levelData.getFunctions(), this.expressions);
        }

        @Override
        public Iterator<Function> getPageFunctions() {
            return new IndirectIndexIterator<Function>(this.levelData.getPageEventListeners(), this.expressions);
        }

        @Override
        public Iterator<Expression> getActiveExpressions() {
            return new IndirectIndexIterator<Expression>(this.levelData.getActiveExpressions(), this.expressions);
        }
    }
}

