/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.parameters;

import java.io.Serializable;
import org.pentaho.reporting.engine.classic.core.ReportDataFactoryException;
import org.pentaho.reporting.engine.classic.core.ReportProcessingException;
import org.pentaho.reporting.engine.classic.core.function.FormulaExpression;
import org.pentaho.reporting.engine.classic.core.parameters.ParameterContext;
import org.pentaho.reporting.engine.classic.core.parameters.ParameterExpressionRuntime;
import org.pentaho.reporting.libraries.base.util.StringUtils;

public interface ParameterDefinitionEntry
extends Serializable,
Cloneable {
    public String getName();

    public String getParameterAttribute(String var1, String var2, ParameterContext var3);

    public String[] getParameterAttributeNamespaces();

    public String[] getParameterAttributeNames(String var1);

    public boolean isMandatory();

    public Class getValueType();

    public Object getDefaultValue(ParameterContext var1) throws ReportDataFactoryException;

    public Object clone() throws CloneNotSupportedException;

    default public String getTranslatedParameterAttribute(String namespace, String name, ParameterContext context) {
        String formulaName = name + "-formula";
        String formula = this.getParameterAttribute(namespace, formulaName, context);
        if (StringUtils.isEmpty((String)formula, (boolean)true)) {
            return this.getParameterAttribute(namespace, name, context);
        }
        try {
            ParameterExpressionRuntime runtime = new ParameterExpressionRuntime(context, context.getParameterData());
            FormulaExpression fe = new FormulaExpression();
            fe.setFormula(formula);
            fe.setRuntime(runtime);
            Object res = fe.getValue();
            return String.valueOf(res);
        }
        catch (ReportProcessingException e) {
            return this.getParameterAttribute(namespace, name, context);
        }
    }
}

