/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.modules.parser.ext.readhandlers;

import java.awt.geom.Dimension2D;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Iterator;
import org.pentaho.reporting.engine.classic.core.layout.BandLayoutManager;
import org.pentaho.reporting.engine.classic.core.layout.StackedLayoutManager;
import org.pentaho.reporting.engine.classic.core.modules.parser.ext.factory.base.ObjectDescription;
import org.pentaho.reporting.engine.classic.core.modules.parser.ext.factory.base.ObjectFactoryException;
import org.pentaho.reporting.engine.classic.core.modules.parser.ext.factory.stylekey.StyleKeyFactory;
import org.pentaho.reporting.engine.classic.core.style.BandStyleKeys;
import org.pentaho.reporting.engine.classic.core.style.ElementStyleKeys;
import org.pentaho.reporting.engine.classic.core.style.ElementStyleSheet;
import org.pentaho.reporting.engine.classic.core.style.StyleKey;
import org.pentaho.reporting.libraries.base.config.Configuration;
import org.pentaho.reporting.libraries.xmlns.parser.RootXmlReadHandler;

public class ElementStyleSheetObjectDescription
implements ObjectDescription {
    private StyleKeyFactory keyfactory;
    private ElementStyleSheet styleSheet;

    @Override
    public void configure(Configuration config) {
    }

    public void init(RootXmlReadHandler rootHandler, ElementStyleSheet styleSheet) {
        this.keyfactory = (StyleKeyFactory)rootHandler.getHelperObject("::stylekey-factory");
        this.styleSheet = styleSheet;
    }

    @Override
    public Object createObject() {
        return this.styleSheet;
    }

    @Override
    public ObjectDescription getInstance() {
        throw new UnsupportedOperationException("This is a private factory, go away.");
    }

    @Override
    public Class getObjectClass() {
        return ElementStyleSheet.class;
    }

    @Override
    public Object getParameter(String name) {
        StyleKey key = this.keyfactory.getStyleKey(name);
        if (key == null) {
            throw new IllegalArgumentException("There is no handler for the stylekey: " + name);
        }
        return this.styleSheet.getStyleProperty(key);
    }

    @Override
    public Class getParameterDefinition(String name) {
        if ("layoutmanager".equals(name)) {
            return BandLayoutManager.class;
        }
        if ("absolute_pos".equals(name)) {
            return Point2D.class;
        }
        if ("border-top-left-radius".equals(name) || "border-top-right-radius".equals(name) || "border-bottom-left-radius".equals(name) || "border-bottom-right-radius".equals(name) || "min-size".equals(name) || "max-size".equals(name) || "preferred-size".equals(name)) {
            return Dimension2D.class;
        }
        StyleKey key = this.keyfactory.getStyleKey(name);
        if (key == null) {
            throw new IllegalArgumentException("There is no handler for the stylekey: " + name);
        }
        return key.getValueType();
    }

    @Override
    public Iterator getParameterNames() {
        return new ArrayList().iterator();
    }

    @Override
    public ObjectDescription getUnconfiguredInstance() {
        throw new UnsupportedOperationException("This is a private factory, go away.");
    }

    @Override
    public void setParameter(String name, Object value) {
        if ("layoutmanager".equals(name)) {
            if (value instanceof StackedLayoutManager) {
                this.styleSheet.setStyleProperty(BandStyleKeys.LAYOUT, "block");
            } else {
                this.styleSheet.setStyleProperty(BandStyleKeys.LAYOUT, null);
            }
            return;
        }
        if ("border-top-right-radius".equals(name)) {
            if (!(value instanceof Dimension2D)) {
                throw new IllegalArgumentException("There is no handler for the stylekey: " + name);
            }
            Dimension2D d = (Dimension2D)value;
            this.styleSheet.setStyleProperty(ElementStyleKeys.BORDER_TOP_RIGHT_RADIUS_WIDTH, new Float(d.getWidth()));
            this.styleSheet.setStyleProperty(ElementStyleKeys.BORDER_TOP_RIGHT_RADIUS_HEIGHT, new Float(d.getHeight()));
            return;
        }
        if ("border-top-left-radius".equals(name)) {
            if (!(value instanceof Dimension2D)) {
                throw new IllegalArgumentException("There is no handler for the stylekey: " + name);
            }
            Dimension2D d = (Dimension2D)value;
            this.styleSheet.setStyleProperty(ElementStyleKeys.BORDER_TOP_LEFT_RADIUS_WIDTH, new Float(d.getWidth()));
            this.styleSheet.setStyleProperty(ElementStyleKeys.BORDER_TOP_LEFT_RADIUS_HEIGHT, new Float(d.getHeight()));
            return;
        }
        if ("border-bottom-right-radius".equals(name)) {
            if (!(value instanceof Dimension2D)) {
                throw new IllegalArgumentException("There is no handler for the stylekey: " + name);
            }
            Dimension2D d = (Dimension2D)value;
            this.styleSheet.setStyleProperty(ElementStyleKeys.BORDER_BOTTOM_RIGHT_RADIUS_WIDTH, new Float(d.getWidth()));
            this.styleSheet.setStyleProperty(ElementStyleKeys.BORDER_BOTTOM_RIGHT_RADIUS_HEIGHT, new Float(d.getHeight()));
            return;
        }
        if ("border-bottom-left-radius".equals(name)) {
            if (!(value instanceof Dimension2D)) {
                throw new IllegalArgumentException("There is no handler for the stylekey: " + name);
            }
            Dimension2D d = (Dimension2D)value;
            this.styleSheet.setStyleProperty(ElementStyleKeys.BORDER_BOTTOM_LEFT_RADIUS_WIDTH, new Float(d.getWidth()));
            this.styleSheet.setStyleProperty(ElementStyleKeys.BORDER_BOTTOM_LEFT_RADIUS_HEIGHT, new Float(d.getHeight()));
            return;
        }
        if ("absolute_pos".equals(name)) {
            if (!(value instanceof Point2D)) {
                throw new IllegalArgumentException("There is no handler for the stylekey: " + name);
            }
            Point2D d = (Point2D)value;
            this.styleSheet.setStyleProperty(ElementStyleKeys.POS_X, new Float(d.getX()));
            this.styleSheet.setStyleProperty(ElementStyleKeys.POS_Y, new Float(d.getY()));
            return;
        }
        if ("min-size".equals(name)) {
            if (!(value instanceof Dimension2D)) {
                throw new IllegalArgumentException("There is no handler for the stylekey: " + name);
            }
            Dimension2D d = (Dimension2D)value;
            this.styleSheet.setStyleProperty(ElementStyleKeys.MIN_WIDTH, new Float(d.getWidth()));
            this.styleSheet.setStyleProperty(ElementStyleKeys.MIN_HEIGHT, new Float(d.getHeight()));
            return;
        }
        if ("max-size".equals(name)) {
            if (!(value instanceof Dimension2D)) {
                throw new IllegalArgumentException("There is no handler for the stylekey: " + name);
            }
            Dimension2D d = (Dimension2D)value;
            this.styleSheet.setStyleProperty(ElementStyleKeys.MAX_WIDTH, new Float(d.getWidth()));
            this.styleSheet.setStyleProperty(ElementStyleKeys.MAX_HEIGHT, new Float(d.getHeight()));
            return;
        }
        if ("preferred-size".equals(name)) {
            if (!(value instanceof Dimension2D)) {
                throw new IllegalArgumentException("There is no handler for the stylekey: " + name);
            }
            Dimension2D d = (Dimension2D)value;
            this.styleSheet.setStyleProperty(ElementStyleKeys.WIDTH, new Float(d.getWidth()));
            this.styleSheet.setStyleProperty(ElementStyleKeys.HEIGHT, new Float(d.getHeight()));
            return;
        }
        StyleKey key = this.keyfactory.getStyleKey(name);
        if (key == null) {
            throw new IllegalArgumentException("There is no handler for the stylekey: " + name);
        }
        this.styleSheet.setStyleProperty(key, value);
    }

    @Override
    public void setParameterFromObject(Object o) throws ObjectFactoryException {
        throw new UnsupportedOperationException("This is a private factory, go away.");
    }
}

