/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.modules.parser.base.common;

import java.io.IOException;
import java.util.Map;
import org.pentaho.reporting.engine.classic.core.function.Expression;
import org.pentaho.reporting.engine.classic.core.modules.parser.bundle.writer.BundleExpressionPropertyWriteHandler;
import org.pentaho.reporting.engine.classic.core.modules.parser.bundle.writer.BundleWriterException;
import org.pentaho.reporting.engine.classic.core.modules.parser.bundle.writer.BundleWriterState;
import org.pentaho.reporting.engine.classic.core.modules.parser.bundle.writer.ExpressionWriterUtility;
import org.pentaho.reporting.engine.classic.core.util.beans.BeanException;
import org.pentaho.reporting.engine.classic.core.util.beans.BeanUtility;
import org.pentaho.reporting.libraries.docbundle.WriteableDocumentBundle;
import org.pentaho.reporting.libraries.xmlns.common.AttributeList;
import org.pentaho.reporting.libraries.xmlns.writer.XmlWriter;

public class ExpressionMapPropertyWriteHandler
implements BundleExpressionPropertyWriteHandler {
    private WriteableDocumentBundle bundle;
    private BundleWriterState state;

    @Override
    public void initBundleContext(WriteableDocumentBundle bundle, BundleWriterState state) {
        this.bundle = bundle;
        this.state = state;
    }

    @Override
    public void writeExpressionParameter(XmlWriter writer, BeanUtility beanUtility, String propertyName, String namespaceUri) throws IOException, BeanException {
        Object property = beanUtility.getProperty(propertyName);
        if (property == null) {
            return;
        }
        if (!(property instanceof Map)) {
            throw new BeanException("Unexpected property type");
        }
        Map e = (Map)property;
        if (e.isEmpty()) {
            return;
        }
        Class propertyType = beanUtility.getPropertyType(propertyName);
        AttributeList attList = new AttributeList();
        attList.setAttribute(namespaceUri, "name", propertyName);
        if (!BeanUtility.isSameType(propertyType, property.getClass())) {
            attList.setAttribute(namespaceUri, "class", property.getClass().getName());
        }
        writer.writeTag(namespaceUri, "property", attList, false);
        for (Map.Entry entry : e.entrySet()) {
            Expression instance = ((Expression)entry.getValue()).getInstance();
            instance.setName((String)entry.getKey());
            try {
                ExpressionWriterUtility.writeExpression(this.bundle, this.state, instance, writer, namespaceUri, "expression");
            }
            catch (BundleWriterException ex) {
                throw new IOException("Unable to write nested expression", ex);
            }
        }
        writer.writeCloseTag();
    }
}

