/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.modules.parser.base;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.net.URL;
import java.util.HashMap;
import org.pentaho.reporting.engine.classic.core.MasterReport;
import org.pentaho.reporting.engine.classic.core.modules.parser.base.MasterReportXmlResourceFactory;
import org.pentaho.reporting.libraries.base.util.IOUtils;
import org.pentaho.reporting.libraries.base.util.MemoryByteArrayOutputStream;
import org.pentaho.reporting.libraries.resourceloader.FactoryParameterKey;
import org.pentaho.reporting.libraries.resourceloader.Resource;
import org.pentaho.reporting.libraries.resourceloader.ResourceCreationException;
import org.pentaho.reporting.libraries.resourceloader.ResourceException;
import org.pentaho.reporting.libraries.resourceloader.ResourceKey;
import org.pentaho.reporting.libraries.resourceloader.ResourceKeyCreationException;
import org.pentaho.reporting.libraries.resourceloader.ResourceLoadingException;
import org.pentaho.reporting.libraries.resourceloader.ResourceManager;
import org.xml.sax.InputSource;

public class ReportGenerator {
    public static final String PARSER_VALIDATE_KEY = "org.pentaho.reporting.engine.classic.core.modules.parser.base.Validate";
    public static final boolean PARSER_VALIDATE_DEFAULT = true;
    private static ReportGenerator generator;
    private HashMap helperObjects = new HashMap();
    private boolean validateDTD;

    protected ReportGenerator() {
    }

    public void setValidateDTD(boolean validate) {
        this.validateDTD = validate;
    }

    public boolean isValidateDTD() {
        return this.validateDTD;
    }

    public MasterReport parseReport(String file) throws IOException, ResourceException {
        if (file == null) {
            throw new NullPointerException("File may not be null");
        }
        return this.parseReport(new File(file));
    }

    public MasterReport parseReport(URL file) throws IOException, ResourceException {
        return this.parseReport(file, file);
    }

    public MasterReport parseReport(URL file, URL contentBase) throws ResourceException {
        return this.parse(file, contentBase);
    }

    private MasterReport parse(URL file, URL contentBase) throws ResourceException {
        ResourceManager resourceManager = new ResourceManager();
        ResourceKey contextKey = resourceManager.createKey((Object)contentBase);
        HashMap map = new HashMap();
        for (String name : this.helperObjects.keySet()) {
            map.put(new FactoryParameterKey(name), this.helperObjects.get(name));
        }
        ResourceKey key = resourceManager.createKey((Object)file, map);
        Resource resource = resourceManager.create(key, contextKey, MasterReport.class);
        return (MasterReport)resource.getResource();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] extractData(InputSource input) throws IOException {
        InputStream byteStream = input.getByteStream();
        if (byteStream != null) {
            try {
                MemoryByteArrayOutputStream bout = new MemoryByteArrayOutputStream();
                IOUtils.getInstance().copyStreams(byteStream, (OutputStream)bout);
                byte[] byArray = bout.toByteArray();
                return byArray;
            }
            finally {
                byteStream.close();
            }
        }
        Reader characterStream = input.getCharacterStream();
        if (characterStream == null) {
            throw new IOException("InputSource has neither an Byte nor a CharacterStream");
        }
        try {
            MemoryByteArrayOutputStream bout = new MemoryByteArrayOutputStream();
            OutputStreamWriter owriter = new OutputStreamWriter((OutputStream)bout);
            IOUtils.getInstance().copyWriter(characterStream, (Writer)owriter);
            owriter.close();
            byte[] byArray = bout.toByteArray();
            return byArray;
        }
        finally {
            characterStream.close();
        }
    }

    public MasterReport parseReport(File file) throws IOException, ResourceException {
        if (file == null) {
            throw new NullPointerException();
        }
        if (file.isDirectory()) {
            throw new IOException("File is not a directory.");
        }
        File contentBase = file.getCanonicalFile().getParentFile();
        ResourceManager resourceManager = new ResourceManager();
        ResourceKey contextKey = resourceManager.createKey((Object)contentBase);
        HashMap map = new HashMap();
        for (String name : this.helperObjects.keySet()) {
            map.put(new FactoryParameterKey(name), this.helperObjects.get(name));
        }
        ResourceKey key = resourceManager.createKey((Object)file, map);
        Resource resource = resourceManager.create(key, contextKey, MasterReport.class);
        return (MasterReport)resource.getResource();
    }

    public MasterReport parseReport(InputSource input, URL contentBase) throws IOException, ResourceException {
        if (input.getCharacterStream() != null) {
            return this.parseReportDirectly(input, contentBase);
        }
        byte[] bytes = this.extractData(input);
        ResourceManager resourceManager = new ResourceManager();
        ResourceKey contextKey = contentBase != null ? resourceManager.createKey((Object)contentBase) : null;
        HashMap map = new HashMap();
        for (String name : this.helperObjects.keySet()) {
            map.put(new FactoryParameterKey(name), this.helperObjects.get(name));
        }
        ResourceKey key = resourceManager.createKey((Object)bytes, map);
        Resource resource = resourceManager.create(key, contextKey, MasterReport.class);
        return (MasterReport)resource.getResource();
    }

    private MasterReport parseReportDirectly(InputSource input, URL contentBase) throws ResourceKeyCreationException, ResourceCreationException, ResourceLoadingException {
        ResourceManager manager = new ResourceManager();
        HashMap map = new HashMap();
        for (String name : this.helperObjects.keySet()) {
            map.put(new FactoryParameterKey(name), this.helperObjects.get(name));
        }
        MasterReportXmlResourceFactory resourceFactory = new MasterReportXmlResourceFactory();
        resourceFactory.initializeDefaults();
        if (contentBase != null) {
            return (MasterReport)resourceFactory.parseDirectly(manager, input, manager.createKey((Object)contentBase), map);
        }
        return (MasterReport)resourceFactory.parseDirectly(manager, input, null, map);
    }

    public MasterReport parseReport(ResourceManager manager, ResourceKey input, ResourceKey contextKey) throws ResourceException {
        if (manager == null) {
            manager = new ResourceManager();
        }
        HashMap map = new HashMap(input.getFactoryParameters());
        for (String name : this.helperObjects.keySet()) {
            map.put(new FactoryParameterKey(name), this.helperObjects.get(name));
        }
        ResourceKey key = new ResourceKey(input.getParent(), input.getSchema(), input.getIdentifier(), input.getFactoryParameters());
        Resource resource = manager.create(key, contextKey, MasterReport.class);
        return (MasterReport)resource.getResource();
    }

    public static synchronized ReportGenerator getInstance() {
        if (generator == null) {
            generator = new ReportGenerator();
        }
        return generator;
    }

    public static ReportGenerator createInstance() {
        return new ReportGenerator();
    }

    public void setObject(String key, Object value) {
        if (key == null) {
            throw new NullPointerException();
        }
        if (value == null) {
            this.helperObjects.remove(key);
        } else {
            this.helperObjects.put(key, value);
        }
    }

    public Object getObject(String key) {
        return this.helperObjects.get(key);
    }
}

