/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.function;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.reporting.engine.classic.core.DefaultImageReference;
import org.pentaho.reporting.engine.classic.core.event.PageEventListener;
import org.pentaho.reporting.engine.classic.core.event.ReportEvent;
import org.pentaho.reporting.engine.classic.core.function.AbstractFunction;
import org.pentaho.reporting.engine.classic.core.util.ComponentDrawable;
import org.pentaho.reporting.engine.classic.core.util.ImageUtils;
import org.pentaho.reporting.libraries.base.config.Configuration;

public class PaintDynamicComponentFunction
extends AbstractFunction
implements PageEventListener {
    private static final Log logger = LogFactory.getLog(PaintDynamicComponentFunction.class);
    private transient Image image;
    private String field;
    private float scale = 1.0f;

    public String getField() {
        return this.field;
    }

    public void setField(String field) {
        this.field = field;
    }

    @Override
    public void reportStarted(ReportEvent event) {
        this.image = null;
    }

    @Override
    public void reportInitialized(ReportEvent event) {
        this.image = null;
    }

    @Override
    public void reportFinished(ReportEvent event) {
        this.image = null;
    }

    @Override
    public void pageStarted(ReportEvent event) {
        this.image = null;
    }

    @Override
    public void pageFinished(ReportEvent event) {
        this.image = null;
    }

    @Override
    public void groupStarted(ReportEvent event) {
        this.image = null;
    }

    @Override
    public void groupFinished(ReportEvent event) {
        this.image = null;
    }

    @Override
    public void itemsAdvanced(ReportEvent event) {
        this.image = null;
    }

    private float getDeviceScale() {
        Configuration config = this.getReportConfiguration();
        String resolution = config.getConfigProperty("org.pentaho.reporting.engine.classic.core.layout.DeviceResolution");
        if (resolution == null) {
            return 1.0f;
        }
        try {
            return Float.parseFloat(resolution) / 72.0f;
        }
        catch (NumberFormatException nfe) {
            return 1.0f;
        }
    }

    private Image createComponentImage() {
        Object o = this.getDataRow().get(this.getField());
        if (!(o instanceof Component)) {
            return null;
        }
        float scale = this.getScale() * this.getDeviceScale();
        ComponentDrawable drawable = new ComponentDrawable();
        drawable.setComponent((Component)o);
        drawable.setAllowOwnPeer(true);
        drawable.setPaintSynchronized(true);
        Dimension dim = drawable.getSize();
        int width = Math.max(1, (int)(scale * (float)dim.width));
        int height = Math.max(1, (int)(scale * (float)dim.height));
        BufferedImage bi = ImageUtils.createTransparentImage(width, height);
        Graphics2D graph = bi.createGraphics();
        graph.setBackground(new Color(0, 0, 0, 0));
        graph.setTransform(AffineTransform.getScaleInstance(scale, scale));
        drawable.draw(graph, new Rectangle2D.Float(0.0f, 0.0f, dim.width, dim.height));
        graph.dispose();
        return bi;
    }

    @Override
    public Object getValue() {
        if (this.image == null) {
            this.image = this.createComponentImage();
        }
        if (this.image == null) {
            return null;
        }
        try {
            DefaultImageReference ref = new DefaultImageReference(this.image);
            ref.setScale(1.0f / this.getScale(), 1.0f / this.getScale());
            return ref;
        }
        catch (IOException e) {
            logger.warn((Object)"Unable to fully load a given image. (It should not happen here.)");
            return null;
        }
    }

    public void setScale(float scale) {
        this.scale = scale;
    }

    public float getScale() {
        return this.scale;
    }
}

