/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.elementfactory;

import java.awt.Color;
import java.awt.geom.Rectangle2D;
import org.pentaho.reporting.engine.classic.core.Element;
import org.pentaho.reporting.engine.classic.core.ElementAlignment;
import org.pentaho.reporting.engine.classic.core.elementfactory.ElementFactory;
import org.pentaho.reporting.engine.classic.core.elementfactory.TextElementFactory;
import org.pentaho.reporting.engine.classic.core.filter.types.MessageType;
import org.pentaho.reporting.engine.classic.core.style.FontDefinition;

public class MessageFieldElementFactory
extends TextElementFactory {
    private String formatString;
    private String nullString;
    private String messageNullString;

    public String getFormatString() {
        return this.formatString;
    }

    public void setFormatString(String formatString) {
        this.formatString = formatString;
    }

    public String getNullString() {
        return this.nullString;
    }

    public void setNullString(String nullString) {
        this.nullString = nullString;
    }

    public String getMessageNullString() {
        return this.messageNullString;
    }

    public void setMessageNullString(String messageNullString) {
        this.messageNullString = messageNullString;
    }

    @Override
    public Element createElement() {
        Element element = new Element();
        this.applyElementName(element);
        this.applyStyle(element.getStyle());
        element.setElementType(new MessageType());
        element.setAttribute("http://reporting.pentaho.org/namespaces/engine/attributes/core", "null-value", this.getNullString());
        element.setAttribute("http://reporting.pentaho.org/namespaces/engine/attributes/core", "message-null-value", this.getMessageNullString());
        element.setAttribute("http://reporting.pentaho.org/namespaces/engine/attributes/core", "value", this.getFormatString());
        return element;
    }

    public static Element createMessageElement(String name, Rectangle2D bounds, Color paint, ElementAlignment alignment, FontDefinition font, String nullString, String format) {
        return MessageFieldElementFactory.createMessageElement(name, bounds, paint, alignment, ElementAlignment.TOP, font, nullString, format);
    }

    public static Element createMessageElement(String name, Rectangle2D bounds, Color color, ElementAlignment alignment, ElementAlignment valign, FontDefinition font, String nullString, String formatString) {
        MessageFieldElementFactory factory = new MessageFieldElementFactory();
        factory.setX(new Float(bounds.getX()));
        factory.setY(new Float(bounds.getY()));
        factory.setMinimumWidth(new Float(bounds.getWidth()));
        factory.setMinimumHeight(new Float(bounds.getHeight()));
        factory.setName(name);
        factory.setColor(color);
        factory.setHorizontalAlignment(alignment);
        factory.setVerticalAlignment(valign);
        if (font != null) {
            factory.setFontName(font.getFontName());
            factory.setFontSize(new Integer(font.getFontSize()));
            factory.setBold(ElementFactory.getBooleanValue(font.isBold()));
            factory.setItalic(ElementFactory.getBooleanValue(font.isItalic()));
            factory.setEncoding(font.getFontEncoding(null));
            factory.setUnderline(ElementFactory.getBooleanValue(font.isUnderline()));
            factory.setStrikethrough(ElementFactory.getBooleanValue(font.isStrikeThrough()));
            factory.setEmbedFont(ElementFactory.getBooleanValue(font.isEmbeddedFont()));
        }
        factory.setNullString(nullString);
        factory.setFormatString(formatString);
        return factory.createElement();
    }
}

