/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.formula.function.math;

import java.math.BigDecimal;
import org.pentaho.reporting.libraries.formula.EvaluationException;
import org.pentaho.reporting.libraries.formula.FormulaContext;
import org.pentaho.reporting.libraries.formula.LibFormulaErrorValue;
import org.pentaho.reporting.libraries.formula.function.Function;
import org.pentaho.reporting.libraries.formula.function.ParameterCallback;
import org.pentaho.reporting.libraries.formula.lvalues.TypeValuePair;
import org.pentaho.reporting.libraries.formula.typing.NumberSequence;
import org.pentaho.reporting.libraries.formula.typing.Type;
import org.pentaho.reporting.libraries.formula.typing.coretypes.NumberType;
import org.pentaho.reporting.libraries.formula.util.NumberUtil;

public class SumFunction
implements Function {
    private static final long serialVersionUID = -8604838130517819412L;

    @Override
    public String getCanonicalName() {
        return "SUM";
    }

    protected boolean isStrictSequenceNeeded() {
        return true;
    }

    @Override
    public TypeValuePair evaluate(FormulaContext context, ParameterCallback parameters) throws EvaluationException {
        BigDecimal computedResult = BigDecimal.ZERO;
        int parameterCount = parameters.getParameterCount();
        if (parameterCount == 0) {
            throw EvaluationException.getInstance(LibFormulaErrorValue.ERROR_ARGUMENTS_VALUE);
        }
        for (int paramIdx = 0; paramIdx < parameterCount; ++paramIdx) {
            NumberSequence sequence = this.convertToNumberSequence(context, parameters, paramIdx);
            while (sequence.hasNext()) {
                computedResult = this.compute(sequence.nextNumber(), computedResult);
            }
        }
        return new TypeValuePair(NumberType.GENERIC_NUMBER, computedResult);
    }

    protected NumberSequence convertToNumberSequence(FormulaContext context, ParameterCallback parameters, int paramIdx) throws EvaluationException {
        Type type = parameters.getType(paramIdx);
        Object value = parameters.getValue(paramIdx);
        return context.getTypeRegistry().convertToNumberSequence(type, value, this.isStrictSequenceNeeded());
    }

    private BigDecimal compute(Number value, BigDecimal computedResult) {
        if (value == null) {
            return computedResult;
        }
        return computedResult.add(NumberUtil.getAsBigDecimal(value));
    }
}

