/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.docbundle.bundleloader;

import java.util.HashMap;
import java.util.Map;
import org.pentaho.reporting.libraries.docbundle.BundleUtilities;
import org.pentaho.reporting.libraries.docbundle.LibDocBundleBoot;
import org.pentaho.reporting.libraries.docbundle.bundleloader.RepositoryResourceBundleData;
import org.pentaho.reporting.libraries.repository.ContentIOException;
import org.pentaho.reporting.libraries.repository.Repository;
import org.pentaho.reporting.libraries.repository.RepositoryUtilities;
import org.pentaho.reporting.libraries.resourceloader.FactoryParameterKey;
import org.pentaho.reporting.libraries.resourceloader.ParameterKey;
import org.pentaho.reporting.libraries.resourceloader.ResourceBundleData;
import org.pentaho.reporting.libraries.resourceloader.ResourceBundleLoader;
import org.pentaho.reporting.libraries.resourceloader.ResourceException;
import org.pentaho.reporting.libraries.resourceloader.ResourceKey;
import org.pentaho.reporting.libraries.resourceloader.ResourceKeyCreationException;
import org.pentaho.reporting.libraries.resourceloader.ResourceKeyData;
import org.pentaho.reporting.libraries.resourceloader.ResourceKeyUtils;
import org.pentaho.reporting.libraries.resourceloader.ResourceLoadingException;
import org.pentaho.reporting.libraries.resourceloader.ResourceManager;
import org.pentaho.reporting.libraries.resourceloader.loader.LoaderUtils;

public class RepositoryResourceBundleLoader
implements ResourceBundleLoader {
    private static final String INNER_SCHEMA = RepositoryResourceBundleLoader.class.getName();
    public static final String SCHEMA = INNER_SCHEMA + ":bundlekey";
    private Repository repository;
    private ResourceKey bundleKey;
    private ResourceKey mainKey;

    public RepositoryResourceBundleLoader(Repository repository, ResourceKey outsideContextKey) {
        if (repository == null) {
            throw new NullPointerException();
        }
        this.repository = repository;
        HashMap<FactoryParameterKey, Object> map = new HashMap<FactoryParameterKey, Object>();
        map.put(new FactoryParameterKey("repository"), repository);
        map.put(new FactoryParameterKey("repository-loader"), this);
        this.bundleKey = new ResourceKey(outsideContextKey, (Object)SCHEMA, new Object(), map);
        String bundleType = BundleUtilities.getBundleType(repository);
        String bundleMapping = BundleUtilities.getBundleMapping(bundleType);
        if (bundleMapping == null) {
            throw new IllegalStateException("Invalid configuration: No Bundle-Mapping for the bundle-type " + bundleType);
        }
        this.mainKey = new ResourceKey(this.bundleKey, (Object)INNER_SCHEMA, (Object)bundleMapping, null);
    }

    public ResourceBundleData loadBundle(ResourceManager resourceManager, ResourceKey key) throws ResourceLoadingException {
        if (key == null) {
            throw new NullPointerException();
        }
        if (resourceManager == null) {
            throw new NullPointerException();
        }
        if (!this.bundleKey.equals((Object)key)) {
            return null;
        }
        return new RepositoryResourceBundleData(this.bundleKey, this.repository, this.mainKey, false);
    }

    public ResourceKey getMainKey() {
        return this.mainKey;
    }

    public boolean isSupportedKey(ResourceKey key) {
        if (key == null) {
            throw new NullPointerException();
        }
        if (this.bundleKey.equals((Object)key)) {
            return true;
        }
        return this.bundleKey.equals((Object)key.getParent());
    }

    public ResourceKey deriveKey(ResourceKey parent, String path, Map<? extends ParameterKey, ? extends Object> factoryKeys) throws ResourceKeyCreationException {
        HashMap<? extends ParameterKey, ? extends Object> map;
        if (parent == null) {
            throw new NullPointerException();
        }
        if (!this.isSupportedKey(parent)) {
            throw new ResourceKeyCreationException("Assertation: Unsupported parent key type");
        }
        String identifier = (String)parent.getIdentifier();
        String entry = path != null ? (path.length() > 0 && path.charAt(0) == '/' ? LoaderUtils.stripLeadingSlashes((String)path) : LoaderUtils.mergePaths((String)identifier, (String)path)) : identifier;
        if (factoryKeys != null) {
            map = new HashMap<ParameterKey, Object>();
            map.putAll(parent.getFactoryParameters());
            map.putAll(factoryKeys);
        } else {
            map = parent.getFactoryParameters();
        }
        if ("true".equals(LibDocBundleBoot.getInstance().getGlobalConfig().getConfigProperty("org.pentaho.reporting.libraries.docbundle.bundleloader.repository.StrictKeyCheck", "true"))) {
            try {
                String[] name = RepositoryUtilities.split((String)entry, (String)"/");
                if (!RepositoryUtilities.isExistsEntity((Repository)this.repository, (String[])name)) {
                    throw new ResourceKeyCreationException("The derived entry does not exist in this bundle.");
                }
            }
            catch (ContentIOException e) {
                throw new ResourceKeyCreationException("Error checking whether the derived entry exists in the bundle.");
            }
        }
        return new ResourceKey(parent.getParent(), parent.getSchema(), (Object)entry, map);
    }

    public String serialize(ResourceKey bundleKey, ResourceKey key) throws ResourceException {
        if (key == null) {
            throw new NullPointerException("The ResourceKey can not be null");
        }
        if (!this.isSupportedKey(key)) {
            throw new IllegalArgumentException("Key format is not recognized.");
        }
        if (!(key.getIdentifier() instanceof String)) {
            throw new IllegalArgumentException("ResourceKey is invalid - identifier is not a byte[] object");
        }
        String data = (String)key.getIdentifier();
        return ResourceKeyUtils.createStringResourceKey((String)String.valueOf(key.getSchema()), (String)data, (Map)key.getFactoryParameters());
    }

    public ResourceKey deserialize(ResourceKey bundleKey, String stringKey) throws ResourceKeyCreationException {
        ResourceKeyData resourceKeyData = ResourceKeyUtils.parse((String)stringKey);
        if (!INNER_SCHEMA.equals(resourceKeyData.getSchema())) {
            throw new ResourceKeyCreationException("Serialized version of key does not contain correct schema");
        }
        return new ResourceKey(bundleKey, (Object)resourceKeyData.getSchema(), (Object)resourceKeyData.getIdentifier(), resourceKeyData.getFactoryParameters());
    }

    public boolean isSupportedDeserializer(String data) throws ResourceKeyCreationException {
        ResourceKeyData resourceKeyData = ResourceKeyUtils.parse((String)data);
        return INNER_SCHEMA.equals(resourceKeyData.getSchema());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RepositoryResourceBundleLoader that = (RepositoryResourceBundleLoader)o;
        return this.repository.equals(that.repository);
    }

    public int hashCode() {
        return this.repository.hashCode();
    }
}

