/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.docbundle.bundleloader;

import java.util.Map;
import org.pentaho.reporting.libraries.docbundle.LibDocBundleBoot;
import org.pentaho.reporting.libraries.docbundle.bundleloader.RepositoryResourceBundleLoader;
import org.pentaho.reporting.libraries.repository.ContentIOException;
import org.pentaho.reporting.libraries.repository.Repository;
import org.pentaho.reporting.libraries.repository.RepositoryUtilities;
import org.pentaho.reporting.libraries.resourceloader.FactoryParameterKey;
import org.pentaho.reporting.libraries.resourceloader.ResourceBundleData;
import org.pentaho.reporting.libraries.resourceloader.ResourceBundleLoader;
import org.pentaho.reporting.libraries.resourceloader.ResourceException;
import org.pentaho.reporting.libraries.resourceloader.ResourceKey;
import org.pentaho.reporting.libraries.resourceloader.ResourceKeyCreationException;
import org.pentaho.reporting.libraries.resourceloader.ResourceLoadingException;
import org.pentaho.reporting.libraries.resourceloader.ResourceManager;

public class MemoryResourceBundleLoader
implements ResourceBundleLoader {
    public ResourceBundleData loadBundle(ResourceManager resourceManager, ResourceKey key) throws ResourceLoadingException {
        if (!this.isSupportedKey(key)) {
            return null;
        }
        RepositoryResourceBundleLoader o = (RepositoryResourceBundleLoader)key.getFactoryParameters().get(new FactoryParameterKey("repository-loader"));
        return o.loadBundle(resourceManager, key);
    }

    public boolean isSupportedKey(ResourceKey key) {
        return RepositoryResourceBundleLoader.SCHEMA.equals(key.getSchema());
    }

    public ResourceKey deriveKey(ResourceKey parent, String path, Map factoryKeys) throws ResourceKeyCreationException {
        if (!this.isSupportedKey(parent)) {
            throw new ResourceKeyCreationException();
        }
        RepositoryResourceBundleLoader o = (RepositoryResourceBundleLoader)parent.getFactoryParameters().get(new FactoryParameterKey("repository-loader"));
        if ("true".equals(LibDocBundleBoot.getInstance().getGlobalConfig().getConfigProperty("org.pentaho.reporting.libraries.docbundle.bundleloader.memory.StrictKeyCheck", "true"))) {
            try {
                Repository repository = (Repository)parent.getFactoryParameters().get(new FactoryParameterKey("repository"));
                if (!RepositoryUtilities.isExistsEntity((Repository)repository, (String[])RepositoryUtilities.split((String)path, (String)"/"))) {
                    throw new ResourceKeyCreationException("The key does not exist: " + path);
                }
            }
            catch (ContentIOException e) {
                throw new ResourceKeyCreationException("Failed to check for existing key", (Exception)((Object)e));
            }
        }
        return o.deriveKey(parent, path, factoryKeys);
    }

    public String serialize(ResourceKey bundleKey, ResourceKey key) throws ResourceException {
        return null;
    }

    public ResourceKey deserialize(ResourceKey bundleKey, String stringKey) throws ResourceKeyCreationException {
        return null;
    }

    public boolean isSupportedDeserializer(String data) throws ResourceKeyCreationException {
        return false;
    }

    public int hashCode() {
        return this.getClass().hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        return obj.getClass() == this.getClass();
    }
}

