/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.core.row;

import java.util.Date;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.di.core.exception.KettleValueException;
import org.pentaho.di.core.row.RowMeta;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.row.value.ValueMetaBoolean;
import org.pentaho.di.core.row.value.ValueMetaDate;
import org.pentaho.di.core.row.value.ValueMetaInteger;
import org.pentaho.di.core.row.value.ValueMetaNumber;
import org.pentaho.di.core.row.value.ValueMetaString;
import org.pentaho.di.core.util.StringUtil;

public class SpeedTest {
    private static final Log log = LogFactory.getLog(SpeedTest.class);
    private Object[] rowString10 = new Object[10];
    private Object[] rowString100 = new Object[100];
    private Object[] rowString1000 = new Object[1000];
    private Object[] rowMixed10 = new Object[50];
    private Object[] rowMixed100 = new Object[500];
    private Object[] rowMixed1000 = new Object[5000];
    private RowMetaInterface metaString10 = new RowMeta();
    private RowMetaInterface metaMixed10 = new RowMeta();
    private RowMetaInterface metaString100 = new RowMeta();
    private RowMetaInterface metaMixed100 = new RowMeta();
    private RowMetaInterface metaString1000 = new RowMeta();
    private RowMetaInterface metaMixed1000 = new RowMeta();
    public static final int ITERATIONS = 1000000;

    public SpeedTest() {
        int i;
        for (i = 0; i < 10; ++i) {
            SpeedTest.populateMetaAndData(i, this.rowString10, this.metaString10, this.rowMixed10, this.metaMixed10);
        }
        for (i = 0; i < 100; ++i) {
            SpeedTest.populateMetaAndData(i, this.rowString100, this.metaString100, this.rowMixed100, this.metaMixed100);
        }
        for (i = 0; i < 1000; ++i) {
            SpeedTest.populateMetaAndData(i, this.rowString1000, this.metaString1000, this.rowMixed1000, this.metaMixed1000);
        }
    }

    private static void populateMetaAndData(int i, Object[] rowString10, RowMetaInterface metaString10, Object[] rowMixed10, RowMetaInterface metaMixed10) {
        String strNamePrefix = "String";
        rowString10[i] = StringUtil.generateRandomString(20, "", "", false);
        ValueMetaString meta = new ValueMetaString(strNamePrefix + (i + 1), 20, 0);
        metaString10.addValueMeta(meta);
        rowMixed10[i * 5 + 0] = StringUtil.generateRandomString(20, "", "", false);
        ValueMetaString meta0 = new ValueMetaString(strNamePrefix + (i * 5 + 1), 20, 0);
        metaMixed10.addValueMeta(meta0);
        rowMixed10[i * 5 + 1] = new Date();
        ValueMetaDate meta1 = new ValueMetaDate(strNamePrefix + (i * 5 + 1));
        metaMixed10.addValueMeta(meta1);
        rowMixed10[i * 5 + 2] = Math.random() * 1000000.0;
        ValueMetaNumber meta2 = new ValueMetaNumber(strNamePrefix + (i * 5 + 1), 12, 4);
        metaMixed10.addValueMeta(meta2);
        rowMixed10[i * 5 + 3] = (long)(Math.random() * 1000000.0);
        ValueMetaInteger meta3 = new ValueMetaInteger(strNamePrefix + (i * 5 + 1), 8, 0);
        metaMixed10.addValueMeta(meta3);
        rowMixed10[i * 5 + 4] = Math.random() > 0.5;
        ValueMetaBoolean meta4 = new ValueMetaBoolean(strNamePrefix + (i * 5 + 1));
        metaMixed10.addValueMeta(meta4);
    }

    public long runTestStrings10(int iterations) throws KettleValueException {
        long startTime = System.currentTimeMillis();
        for (int i = 0; i < iterations; ++i) {
            this.metaString10.cloneRow(this.rowString10);
        }
        long stopTime = System.currentTimeMillis();
        return stopTime - startTime;
    }

    public long runTestMixed10(int iterations) throws KettleValueException {
        long startTime = System.currentTimeMillis();
        for (int i = 0; i < iterations; ++i) {
            this.metaMixed10.cloneRow(this.rowMixed10);
        }
        long stopTime = System.currentTimeMillis();
        return stopTime - startTime;
    }

    public long runTestStrings100(int iterations) throws KettleValueException {
        long startTime = System.currentTimeMillis();
        for (int i = 0; i < iterations; ++i) {
            this.metaString100.cloneRow(this.rowString100);
        }
        long stopTime = System.currentTimeMillis();
        return stopTime - startTime;
    }

    public long runTestMixed100(int iterations) throws KettleValueException {
        long startTime = System.currentTimeMillis();
        for (int i = 0; i < iterations; ++i) {
            this.metaMixed100.cloneRow(this.rowMixed100);
        }
        long stopTime = System.currentTimeMillis();
        return stopTime - startTime;
    }

    public long runTestStrings1000(int iterations) throws KettleValueException {
        long startTime = System.currentTimeMillis();
        for (int i = 0; i < iterations; ++i) {
            this.metaString1000.cloneRow(this.rowString1000);
        }
        long stopTime = System.currentTimeMillis();
        return stopTime - startTime;
    }

    public long runTestMixed1000(int iterations) throws KettleValueException {
        long startTime = System.currentTimeMillis();
        for (int i = 0; i < iterations; ++i) {
            this.metaMixed1000.cloneRow(this.rowMixed1000);
        }
        long stopTime = System.currentTimeMillis();
        return stopTime - startTime;
    }

    public static void main(String[] args) throws KettleValueException {
        SpeedTest speedTest = new SpeedTest();
        String strTimesPrefix = " times : ";
        String strMsPrefix = " ms (";
        String strRowPerSec = " r/s)\n";
        StringBuilder runtimeTestMessage = new StringBuilder();
        long timeString10 = speedTest.runTestStrings10(1000000);
        runtimeTestMessage.append("\nTime to run 'String10' test 1000000" + strTimesPrefix + timeString10 + strMsPrefix + 1000000000L / timeString10 + strRowPerSec);
        long timeMixed10 = speedTest.runTestMixed10(1000000);
        runtimeTestMessage.append("Time to run 'Mixed10' test 1000000" + strTimesPrefix + timeMixed10 + strMsPrefix + 1000000000L / timeMixed10 + strRowPerSec);
        long timeString100 = speedTest.runTestStrings100(1000000);
        runtimeTestMessage.append("Time to run 'String100' test 1000000" + strTimesPrefix + timeString100 + strMsPrefix + 1000000000L / timeString100 + strRowPerSec);
        long timeMixed100 = speedTest.runTestMixed100(1000000);
        runtimeTestMessage.append("Time to run 'Mixed100' test 1000000" + strTimesPrefix + timeMixed100 + strMsPrefix + 1000000000L / timeMixed100 + strRowPerSec);
        long timeString1000 = speedTest.runTestStrings1000(1000000);
        runtimeTestMessage.append("Time to run 'String1000' test 1000000" + strTimesPrefix + timeString1000 + strMsPrefix + 1000000000L / timeString1000 + strRowPerSec);
        long timeMixed1000 = speedTest.runTestMixed1000(1000000);
        runtimeTestMessage.append("Time to run 'Mixed1000' test 1000000" + strTimesPrefix + timeMixed1000 + strMsPrefix + 1000000000L / timeMixed1000 + strRowPerSec);
        log.info((Object)runtimeTestMessage);
    }
}

