/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.core.plugins;

import java.io.File;
import java.io.FileInputStream;
import java.net.URL;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.plugins.PluginTypeInterface;

public interface PluginInterface {
    public String[] getIds();

    public Class<? extends PluginTypeInterface> getPluginType();

    public Class<?> getMainType();

    public List<String> getLibraries();

    public String getName();

    public String getDescription();

    public String getImageFile();

    public void setImageFile(String var1);

    public String getCategory();

    public boolean isSeparateClassLoaderNeeded();

    public boolean isNativePlugin();

    public Map<Class<?>, String> getClassMap();

    public boolean matches(String var1);

    public String getErrorHelpFile();

    public void setErrorHelpFile(String var1);

    public URL getPluginDirectory();

    public String getDocumentationUrl();

    public void setDocumentationUrl(String var1);

    public String getCasesUrl();

    public void setCasesUrl(String var1);

    public String getForumUrl();

    public void setForumUrl(String var1);

    public String getClassLoaderGroup();

    public void setSuggestion(String var1);

    public String getSuggestion();

    public void setClassLoaderGroup(String var1);

    default public void merge(PluginInterface fragment) {
        if (fragment != null) {
            Optional.ofNullable(fragment.getClassMap()).ifPresent(this.getClassMap()::putAll);
            Optional.ofNullable(fragment.getImageFile()).ifPresent(this::setImageFile);
            Optional.ofNullable(fragment.getLibraries()).ifPresent(this.getLibraries()::addAll);
            Optional.ofNullable(fragment.getErrorHelpFile()).ifPresent(this::setErrorHelpFile);
            Optional.ofNullable(fragment.getDocumentationUrl()).ifPresent(this::setDocumentationUrl);
            Optional.ofNullable(fragment.getCasesUrl()).ifPresent(this::setCasesUrl);
            Optional.ofNullable(fragment.getForumUrl()).ifPresent(this::setForumUrl);
            Optional.ofNullable(fragment.getClassLoaderGroup()).ifPresent(this::setClassLoaderGroup);
        }
    }

    default public Properties getPluginProperties() throws KettleException {
        String pluginPropsFilePath = this.getPluginDirectory().getPath() + "/plugin.properties";
        File pluginPropsFile = new File(pluginPropsFilePath);
        if (!pluginPropsFile.exists()) {
            return null;
        }
        Properties pluginProps = new Properties();
        try {
            pluginProps.load(new FileInputStream(pluginPropsFile));
        }
        catch (Exception e) {
            throw new KettleException("Plugin's plugin.properties file could not be read.", e);
        }
        return pluginProps;
    }
}

