/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.core.database;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang.StringUtils;

public class SqlScriptParser {
    private boolean usingBackslashAsEscapeCharForQuotation;

    public SqlScriptParser(boolean usingBackslashAsEscapeCharForQuotation) {
        this.usingBackslashAsEscapeCharForQuotation = usingBackslashAsEscapeCharForQuotation;
    }

    public List<String> split(String script) {
        String st;
        if (script == null) {
            return Collections.emptyList();
        }
        ArrayList<String> result = new ArrayList<String>();
        MODE mode = MODE.SQL;
        char currentStringChar = '\u0000';
        int statementStart = 0;
        block12: for (int i = 0; i < script.length(); ++i) {
            char ch = script.charAt(i);
            char nextCh = i < script.length() - 1 ? script.charAt(i + 1) : (char)'\u0000';
            switch (mode) {
                case SQL: {
                    switch (ch) {
                        case '/': {
                            if (nextCh != '*') break;
                            mode = MODE.BLOCK_COMMENT;
                            ++i;
                            break;
                        }
                        case '-': {
                            if (nextCh != '-') break;
                            mode = MODE.LINE_COMMENT;
                            ++i;
                            break;
                        }
                        case '\"': 
                        case '\'': {
                            mode = MODE.STRING;
                            currentStringChar = ch;
                            break;
                        }
                        case ';': {
                            String st2 = script.substring(statementStart, i);
                            if (StringUtils.isNotBlank((String)st2)) {
                                result.add(st2);
                            }
                            statementStart = i + 1;
                        }
                    }
                    continue block12;
                }
                case BLOCK_COMMENT: {
                    if (ch != '*' || nextCh != '/') continue block12;
                    mode = MODE.SQL;
                    ++i;
                    continue block12;
                }
                case LINE_COMMENT: {
                    if (ch != '\n' && ch != '\r') continue block12;
                    mode = MODE.SQL;
                    continue block12;
                }
                case STRING: {
                    if (ch == '\\' && nextCh == '\\') {
                        ++i;
                        continue block12;
                    }
                    if (ch == '\\' && nextCh == currentStringChar && this.usingBackslashAsEscapeCharForQuotation) {
                        ++i;
                        continue block12;
                    }
                    if (ch != currentStringChar) continue block12;
                    mode = MODE.SQL;
                }
            }
        }
        if (statementStart < script.length() && StringUtils.isNotBlank((String)(st = script.substring(statementStart)))) {
            result.add(st);
        }
        return result;
    }

    public String removeComments(String script) {
        if (script == null) {
            return null;
        }
        StringBuilder result = new StringBuilder();
        MODE mode = MODE.SQL;
        char currentStringChar = '\u0000';
        for (int i = 0; i < script.length(); ++i) {
            char ch = script.charAt(i);
            char nextCh = i < script.length() - 1 ? script.charAt(i + 1) : (char)'\u0000';
            char nextPlusOneCh = i < script.length() - 2 ? script.charAt(i + 2) : (char)'\u0000';
            switch (mode) {
                case SQL: {
                    switch (ch) {
                        case '/': {
                            if (nextCh != '*' || nextPlusOneCh == '+') break;
                            mode = MODE.BLOCK_COMMENT;
                            ++i;
                            ch = '\u0000';
                            break;
                        }
                        case '-': {
                            if (nextCh != '-') break;
                            mode = MODE.LINE_COMMENT;
                            ++i;
                            ch = '\u0000';
                            break;
                        }
                        case '\"': 
                        case '\'': {
                            mode = MODE.STRING;
                            currentStringChar = ch;
                        }
                    }
                    break;
                }
                case BLOCK_COMMENT: {
                    if (ch == '*' && nextCh == '/') {
                        mode = MODE.SQL;
                        ++i;
                    }
                    ch = '\u0000';
                    break;
                }
                case LINE_COMMENT: {
                    if (ch == '\n' || ch == '\r') {
                        mode = MODE.SQL;
                        break;
                    }
                    ch = '\u0000';
                    break;
                }
                case STRING: {
                    if (ch == '\\' && nextCh == currentStringChar && this.usingBackslashAsEscapeCharForQuotation) {
                        result.append(ch);
                        result.append(nextCh);
                        ch = '\u0000';
                        ++i;
                        break;
                    }
                    if (ch != currentStringChar) break;
                    mode = MODE.SQL;
                }
            }
            if (ch == '\u0000') continue;
            result.append(ch);
        }
        return result.toString();
    }

    static enum MODE {
        SQL,
        LINE_COMMENT,
        BLOCK_COMMENT,
        STRING;

    }
}

