/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.core.database;

import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.Map;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.database.BaseDatabaseMeta;
import org.pentaho.di.core.database.DatabaseInterface;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.exception.KettleValueException;
import org.pentaho.di.core.row.ValueMetaInterface;

public class GenericDatabaseMeta
extends BaseDatabaseMeta
implements DatabaseInterface {
    public static final String ATRRIBUTE_CUSTOM_URL = "CUSTOM_URL";
    public static final String ATRRIBUTE_CUSTOM_DRIVER_CLASS = "CUSTOM_DRIVER_CLASS";
    public static final String DATABASE_DIALECT_ID = "DATABASE_DIALECT_ID";
    private DatabaseInterface databaseDialect = null;

    @Override
    public void addAttribute(String attributeId, String value) {
        super.addAttribute(attributeId, value);
        if (DATABASE_DIALECT_ID.equals(attributeId)) {
            this.resolveDialect(value);
        }
    }

    @Override
    public int[] getAccessTypeList() {
        return new int[]{0, 1, 4};
    }

    @Override
    public int getNotFoundTK(boolean useAutoinc) {
        if (this.supportsAutoInc() && useAutoinc) {
            return 1;
        }
        return super.getNotFoundTK(useAutoinc);
    }

    @Override
    public String getDriverClass() {
        if (this.getAccessType() == 0) {
            String driverClass = this.getAttributes().getProperty(ATRRIBUTE_CUSTOM_DRIVER_CLASS, "");
            return driverClass;
        }
        return "sun.jdbc.odbc.JdbcOdbcDriver";
    }

    @Override
    public String getURL(String hostname, String port, String databaseName) {
        if (this.getAccessType() == 0) {
            String url = this.getAttributes().getProperty(ATRRIBUTE_CUSTOM_URL, "");
            return url;
        }
        return "jdbc:odbc:" + databaseName;
    }

    @Override
    public boolean isFetchSizeSupported() {
        return false;
    }

    @Override
    public boolean supportsBitmapIndex() {
        return false;
    }

    @Override
    public String getTruncateTableStatement(String tableName) {
        if (this.databaseDialect != null) {
            return this.databaseDialect.getTruncateTableStatement(tableName);
        }
        return "DELETE FROM " + tableName;
    }

    @Override
    public String getAddColumnStatement(String tablename, ValueMetaInterface v, String tk, boolean useAutoinc, String pk, boolean semicolon) {
        if (this.databaseDialect != null) {
            return this.databaseDialect.getAddColumnStatement(tablename, v, tk, useAutoinc, pk, semicolon);
        }
        return "ALTER TABLE " + tablename + " ADD " + this.getFieldDefinition(v, tk, pk, useAutoinc, true, false);
    }

    @Override
    public String getModifyColumnStatement(String tablename, ValueMetaInterface v, String tk, boolean useAutoinc, String pk, boolean semicolon) {
        if (this.databaseDialect != null) {
            return this.databaseDialect.getModifyColumnStatement(tablename, v, tk, useAutoinc, pk, semicolon);
        }
        return "ALTER TABLE " + tablename + " MODIFY " + this.getFieldDefinition(v, tk, pk, useAutoinc, true, false);
    }

    @Override
    public String getFieldDefinition(ValueMetaInterface v, String tk, String pk, boolean useAutoinc, boolean addFieldName, boolean addCr) {
        if (this.databaseDialect != null) {
            return this.databaseDialect.getFieldDefinition(v, tk, pk, useAutoinc, addFieldName, addCr);
        }
        String retval = "";
        String fieldname = v.getName();
        int length = v.getLength();
        int precision = v.getPrecision();
        if (addFieldName) {
            retval = retval + fieldname + " ";
        }
        int type = v.getType();
        switch (type) {
            case 3: 
            case 9: {
                retval = retval + "TIMESTAMP";
                break;
            }
            case 4: {
                if (this.supportsBooleanDataType()) {
                    retval = retval + "BOOLEAN";
                    break;
                }
                retval = retval + "CHAR(1)";
                break;
            }
            case 1: 
            case 5: 
            case 6: {
                if (fieldname.equalsIgnoreCase(tk) || fieldname.equalsIgnoreCase(pk)) {
                    retval = retval + "BIGSERIAL";
                    break;
                }
                if (length > 0) {
                    if (precision > 0 || length > 18) {
                        retval = retval + "NUMERIC(" + length + ", " + precision + ")";
                        break;
                    }
                    if (length > 9) {
                        retval = retval + "BIGINT";
                        break;
                    }
                    if (length < 5) {
                        retval = retval + "SMALLINT";
                        break;
                    }
                    retval = retval + "INTEGER";
                    break;
                }
                retval = retval + "DOUBLE PRECISION";
                break;
            }
            case 2: {
                if (length >= 9999999) {
                    retval = retval + "TEXT";
                    break;
                }
                retval = retval + "VARCHAR";
                retval = length > 0 ? retval + "(" + length : retval + "(";
                retval = retval + ")";
                break;
            }
            default: {
                retval = retval + " UNKNOWN";
            }
        }
        if (addCr) {
            retval = retval + Const.CR;
        }
        return retval;
    }

    @Override
    public String[] getUsedLibraries() {
        return new String[0];
    }

    @Override
    public boolean supportsPreparedStatementMetadataRetrieval() {
        if (this.databaseDialect != null) {
            return this.databaseDialect.supportsPreparedStatementMetadataRetrieval();
        }
        return false;
    }

    @Override
    public String getSQLInsertAutoIncUnknownDimensionRow(String schemaTable, String keyField, String versionField) {
        if (this.databaseDialect != null) {
            return this.databaseDialect.getSQLInsertAutoIncUnknownDimensionRow(schemaTable, keyField, versionField);
        }
        return "insert into " + schemaTable + "(" + versionField + ") values (1)";
    }

    public void setDatabaseDialect(String databaseDialect) {
        super.addAttribute(DATABASE_DIALECT_ID, databaseDialect);
        this.resolveDialect(databaseDialect);
    }

    public String getDatabaseDialect() {
        return super.getAttribute(DATABASE_DIALECT_ID, this.getPluginName());
    }

    private void resolveDialect(String dialectName) {
        if (dialectName == null) {
            return;
        }
        if (dialectName.equals(this.getPluginName())) {
            this.databaseDialect = null;
        } else {
            DatabaseInterface[] dialects;
            for (DatabaseInterface dialect : dialects = DatabaseMeta.getDatabaseInterfaces()) {
                if (!dialectName.equals(dialect.getPluginName())) continue;
                this.databaseDialect = dialect;
                break;
            }
        }
    }

    @Override
    public String[] getReservedWords() {
        if (this.databaseDialect != null) {
            return this.databaseDialect.getReservedWords();
        }
        return super.getReservedWords();
    }

    @Override
    public String getEndQuote() {
        if (this.databaseDialect != null) {
            return this.databaseDialect.getEndQuote();
        }
        return super.getEndQuote();
    }

    @Override
    public String getFunctionSum() {
        if (this.databaseDialect != null) {
            return this.databaseDialect.getFunctionSum();
        }
        return super.getFunctionSum();
    }

    @Override
    public String getFunctionAverage() {
        if (this.databaseDialect != null) {
            return this.databaseDialect.getFunctionAverage();
        }
        return super.getFunctionAverage();
    }

    @Override
    public String getFunctionMinimum() {
        if (this.databaseDialect != null) {
            return this.databaseDialect.getFunctionMinimum();
        }
        return super.getFunctionMinimum();
    }

    @Override
    public String getFunctionMaximum() {
        if (this.databaseDialect != null) {
            return this.databaseDialect.getFunctionMaximum();
        }
        return super.getFunctionMaximum();
    }

    @Override
    public String getFunctionCount() {
        if (this.databaseDialect != null) {
            return this.databaseDialect.getFunctionCount();
        }
        return super.getFunctionCount();
    }

    @Override
    public String getSQLQueryFields(String tableName) {
        if (this.databaseDialect != null) {
            return this.databaseDialect.getSQLQueryFields(tableName);
        }
        return super.getSQLQueryFields(tableName);
    }

    @Override
    public String getSQLColumnExists(String columnname, String tablename) {
        if (this.databaseDialect != null) {
            return this.databaseDialect.getSQLColumnExists(columnname, tablename);
        }
        return super.getSQLColumnExists(columnname, tablename);
    }

    @Override
    public String getSQLTableExists(String tableName) {
        if (this.databaseDialect != null) {
            return this.databaseDialect.getSQLTableExists(tableName);
        }
        return super.getSQLTableExists(tableName);
    }

    @Override
    public String getLimitClause(int nrRows) {
        if (this.databaseDialect != null) {
            return this.databaseDialect.getLimitClause(nrRows);
        }
        return super.getLimitClause(nrRows);
    }

    @Override
    public String getSelectCountStatement(String tableName) {
        if (this.databaseDialect != null) {
            return this.databaseDialect.getSelectCountStatement(tableName);
        }
        return super.getSelectCountStatement(tableName);
    }

    @Override
    public String getSQLUnlockTables(String[] tableName) {
        if (this.databaseDialect != null) {
            return this.databaseDialect.getSQLUnlockTables(tableName);
        }
        return super.getSQLUnlockTables(tableName);
    }

    @Override
    public String getSequenceNoMaxValueOption() {
        if (this.databaseDialect != null) {
            return this.databaseDialect.getSequenceNoMaxValueOption();
        }
        return super.getSequenceNoMaxValueOption();
    }

    @Override
    public boolean useSchemaNameForTableList() {
        if (this.databaseDialect != null) {
            return this.databaseDialect.useSchemaNameForTableList();
        }
        return super.useSchemaNameForTableList();
    }

    @Override
    public boolean supportsViews() {
        if (this.databaseDialect != null) {
            return this.databaseDialect.supportsViews();
        }
        return super.supportsViews();
    }

    @Override
    public boolean supportsTimeStampToDateConversion() {
        if (this.databaseDialect != null) {
            return this.databaseDialect.supportsTimeStampToDateConversion();
        }
        return super.supportsTimeStampToDateConversion();
    }

    @Override
    public String getCreateTableStatement() {
        if (this.databaseDialect != null) {
            return this.databaseDialect.getCreateTableStatement();
        }
        return super.getCreateTableStatement();
    }

    @Override
    public boolean supportsAutoGeneratedKeys() {
        if (this.databaseDialect != null) {
            return this.databaseDialect.supportsAutoGeneratedKeys();
        }
        return super.supportsAutoGeneratedKeys();
    }

    @Override
    public String getSafeFieldname(String fieldName) {
        if (this.databaseDialect != null) {
            return this.databaseDialect.getSafeFieldname(fieldName);
        }
        return super.getSafeFieldname(fieldName);
    }

    @Override
    public void setSupportsTimestampDataType(boolean b) {
        if (this.databaseDialect != null) {
            this.databaseDialect.setSupportsTimestampDataType(b);
        }
        super.setSupportsTimestampDataType(b);
    }

    @Override
    public boolean supportsTimestampDataType() {
        if (this.databaseDialect != null) {
            return this.databaseDialect.supportsTimestampDataType();
        }
        return super.supportsTimestampDataType();
    }

    @Override
    public boolean supportsResultSetMetadataRetrievalOnly() {
        if (this.databaseDialect != null) {
            return this.databaseDialect.supportsResultSetMetadataRetrievalOnly();
        }
        return super.supportsResultSetMetadataRetrievalOnly();
    }

    @Override
    public String getSQLValue(ValueMetaInterface valueMeta, Object valueData, String dateFormat) throws KettleValueException {
        if (this.databaseDialect != null) {
            return this.databaseDialect.getSQLValue(valueMeta, valueData, dateFormat);
        }
        return super.getSQLValue(valueMeta, valueData, dateFormat);
    }

    @Override
    public ValueMetaInterface customizeValueFromSQLType(ValueMetaInterface v, ResultSetMetaData rm, int index) throws SQLException {
        if (this.databaseDialect != null) {
            return this.databaseDialect.customizeValueFromSQLType(v, rm, index);
        }
        return super.customizeValueFromSQLType(v, rm, index);
    }

    @Override
    public boolean isMySQLVariant() {
        if (this.databaseDialect != null) {
            return this.databaseDialect.isMySQLVariant();
        }
        return super.isMySQLVariant();
    }

    @Override
    public String generateColumnAlias(int columnIndex, String suggestedName) {
        if (this.databaseDialect != null) {
            return this.databaseDialect.generateColumnAlias(columnIndex, suggestedName);
        }
        return super.generateColumnAlias(columnIndex, suggestedName);
    }

    @Override
    public String quoteSQLString(String string) {
        if (this.databaseDialect != null) {
            return this.databaseDialect.quoteSQLString(string);
        }
        return super.quoteSQLString(string);
    }

    @Override
    public boolean isExplorable() {
        if (this.databaseDialect != null) {
            return this.databaseDialect.isExplorable();
        }
        return super.isExplorable();
    }

    @Override
    public int getMaxColumnsInIndex() {
        if (this.databaseDialect != null) {
            return this.databaseDialect.getMaxColumnsInIndex();
        }
        return super.getMaxColumnsInIndex();
    }

    @Override
    public String getSQLListOfSchemas() {
        if (this.databaseDialect != null) {
            return this.databaseDialect.getSQLListOfSchemas();
        }
        return super.getSQLListOfSchemas();
    }

    @Override
    public boolean supportsNewLinesInSQL() {
        if (this.databaseDialect != null) {
            return this.databaseDialect.supportsNewLinesInSQL();
        }
        return super.supportsNewLinesInSQL();
    }

    @Override
    public boolean isSystemTable(String tableName) {
        if (this.databaseDialect != null) {
            return this.databaseDialect.isSystemTable(tableName);
        }
        return super.isSystemTable(tableName);
    }

    @Override
    public boolean isDisplaySizeTwiceThePrecision() {
        if (this.databaseDialect != null) {
            return this.databaseDialect.isDisplaySizeTwiceThePrecision();
        }
        return super.isDisplaySizeTwiceThePrecision();
    }

    @Override
    public boolean requiresCastToVariousForIsNull() {
        if (this.databaseDialect != null) {
            return this.databaseDialect.requiresCastToVariousForIsNull();
        }
        return super.requiresCastToVariousForIsNull();
    }

    @Override
    public boolean requiresCreateTablePrimaryKeyAppend() {
        if (this.databaseDialect != null) {
            return this.databaseDialect.requiresCreateTablePrimaryKeyAppend();
        }
        return super.requiresCreateTablePrimaryKeyAppend();
    }

    @Override
    public boolean supportsSequenceNoMaxValueOption() {
        if (this.databaseDialect != null) {
            return this.databaseDialect.supportsSequenceNoMaxValueOption();
        }
        return super.supportsSequenceNoMaxValueOption();
    }

    @Override
    public void setUsingDoubleDecimalAsSchemaTableSeparator(boolean useDoubleDecimalSeparator) {
        if (this.databaseDialect != null) {
            this.databaseDialect.setUsingDoubleDecimalAsSchemaTableSeparator(useDoubleDecimalSeparator);
        }
        super.setUsingDoubleDecimalAsSchemaTableSeparator(useDoubleDecimalSeparator);
    }

    @Override
    public boolean isUsingDoubleDecimalAsSchemaTableSeparator() {
        if (this.databaseDialect != null) {
            return this.databaseDialect.isUsingDoubleDecimalAsSchemaTableSeparator();
        }
        return super.isUsingDoubleDecimalAsSchemaTableSeparator();
    }

    @Override
    public void setForcingIdentifiersToUpperCase(boolean forceUpperCase) {
        if (this.databaseDialect != null) {
            this.databaseDialect.setForcingIdentifiersToUpperCase(forceUpperCase);
        }
        super.setForcingIdentifiersToUpperCase(forceUpperCase);
    }

    @Override
    public boolean isForcingIdentifiersToUpperCase() {
        if (this.databaseDialect != null) {
            return this.databaseDialect.isForcingIdentifiersToUpperCase();
        }
        return super.isForcingIdentifiersToUpperCase();
    }

    @Override
    public void setForcingIdentifiersToLowerCase(boolean forceUpperCase) {
        if (this.databaseDialect != null) {
            this.databaseDialect.setForcingIdentifiersToLowerCase(forceUpperCase);
        }
        super.setForcingIdentifiersToLowerCase(forceUpperCase);
    }

    @Override
    public boolean isForcingIdentifiersToLowerCase() {
        if (this.databaseDialect != null) {
            return this.databaseDialect.isForcingIdentifiersToLowerCase();
        }
        return super.isForcingIdentifiersToLowerCase();
    }

    @Override
    public void setQuoteAllFields(boolean quoteAllFields) {
        if (this.databaseDialect != null) {
            this.databaseDialect.setQuoteAllFields(quoteAllFields);
        }
        super.setQuoteAllFields(quoteAllFields);
    }

    @Override
    public boolean isQuoteAllFields() {
        if (this.databaseDialect != null) {
            return this.databaseDialect.isQuoteAllFields();
        }
        return super.isQuoteAllFields();
    }

    @Override
    public void setStreamingResults(boolean useStreaming) {
        if (this.databaseDialect != null) {
            this.databaseDialect.setStreamingResults(useStreaming);
        }
        super.setStreamingResults(useStreaming);
    }

    @Override
    public boolean isStreamingResults() {
        if (this.databaseDialect != null) {
            return this.databaseDialect.isStreamingResults();
        }
        return super.isStreamingResults();
    }

    @Override
    public boolean needsToLockAllTables() {
        if (this.databaseDialect != null) {
            return this.databaseDialect.needsToLockAllTables();
        }
        return super.needsToLockAllTables();
    }

    @Override
    public boolean supportsSetMaxRows() {
        if (this.databaseDialect != null) {
            return this.databaseDialect.supportsSetMaxRows();
        }
        return super.supportsSetMaxRows();
    }

    @Override
    public boolean supportsGetBlob() {
        if (this.databaseDialect != null) {
            return this.databaseDialect.supportsGetBlob();
        }
        return super.supportsGetBlob();
    }

    @Override
    public boolean isDefaultingToUppercase() {
        if (this.databaseDialect != null) {
            return this.databaseDialect.isDefaultingToUppercase();
        }
        return super.isDefaultingToUppercase();
    }

    @Override
    public void setPreserveReservedCase(boolean b) {
        if (this.databaseDialect != null) {
            this.databaseDialect.setPreserveReservedCase(b);
        }
        super.setPreserveReservedCase(b);
    }

    @Override
    public boolean preserveReservedCase() {
        if (this.databaseDialect != null) {
            return this.databaseDialect.preserveReservedCase();
        }
        return super.preserveReservedCase();
    }

    @Override
    public void setSupportsBooleanDataType(boolean b) {
        if (this.databaseDialect != null) {
            this.databaseDialect.setSupportsBooleanDataType(b);
        }
        super.setSupportsBooleanDataType(b);
    }

    @Override
    public boolean supportsBooleanDataType() {
        if (this.databaseDialect != null) {
            return this.databaseDialect.supportsBooleanDataType();
        }
        return super.supportsBooleanDataType();
    }

    @Override
    public boolean supportsBatchUpdates() {
        if (this.databaseDialect != null) {
            return this.databaseDialect.supportsBatchUpdates();
        }
        return super.supportsBatchUpdates();
    }

    @Override
    public String getSQLLockTables(String[] tableNames) {
        if (this.databaseDialect != null) {
            return this.databaseDialect.getSQLLockTables(tableNames);
        }
        return super.getSQLLockTables(tableNames);
    }

    @Override
    public boolean supportsFloatRoundingOnUpdate() {
        if (this.databaseDialect != null) {
            return this.databaseDialect.supportsFloatRoundingOnUpdate();
        }
        return super.supportsFloatRoundingOnUpdate();
    }

    @Override
    public boolean supportsSynonyms() {
        if (this.databaseDialect != null) {
            return this.databaseDialect.supportsSynonyms();
        }
        return super.supportsSynonyms();
    }

    @Override
    public String[] getSynonymTypes() {
        if (this.databaseDialect != null) {
            return this.databaseDialect.getSynonymTypes();
        }
        return super.getSynonymTypes();
    }

    @Override
    public String[] getViewTypes() {
        if (this.databaseDialect != null) {
            return this.databaseDialect.getViewTypes();
        }
        return super.getViewTypes();
    }

    @Override
    public String[] getTableTypes() {
        if (this.databaseDialect != null) {
            return this.databaseDialect.getTableTypes();
        }
        return super.getTableTypes();
    }

    @Override
    public String getStartQuote() {
        if (this.databaseDialect != null) {
            return this.databaseDialect.getStartQuote();
        }
        return super.getStartQuote();
    }

    @Override
    public boolean quoteReservedWords() {
        if (this.databaseDialect != null) {
            return this.databaseDialect.quoteReservedWords();
        }
        return super.quoteReservedWords();
    }

    @Override
    public String getDropColumnStatement(String tablename, ValueMetaInterface v, String tk, boolean useAutoinc, String pk, boolean semicolon) {
        if (this.databaseDialect != null) {
            return this.databaseDialect.getDropColumnStatement(tablename, v, tk, useAutoinc, pk, semicolon);
        }
        return super.getDropColumnStatement(tablename, v, tk, useAutoinc, pk, semicolon);
    }

    @Override
    public int getMaxVARCHARLength() {
        if (this.databaseDialect != null) {
            return this.databaseDialect.getMaxVARCHARLength();
        }
        return super.getMaxVARCHARLength();
    }

    @Override
    public int getMaxTextFieldLength() {
        if (this.databaseDialect != null) {
            return this.databaseDialect.getMaxTextFieldLength();
        }
        return super.getMaxTextFieldLength();
    }

    @Override
    public String getSchemaTableCombination(String schemaName, String tablePart) {
        if (this.databaseDialect != null) {
            return this.databaseDialect.getSchemaTableCombination(schemaName, tablePart);
        }
        return super.getSchemaTableCombination(schemaName, tablePart);
    }

    @Override
    public Map<String, String> getDefaultOptions() {
        if (this.databaseDialect != null) {
            return this.databaseDialect.getDefaultOptions();
        }
        return super.getDefaultOptions();
    }

    @Override
    public Map<String, String> getExtraOptions() {
        if (this.databaseDialect != null) {
            return this.databaseDialect.getExtraOptions();
        }
        return super.getExtraOptions();
    }

    @Override
    public void addExtraOption(String databaseTypeCode, String option, String value) {
        if (this.databaseDialect != null) {
            this.databaseDialect.addExtraOption(databaseTypeCode, option, value);
        }
        super.addExtraOption(databaseTypeCode, option, value);
    }

    @Override
    public String getExtraOptionSeparator() {
        if (this.databaseDialect != null) {
            return this.databaseDialect.getExtraOptionSeparator();
        }
        return super.getExtraOptionSeparator();
    }

    @Override
    public String getExtraOptionValueSeparator() {
        if (this.databaseDialect != null) {
            return this.databaseDialect.getExtraOptionValueSeparator();
        }
        return super.getExtraOptionValueSeparator();
    }

    @Override
    public String getExtraOptionIndicator() {
        if (this.databaseDialect != null) {
            return this.databaseDialect.getExtraOptionIndicator();
        }
        return super.getExtraOptionIndicator();
    }

    @Override
    public boolean supportsOptionsInURL() {
        if (this.databaseDialect != null) {
            return this.databaseDialect.supportsOptionsInURL();
        }
        return super.supportsOptionsInURL();
    }

    @Override
    public String getExtraOptionsHelpText() {
        if (this.databaseDialect != null) {
            return this.databaseDialect.getExtraOptionsHelpText();
        }
        return super.getExtraOptionsHelpText();
    }
}

