/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.core.database;

import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.pentaho.di.core.database.Database;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.database.PartitionDatabaseMeta;
import org.pentaho.di.core.database.SqlScriptParser;
import org.pentaho.di.core.database.SqlScriptStatement;
import org.pentaho.di.core.exception.KettleDatabaseException;
import org.pentaho.di.core.exception.KettleValueException;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.repository.ObjectId;

public interface DatabaseInterface
extends Cloneable {
    public String getPluginId();

    public void setPluginId(String var1);

    public String getPluginName();

    public void setPluginName(String var1);

    public int getAccessType();

    public void setAccessType(int var1);

    public boolean isChanged();

    public void setChanged(boolean var1);

    public String getName();

    public void setName(String var1);

    public String getDisplayName();

    public void setDisplayName(String var1);

    public String getDatabaseName();

    public void setDatabaseName(String var1);

    public String getDatabasePortNumberString();

    public void setDatabasePortNumberString(String var1);

    public String getHostname();

    public void setHostname(String var1);

    public ObjectId getObjectId();

    public void setObjectId(ObjectId var1);

    public String getUsername();

    public void setUsername(String var1);

    public String getPassword();

    public void setPassword(String var1);

    public String getServername();

    public void setServername(String var1);

    public String getDataTablespace();

    public void setDataTablespace(String var1);

    public String getIndexTablespace();

    public void setIndexTablespace(String var1);

    public Properties getAttributes();

    public void setAttributes(Properties var1);

    default public void addAttribute(String attributeId, String value) {
    }

    default public String getAttribute(String attributeId, String defaultValue) {
        return "";
    }

    public boolean supportsSetCharacterStream();

    public boolean supportsAutoInc();

    public String getFieldDefinition(ValueMetaInterface var1, String var2, String var3, boolean var4, boolean var5, boolean var6);

    public int[] getAccessTypeList();

    public int getDefaultDatabasePort();

    public Map<String, String> getDefaultOptions();

    public String getLimitClause(int var1);

    public String getSQLQueryFields(String var1);

    public int getNotFoundTK(boolean var1);

    public String getDriverClass();

    public String getURL(String var1, String var2, String var3) throws KettleDatabaseException;

    public boolean supportsSequences();

    public String getSQLNextSequenceValue(String var1);

    public String getSQLCurrentSequenceValue(String var1);

    public String getSQLSequenceExists(String var1);

    public boolean isFetchSizeSupported();

    public boolean supportsTransactions();

    public boolean supportsBitmapIndex();

    default public boolean supportsIndexes() {
        return true;
    }

    public boolean supportsSetLong();

    public boolean supportsSchemas();

    public boolean supportsCatalogs();

    public boolean supportsEmptyTransactions();

    public boolean needsPlaceHolder();

    public String getFunctionSum();

    public String getFunctionAverage();

    public String getFunctionMinimum();

    public String getFunctionMaximum();

    public String getFunctionCount();

    public String getSchemaTableCombination(String var1, String var2);

    public int getMaxTextFieldLength();

    public int getMaxVARCHARLength();

    public String getAddColumnStatement(String var1, ValueMetaInterface var2, String var3, boolean var4, String var5, boolean var6);

    public String getDropColumnStatement(String var1, ValueMetaInterface var2, String var3, boolean var4, String var5, boolean var6);

    public String getModifyColumnStatement(String var1, ValueMetaInterface var2, String var3, boolean var4, String var5, boolean var6);

    public Object clone();

    public String[] getReservedWords();

    public boolean quoteReservedWords();

    public String getStartQuote();

    public String getEndQuote();

    public boolean supportsRepository();

    public String[] getTableTypes();

    public String[] getViewTypes();

    public String[] getSynonymTypes();

    public boolean useSchemaNameForTableList();

    public boolean supportsViews();

    public boolean supportsSynonyms();

    public String getSQLListOfProcedures();

    public String getTruncateTableStatement(String var1);

    public boolean supportsFloatRoundingOnUpdate();

    public String getSQLLockTables(String[] var1);

    public String getSQLUnlockTables(String[] var1);

    public boolean supportsTimeStampToDateConversion();

    public boolean supportsBatchUpdates();

    public boolean supportsBooleanDataType();

    public void setSupportsBooleanDataType(boolean var1);

    public boolean preserveReservedCase();

    public void setPreserveReservedCase(boolean var1);

    public boolean isDefaultingToUppercase();

    public Map<String, String> getExtraOptions();

    public void addExtraOption(String var1, String var2, String var3);

    public String getExtraOptionSeparator();

    public String getExtraOptionValueSeparator();

    public String getExtraOptionIndicator();

    public boolean supportsOptionsInURL();

    public String getExtraOptionsHelpText();

    public boolean supportsGetBlob();

    public String getConnectSQL();

    public void setConnectSQL(String var1);

    public boolean supportsSetMaxRows();

    public boolean isUsingConnectionPool();

    public void setUsingConnectionPool(boolean var1);

    public int getMaximumPoolSize();

    public String getMaximumPoolSizeString();

    public void setMaximumPoolSize(int var1);

    public void setMaximumPoolSizeString(String var1);

    public int getInitialPoolSize();

    public String getInitialPoolSizeString();

    public void setInitialPoolSize(int var1);

    public void setInitialPoolSizeString(String var1);

    public boolean isPartitioned();

    public void setPartitioned(boolean var1);

    public PartitionDatabaseMeta[] getPartitioningInformation();

    public void setPartitioningInformation(PartitionDatabaseMeta[] var1);

    public String[] getUsedLibraries();

    public Properties getConnectionPoolingProperties();

    public void setConnectionPoolingProperties(Properties var1);

    public String getSQLTableExists(String var1);

    public String getSQLColumnExists(String var1, String var2);

    public boolean needsToLockAllTables();

    public boolean isStreamingResults();

    public void setStreamingResults(boolean var1);

    public boolean isQuoteAllFields();

    public void setQuoteAllFields(boolean var1);

    public boolean isForcingIdentifiersToLowerCase();

    public void setForcingIdentifiersToLowerCase(boolean var1);

    public boolean isForcingIdentifiersToUpperCase();

    public void setForcingIdentifiersToUpperCase(boolean var1);

    public boolean isUsingDoubleDecimalAsSchemaTableSeparator();

    public void setUsingDoubleDecimalAsSchemaTableSeparator(boolean var1);

    public boolean isRequiringTransactionsOnQueries();

    public String getDatabaseFactoryName();

    public String getPreferredSchemaName();

    public void setPreferredSchemaName(String var1);

    public boolean checkIndexExists(Database var1, String var2, String var3, String[] var4) throws KettleDatabaseException;

    public boolean supportsSequenceNoMaxValueOption();

    public boolean requiresCreateTablePrimaryKeyAppend();

    public boolean requiresCastToVariousForIsNull();

    public boolean isDisplaySizeTwiceThePrecision();

    public boolean supportsPreparedStatementMetadataRetrieval();

    public boolean isSystemTable(String var1);

    public boolean supportsNewLinesInSQL();

    public String getSQLListOfSchemas();

    public int getMaxColumnsInIndex();

    public boolean supportsErrorHandlingOnBatchUpdates();

    public String getSQLInsertAutoIncUnknownDimensionRow(String var1, String var2, String var3);

    public boolean isExplorable();

    public String getXulOverlayFile();

    public String getSQLListOfSequences();

    public String quoteSQLString(String var1);

    public String getSelectCountStatement(String var1);

    public String generateColumnAlias(int var1, String var2);

    public List<String> parseStatements(String var1);

    public List<SqlScriptStatement> getSqlScriptStatements(String var1);

    public boolean isMySQLVariant();

    public boolean releaseSavepoint();

    public Long getNextBatchId(DatabaseMeta var1, Database var2, String var3, String var4, String var5) throws KettleDatabaseException;

    public String getDataTablespaceDDL(VariableSpace var1, DatabaseMeta var2);

    public String getIndexTablespaceDDL(VariableSpace var1, DatabaseMeta var2);

    public Object getValueFromResultSet(ResultSet var1, ValueMetaInterface var2, int var3) throws KettleDatabaseException;

    public boolean useSafePoints();

    public boolean supportsErrorHandling();

    public String getSQLValue(ValueMetaInterface var1, Object var2, String var3) throws KettleValueException;

    public boolean supportsResultSetMetadataRetrievalOnly();

    public boolean supportsTimestampDataType();

    public void setSupportsTimestampDataType(boolean var1);

    public String getSafeFieldname(String var1);

    public String getSequenceNoMaxValueOption();

    public boolean supportsAutoGeneratedKeys();

    public ValueMetaInterface customizeValueFromSQLType(ValueMetaInterface var1, ResultSetMetaData var2, int var3) throws SQLException;

    public String getCreateTableStatement();

    default public void addDefaultOptions() {
    }

    default public SqlScriptParser createSqlScriptParser() {
        return new SqlScriptParser(true);
    }

    default public boolean supportsStandardTableOutput() {
        return true;
    }

    default public String getUnsupportedTableOutputMessage() {
        return "";
    }

    default public String getLegacyColumnName(DatabaseMetaData dbMetaData, ResultSetMetaData rsMetaData, int index) throws KettleDatabaseException {
        return "";
    }

    default public void putOptionalOptions(Map<String, String> extraOptions) {
    }

    default public ResultSet getSchemas(DatabaseMetaData databaseMetaData, DatabaseMeta dbMeta) throws SQLException {
        return databaseMetaData.getSchemas();
    }

    default public ResultSet getTables(DatabaseMetaData databaseMetaData, DatabaseMeta dbMeta, String schemaPattern, String tableNamePattern, String[] tableTypes) throws SQLException {
        return databaseMetaData.getTables(null, schemaPattern, tableNamePattern, tableTypes);
    }

    default public String getNamedCluster() {
        return "";
    }

    default public void setNamedCluster(String namedCluster) {
    }

    default public List<String> getNamedClusterList() {
        return null;
    }
}

