/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.core.database;

import org.pentaho.di.core.Const;
import org.pentaho.di.core.database.BaseDatabaseMeta;
import org.pentaho.di.core.database.DatabaseInterface;
import org.pentaho.di.core.row.ValueMetaInterface;

public class AS400DatabaseMeta
extends BaseDatabaseMeta
implements DatabaseInterface {
    @Override
    public int[] getAccessTypeList() {
        return new int[]{0, 1, 4};
    }

    @Override
    public String getDriverClass() {
        if (this.getAccessType() == 1) {
            return "sun.jdbc.odbc.JdbcOdbcDriver";
        }
        return "com.ibm.as400.access.AS400JDBCDriver";
    }

    @Override
    public int getMaxTextFieldLength() {
        return 65536;
    }

    @Override
    public String getURL(String hostname, String port, String database) {
        if (this.getAccessType() == 1) {
            return "jdbc:odbc:" + database;
        }
        return "jdbc:as400://" + hostname + "/" + database;
    }

    @Override
    public String getTruncateTableStatement(String tableName) {
        return "DELETE FROM " + tableName;
    }

    @Override
    public String getAddColumnStatement(String tablename, ValueMetaInterface v, String tk, boolean useAutoinc, String pk, boolean semicolon) {
        return "ALTER TABLE " + tablename + " ADD " + this.getFieldDefinition(v, tk, pk, useAutoinc, true, false);
    }

    @Override
    public String getModifyColumnStatement(String tablename, ValueMetaInterface v, String tk, boolean useAutoinc, String pk, boolean semicolon) {
        return "ALTER TABLE " + tablename + " ALTER COLUMN " + v.getName() + " SET " + this.getFieldDefinition(v, tk, pk, useAutoinc, false, false);
    }

    @Override
    public String getFieldDefinition(ValueMetaInterface v, String tk, String pk, boolean useAutoinc, boolean addFieldName, boolean addCr) {
        String retval = "";
        String fieldname = v.getName();
        int length = v.getLength();
        int precision = v.getPrecision();
        if (addFieldName) {
            retval = retval + fieldname + " ";
        }
        int type = v.getType();
        switch (type) {
            case 3: 
            case 9: {
                retval = retval + "TIMESTAMP";
                break;
            }
            case 4: {
                retval = retval + "CHAR(1)";
                break;
            }
            case 1: 
            case 5: 
            case 6: {
                if (length <= 0 && precision <= 0) {
                    retval = retval + "DOUBLE";
                    break;
                }
                retval = retval + "DECIMAL";
                if (length <= 0) break;
                retval = retval + "(" + length;
                if (precision > 0) {
                    retval = retval + ", " + precision;
                }
                retval = retval + ")";
                break;
            }
            case 2: {
                if (length > this.getMaxVARCHARLength() || length >= 9999999) {
                    retval = retval + "CLOB";
                    break;
                }
                retval = retval + "VARCHAR";
                retval = length > 0 ? retval + "(" + length : retval + "(";
                retval = retval + ")";
                break;
            }
            default: {
                retval = retval + " UNKNOWN";
            }
        }
        if (addCr) {
            retval = retval + Const.CR;
        }
        return retval;
    }

    @Override
    public String[] getReservedWords() {
        return new String[]{"ACTIVATE", "ADD", "ALIAS", "ALL", "ALLOCATE", "ALLOW", "ALTER", "AND", "ANY", "AS", "ASENSITIVE", "AT", "ATTRIBUTES", "AUTHORIZATION", "BEGIN", "BETWEEN", "BINARY", "BY", "CACHE", "CALL", "CALLED", "CARDINALITY", "CASE", "CAST", "CCSID", "CHAR", "CHARACTER", "CHECK", "CLOSE", "COLLECTION", "COLUMN", "COMMENT", "COMMIT", "CONCAT", "CONDITION", "CONNECT", "CONNECTION", "CONSTRAINT", "CONTAINS", "CONTINUE", "COUNT", "COUNT_BIG", "CREATE", "CROSS", "CURRENT", "CURRENT_DATE", "CURRENT_PATH", "CURRENT_SCHEMA", "CURRENT_SERVER", "CURRENT_TIME", "CURRENT_TIMESTAMP", "CURRENT_TIMEZONE", "CURRENT_USER", "CURSOR", "CYCLE", "DATABASE", "DATAPARTITIONNAME", "DATAPARTITIONNUM", "DATE", "DAY", "DAYS", "DBINFO", "DBPARTITIONNAME", "DBPARTITIONNUM", "DB2GENERAL", "DB2GENRL", "DB2SQL", "DEALLOCATE", "DECLARE", "DEFAULT", "DEFAULTS", "DEFINITION", "DELETE", "DENSERANK", "DENSE_RANK", "DESCRIBE", "DESCRIPTOR", "DETERMINISTIC", "DIAGNOSTICS", "DISABLE", "DISALLOW", "DISCONNECT", "DISTINCT", "DO", "DOUBLE", "DROP", "DYNAMIC", "EACH", "ELSE", "ELSEIF", "ENABLE", "ENCRYPTION", "END", "ENDING", "END-EXEC", "ESCAPE", "EVERY", "EXCEPT", "EXCEPTION", "EXCLUDING", "EXCLUSIVE", "EXECUTE", "EXISTS", "EXIT", "EXTERNAL", "EXTRACT", "FENCED", "FETCH", "FILE", "FINAL", "FOR", "FOREIGN", "FREE", "FROM", "FULL", "FUNCTION", "GENERAL", "GENERATED", "GET", "GLOBAL", "GO", "GOTO", "GRANT", "GRAPHIC", "GROUP", "HANDLER", "HASH", "HASHED_VALUE", "HAVING", "HINT", "HOLD", "HOUR", "HOURS", "IDENTITY", "IF", "IMMEDIATE", "IN", "INCLUDING", "INCLUSIVE", "INCREMENT", "INDEX", "INDICATOR", "INHERIT", "INNER", "INOUT", "INSENSITIVE", "INSERT", "INTEGRITY", "INTERSECT", "INTO", "IS", "ISOLATION", "ITERATE", "JAVA", "JOIN", "KEY", "LABEL", "LANGUAGE", "LATERAL", "LEAVE", "LEFT", "LIKE", "LINKTYPE", "LOCAL", "LOCALDATE", "LOCALTIME", "LOCALTIMESTAMP", "LOCK", "LONG", "LOOP", "MAINTAINED", "MATERIALIZED", "MAXVALUE", "MICROSECOND", "MICROSECONDS", "MINUTE", "MINUTES", "MINVALUE", "MODE", "MODIFIES", "MONTH", "MONTHS", "NEW", "NEW_TABLE", "NEXTVAL", "NO", "NOCACHE", "NOCYCLE", "NODENAME", "NODENUMBER", "NOMAXVALUE", "NOMINVALUE", "NOORDER", "NORMALIZED", "NOT", "NULL", "OF", "OLD", "OLD_TABLE", "ON", "OPEN", "OPTIMIZE", "OPTION", "OR", "ORDER", "OUT", "OUTER", "OVER", "OVERRIDING", "PACKAGE", "PAGESIZE", "PARAMETER", "PART", "PARTITION", "PARTITIONING", "PARTITIONS", "PASSWORD", "PATH", "POSITION", "PREPARE", "PREVVAL", "PRIMARY", "PRIVILEGES", "PROCEDURE", "PROGRAM", "QUERY", "RANGE", "RANK", "READ", "READS", "RECOVERY", "REFERENCES", "REFERENCING", "REFRESH", "RELEASE", "RENAME", "REPEAT", "RESET", "RESIGNAL", "RESTART", "RESULT", "RETURN", "RETURNS", "REVOKE", "RIGHT", "ROLLBACK", "ROUTINE", "ROW", "ROWNUMBER", "ROW_NUMBER", "ROWS", "RRN", "RUN", "SAVEPOINT", "SCHEMA", "SCRATCHPAD", "SCROLL", "SEARCH", "SECOND", "SECONDS", "SELECT", "SENSITIVE", "SEQUENCE", "SESSION", "SESSION_USER", "SET", "SIGNAL", "SIMPLE", "SOME", "SOURCE", "SPECIFIC", "SQL", "SQLID", "STACKED", "START", "STARTING", "STATEMENT", "STATIC", "SUBSTRING", "SUMMARY", "SYNONYM", "SYSTEM_USER", "TABLE", "THEN", "TIME", "TIMESTAMP", "TO", "TRANSACTION", "TRIGGER", "TRIM", "TYPE", "UNDO", "UNION", "UNIQUE", "UNTIL", "UPDATE", "USAGE", "USER", "USING", "VALUE", "VALUES", "VARIABLE", "VARIANT", "VERSION", "VIEW", "VOLATILE", "WHEN", "WHERE", "WHILE", "WITH", "WITHOUT", "WRITE", "YEAR", "YEARS"};
    }

    @Override
    public String[] getUsedLibraries() {
        return new String[]{"jt400.jar"};
    }

    @Override
    public boolean supportsFloatRoundingOnUpdate() {
        return false;
    }

    @Override
    public int getMaxVARCHARLength() {
        return 32672;
    }

    @Override
    public boolean supportsSequences() {
        return true;
    }

    @Override
    public String getSQLListOfSequences() {
        return "SELECT SEQNAME FROM SYSCAT.SEQUENCES";
    }

    @Override
    public String getSQLSequenceExists(String sequenceName) {
        return "SELECT * FROM SYSCAT.SEQUENCES WHERE SEQNAME = '" + sequenceName.toUpperCase() + "'";
    }

    @Override
    public String getSQLCurrentSequenceValue(String sequenceName) {
        return "SELECT PREVIOUS VALUE FOR " + sequenceName + " FROM SYSIBM.SYSDUMMY1";
    }

    @Override
    public String getSQLNextSequenceValue(String sequenceName) {
        return "SELECT NEXT VALUE FOR " + sequenceName + " FROM SYSIBM.SYSDUMMY1";
    }

    @Override
    public boolean supportsSequenceNoMaxValueOption() {
        return true;
    }
}

