/*
 * Decompiled with CFR 0.152.
 */
package mondrian.rolap;

import java.util.Collections;
import java.util.Map;
import mondrian.olap.Annotation;
import mondrian.olap.DimensionBase;
import mondrian.olap.DimensionType;
import mondrian.olap.Hierarchy;
import mondrian.olap.Level;
import mondrian.olap.MondrianDef;
import mondrian.olap.Schema;
import mondrian.olap.Util;
import mondrian.resource.MondrianResource;
import mondrian.rolap.RolapCube;
import mondrian.rolap.RolapHierarchy;
import mondrian.rolap.RolapSchema;
import org.apache.log4j.Logger;

class RolapDimension
extends DimensionBase {
    private static final Logger LOGGER = Logger.getLogger(RolapDimension.class);
    private final Schema schema;
    private final Map<String, Annotation> annotationMap;

    RolapDimension(Schema schema, String name, String caption, boolean visible, String description, DimensionType dimensionType, boolean highCardinality, Map<String, Annotation> annotationMap) {
        super(name, caption, visible, description, dimensionType, highCardinality);
        assert (annotationMap != null);
        this.schema = schema;
        this.annotationMap = annotationMap;
        this.hierarchies = new RolapHierarchy[0];
    }

    RolapDimension(RolapSchema schema, RolapCube cube, MondrianDef.Dimension xmlDimension, MondrianDef.CubeDimension xmlCubeDimension) {
        this(schema, xmlDimension.name, xmlDimension.caption, xmlDimension.visible, xmlDimension.description, xmlDimension.getDimensionType(), xmlDimension.highCardinality, RolapHierarchy.createAnnotationMap(xmlDimension.annotations));
        int i;
        Util.assertPrecondition(schema != null);
        if (cube != null) {
            Util.assertTrue(cube.getSchema() == schema);
        }
        if (!Util.isEmpty(xmlDimension.caption)) {
            this.setCaption(xmlDimension.caption);
        }
        this.hierarchies = new RolapHierarchy[xmlDimension.hierarchies.length];
        for (i = 0; i < xmlDimension.hierarchies.length; ++i) {
            RolapHierarchy hierarchy = new RolapHierarchy(cube, this, xmlDimension.hierarchies[i], xmlCubeDimension);
            this.hierarchies[i] = hierarchy;
        }
        if (this.dimensionType == null) {
            for (i = 0; i < this.hierarchies.length; ++i) {
                Level[] levels = this.hierarchies[i].getLevels();
                for (int j = 0; j < levels.length; ++j) {
                    Level lev = levels[j];
                    if (lev.isAll()) continue;
                    if (this.dimensionType == null) {
                        this.dimensionType = lev.getLevelType().isTime() ? DimensionType.TimeDimension : (this.isMeasures() ? DimensionType.MeasuresDimension : DimensionType.StandardDimension);
                        continue;
                    }
                    if (this.dimensionType == DimensionType.TimeDimension && !lev.getLevelType().isTime() && !lev.isAll()) {
                        throw MondrianResource.instance().NonTimeLevelInTimeHierarchy.ex(this.getUniqueName());
                    }
                    if (this.dimensionType == DimensionType.TimeDimension || !lev.getLevelType().isTime()) continue;
                    throw MondrianResource.instance().TimeLevelInNonTimeHierarchy.ex(this.getUniqueName());
                }
            }
        }
    }

    @Override
    protected Logger getLogger() {
        return LOGGER;
    }

    void init(MondrianDef.CubeDimension xmlDimension) {
        for (int i = 0; i < this.hierarchies.length; ++i) {
            if (this.hierarchies[i] == null) continue;
            ((RolapHierarchy)this.hierarchies[i]).init(xmlDimension);
        }
    }

    RolapHierarchy newHierarchy(String subName, boolean hasAll, RolapHierarchy closureFor) {
        RolapHierarchy hierarchy = new RolapHierarchy(this, subName, this.caption, this.visible, this.description, hasAll, closureFor, Collections.emptyMap());
        this.hierarchies = Util.append(this.hierarchies, hierarchy);
        return hierarchy;
    }

    @Override
    public Hierarchy getHierarchy() {
        return this.hierarchies[0];
    }

    @Override
    public Schema getSchema() {
        return this.schema;
    }

    @Override
    public Map<String, Annotation> getAnnotationMap() {
        return this.annotationMap;
    }

    @Override
    protected int computeHashCode() {
        if (this.isMeasuresDimension()) {
            return System.identityHashCode(this);
        }
        return super.computeHashCode();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof RolapDimension)) {
            return false;
        }
        if (this.isMeasuresDimension()) {
            RolapDimension that = (RolapDimension)o;
            return this == that;
        }
        return super.equals(o);
    }

    private boolean isMeasuresDimension() {
        return this.getDimensionType() == DimensionType.MeasuresDimension;
    }
}

