/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.aggdes.test.algorithm.impl;

import java.util.ArrayList;
import java.util.List;
import org.pentaho.aggdes.model.Aggregate;
import org.pentaho.aggdes.model.Attribute;
import org.pentaho.aggdes.model.Dialect;
import org.pentaho.aggdes.model.Dimension;
import org.pentaho.aggdes.model.Hierarchy;
import org.pentaho.aggdes.model.Level;
import org.pentaho.aggdes.model.Measure;
import org.pentaho.aggdes.model.Schema;
import org.pentaho.aggdes.model.StatisticsProvider;
import org.pentaho.aggdes.model.Table;

public class SchemaStub
implements Schema {
    List<Attribute> attribs = new ArrayList<Attribute>();
    StatisticsProvider provider = null;
    List<Measure> measures = new ArrayList<Measure>();
    List<Dimension> dimensions = new ArrayList<Dimension>();
    Dialect dialect;

    public SchemaStub() {
        TableStub fact = new TableStub("fact", null);
        this.attribs.add(new AttributeStub(0.0, "col1", "int", "col1", fact));
        this.attribs.add(new AttributeStub(0.0, "col2", "int", "col2", fact));
        this.attribs.add(new AttributeStub(0.0, "col3", "int", "col3", fact));
        this.measures.add(new MeasureStub(0.0, "mes1", "int", "mcol1", fact));
        LevelStub level1 = new LevelStub();
        level1.name = "Level 1";
        level1.attribute = this.attribs.get(0);
        LevelStub level2 = new LevelStub();
        level2.name = "Level 2";
        level2.attribute = this.attribs.get(1);
        HierarchyStub hierarchy = new HierarchyStub();
        hierarchy.name = "Hierarchy 1";
        hierarchy.levels.add(level1);
        hierarchy.levels.add(level2);
        DimensionStub dimension = new DimensionStub();
        dimension.name = "Dimension 1";
        dimension.hierarchies.add(hierarchy);
        this.dimensions.add(dimension);
        this.provider = new StatisticsProviderStub();
    }

    @Override
    public String generateAggregateSql(Aggregate aggregate, List<String> columnNameList) {
        return null;
    }

    @Override
    public List<Attribute> getAttributes() {
        return this.attribs;
    }

    public void setDialect(Dialect dialect) {
        this.dialect = dialect;
    }

    @Override
    public Dialect getDialect() {
        return this.dialect;
    }

    @Override
    public List<? extends Dimension> getDimensions() {
        return this.dimensions;
    }

    @Override
    public List<Measure> getMeasures() {
        return this.measures;
    }

    @Override
    public StatisticsProvider getStatisticsProvider() {
        return this.provider;
    }

    @Override
    public List<? extends Table> getTables() {
        return null;
    }

    public static class StatisticsProviderStub
    implements StatisticsProvider {
        @Override
        public double getFactRowCount() {
            return 1000.0;
        }

        @Override
        public double getLoadTime(List<Attribute> attributes) {
            return 1000.0;
        }

        @Override
        public double getRowCount(List<Attribute> attributes) {
            if (attributes.size() == 0) {
                return 1.0;
            }
            if (attributes.size() == 1) {
                return 10.0;
            }
            if (attributes.size() == 2) {
                return 100.0;
            }
            return 1000.0;
        }

        @Override
        public double getSpace(List<Attribute> attributes) {
            return 1000.0;
        }
    }

    public static class DimensionStub
    implements Dimension {
        List<Hierarchy> hierarchies = new ArrayList<Hierarchy>();
        String name;

        public List<Hierarchy> getHierarchies() {
            return this.hierarchies;
        }

        @Override
        public String getName() {
            return this.name;
        }
    }

    public static class HierarchyStub
    implements Hierarchy {
        List<Level> levels = new ArrayList<Level>();
        String name;

        public List<Level> getLevels() {
            return this.levels;
        }

        @Override
        public String getName() {
            return this.name;
        }
    }

    public static class LevelStub
    implements Level {
        Attribute attribute;
        String name;
        Level parent;

        @Override
        public Attribute getAttribute() {
            return this.attribute;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public Level getParent() {
            return this.parent;
        }
    }

    public static class AttributeStub
    implements Attribute {
        double space;
        String colName;
        String datatype;
        String label;
        TableStub table;
        List<Attribute> ancestors = new ArrayList<Attribute>();

        public AttributeStub(double space, String colName, String datatype, String label, TableStub table) {
            this.space = space;
            this.colName = colName;
            this.datatype = datatype;
            this.label = label;
            this.table = table;
        }

        @Override
        public double estimateSpace() {
            return this.space;
        }

        @Override
        public String getCandidateColumnName() {
            return this.colName;
        }

        @Override
        public String getDatatype(Dialect dialect) {
            return this.datatype;
        }

        @Override
        public String getLabel() {
            return this.label;
        }

        @Override
        public Table getTable() {
            return this.table;
        }

        @Override
        public List<Attribute> getAncestorAttributes() {
            return this.ancestors;
        }
    }

    public static class MeasureStub
    extends AttributeStub
    implements Measure {
        public MeasureStub(double space, String colName, String datatype, String label, TableStub table) {
            super(space, colName, datatype, label, table);
        }

        @Override
        public boolean isDistinct() {
            return false;
        }
    }

    public static class TableStub
    implements Table {
        String label;
        Table parent;

        public TableStub(String label, Table parent) {
            this.label = label;
            this.parent = parent;
        }

        @Override
        public String getLabel() {
            return this.label;
        }

        @Override
        public Table getParent() {
            return this.parent;
        }
    }
}

