/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.aggdes.output.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import mondrian.olap.Util;
import mondrian.rolap.RolapCubeLevel;
import mondrian.util.UnionIterator;
import org.pentaho.aggdes.model.Aggregate;
import org.pentaho.aggdes.model.Attribute;
import org.pentaho.aggdes.model.Dimension;
import org.pentaho.aggdes.model.Hierarchy;
import org.pentaho.aggdes.model.Level;
import org.pentaho.aggdes.model.Measure;
import org.pentaho.aggdes.model.Schema;
import org.pentaho.aggdes.model.mondrian.MondrianLevel;
import org.pentaho.aggdes.model.mondrian.MondrianMeasure;
import org.pentaho.aggdes.output.Output;
import org.pentaho.aggdes.output.OutputFactory;
import org.pentaho.aggdes.output.impl.AggregateTableOutput;

public class RuleBasedAggregateTableOutputFactory
implements OutputFactory {
    public Class getOutputClass() {
        return AggregateTableOutput.class;
    }

    @Override
    public boolean canCreateOutput(Schema schema) {
        return true;
    }

    @Override
    public AggregateTableOutput createOutput(Schema schema, Aggregate aggregate) {
        return this.createOutput(schema, aggregate, new ArrayList<String>());
    }

    public AggregateTableOutput createOutput(Schema schema, Aggregate aggregate, List<String> uniqueTableNames) {
        AggregateTableOutput output = new AggregateTableOutput(aggregate);
        String tableName = schema.getDialect().removeInvalidIdentifierCharacters(aggregate.getCandidateTableName());
        tableName = Util.uniquify((String)tableName, (int)schema.getDialect().getMaximumTableNameLength(), uniqueTableNames);
        output.setTableName(tableName);
        ArrayList columnNameList = new ArrayList();
        for (Attribute attribute : UnionIterator.over((Collection[])new Collection[]{aggregate.getAttributes(), aggregate.getMeasures()})) {
            if (attribute instanceof Measure) {
                String name = this.cleanse(((MondrianMeasure)attribute).getRolapStarMeasure().getName());
                output.getColumnOutputs().add(new AggregateTableOutput.ColumnOutput(name, attribute));
                continue;
            }
            Level level = this.findLevel(schema, attribute);
            RolapCubeLevel rolapLevel = ((MondrianLevel)level).getRolapCubeLevel();
            output.getColumnOutputs().add(new AggregateTableOutput.ColumnOutput(this.cleanse(rolapLevel.getHierarchy().getName()) + "_" + this.cleanse(rolapLevel.getName()), attribute));
        }
        return output;
    }

    public String cleanse(String str) {
        return str.replaceAll("\\.", "_").replaceAll(" ", "_").toLowerCase();
    }

    @Override
    public List<Output> createOutputs(Schema schema, List<Aggregate> aggregates) {
        ArrayList<Output> outputs = new ArrayList<Output>();
        ArrayList<String> uniqueTableNames = new ArrayList<String>();
        for (Aggregate aggregate : aggregates) {
            outputs.add(this.createOutput(schema, aggregate, uniqueTableNames));
        }
        return outputs;
    }

    private Level findLevel(Schema schema, Attribute attribute) {
        for (Dimension dimension : schema.getDimensions()) {
            for (Hierarchy hierarchy : dimension.getHierarchies()) {
                for (Level level : hierarchy.getLevels()) {
                    if (level.getAttribute() != attribute) continue;
                    return level;
                }
            }
        }
        System.out.println("failed to locate level for attribute " + attribute.getLabel());
        return null;
    }
}

