/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.aggdes.output.impl;

import java.util.ArrayList;
import org.pentaho.aggdes.model.Dialect;
import org.pentaho.aggdes.model.Schema;
import org.pentaho.aggdes.output.Output;
import org.pentaho.aggdes.output.PopulateScriptGenerator;
import org.pentaho.aggdes.output.impl.AbstractGenerator;
import org.pentaho.aggdes.output.impl.AggregateTableOutput;
import org.pentaho.aggdes.output.impl.ResultHandlerImpl;

public class PopulateTableGenerator
extends AbstractGenerator
implements PopulateScriptGenerator {
    @Override
    public Class[] getSupportedOutputClasses() {
        return new Class[]{AggregateTableOutput.class};
    }

    @Override
    public boolean canGenerate(Schema schema, Output output) {
        return output instanceof AggregateTableOutput;
    }

    @Override
    public String generate(Schema schema, Output output) {
        AggregateTableOutput tableOutput = (AggregateTableOutput)output;
        Dialect dialect = schema.getDialect();
        StringBuilder buf = new StringBuilder();
        dialect.comment(buf, "Populate aggregate table " + tableOutput.getTableName());
        buf.append("INSERT INTO ");
        dialect.quoteIdentifier(buf, tableOutput.getCatalogName(), tableOutput.getSchemaName(), tableOutput.getTableName());
        buf.append(" (").append(ResultHandlerImpl.NL);
        int k = -1;
        ArrayList<String> columnNameList = new ArrayList<String>();
        for (AggregateTableOutput.ColumnOutput column : tableOutput.getColumnOutputs()) {
            if (++k > 0) {
                buf.append(",").append(ResultHandlerImpl.NL);
            }
            buf.append("    ");
            dialect.quoteIdentifier(buf, column.getName());
            columnNameList.add(column.getName());
        }
        buf.append(")").append(ResultHandlerImpl.NL);
        String sql = schema.generateAggregateSql(tableOutput.getAggregate(), columnNameList);
        buf.append(sql);
        dialect.terminateCommand(buf);
        return buf.toString();
    }
}

