/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.aggdes.output.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import mondrian.olap.Util;
import mondrian.util.UnionIterator;
import org.pentaho.aggdes.model.Aggregate;
import org.pentaho.aggdes.model.Attribute;
import org.pentaho.aggdes.model.Schema;
import org.pentaho.aggdes.output.Output;
import org.pentaho.aggdes.output.OutputFactory;
import org.pentaho.aggdes.output.impl.AggregateTableOutput;

public class AggregateTableOutputFactory
implements OutputFactory {
    public Class getOutputClass() {
        return AggregateTableOutput.class;
    }

    @Override
    public boolean canCreateOutput(Schema schema) {
        return true;
    }

    @Override
    public AggregateTableOutput createOutput(Schema schema, Aggregate aggregate) {
        return this.createOutput(schema, aggregate, new ArrayList<String>());
    }

    public AggregateTableOutput createOutput(Schema schema, Aggregate aggregate, List<String> uniqueTableNames) {
        AggregateTableOutput output = new AggregateTableOutput(aggregate);
        String tableName = schema.getDialect().removeInvalidIdentifierCharacters(aggregate.getCandidateTableName());
        tableName = Util.uniquify((String)tableName, (int)schema.getDialect().getMaximumTableNameLength(), uniqueTableNames);
        output.setTableName(tableName);
        ArrayList columnNameList = new ArrayList();
        int maximumColumnNameLength = schema.getDialect().getMaximumColumnNameLength();
        for (Attribute attribute : UnionIterator.over((Collection[])new Collection[]{aggregate.getAttributes(), aggregate.getMeasures()})) {
            String name = Util.uniquify((String)attribute.getCandidateColumnName(), (int)maximumColumnNameLength, columnNameList);
            output.getColumnOutputs().add(new AggregateTableOutput.ColumnOutput(name, attribute));
        }
        return output;
    }

    @Override
    public List<Output> createOutputs(Schema schema, List<Aggregate> aggregates) {
        ArrayList<Output> outputs = new ArrayList<Output>();
        ArrayList<String> uniqueTableNames = new ArrayList<String>();
        for (Aggregate aggregate : aggregates) {
            outputs.add(this.createOutput(schema, aggregate, uniqueTableNames));
        }
        return outputs;
    }
}

