/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.aggdes.model.mondrian.validate;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import mondrian.olap.MondrianDef;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.aggdes.model.ValidationMessage;
import org.pentaho.aggdes.model.mondrian.validate.AbstractMondrianSchemaValidator;

public class CubePkValidator
extends AbstractMondrianSchemaValidator {
    private static final Log logger = LogFactory.getLog(CubePkValidator.class);

    @Override
    public List<ValidationMessage> validateCube(MondrianDef.Schema schema, MondrianDef.Cube cube, Connection conn) {
        ArrayList<ValidationMessage> messages = new ArrayList<ValidationMessage>();
        HashMap checkedRelations = new HashMap();
        DatabaseMetaData meta = null;
        try {
            meta = conn.getMetaData();
        }
        catch (SQLException e) {
            if (logger.isErrorEnabled()) {
                logger.error((Object)"an exception occurred", (Throwable)e);
            }
            return this.fatal(e, messages);
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("processing cube \"" + cube.name + "\""));
        }
        if (!(cube.fact instanceof MondrianDef.Table)) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("cube \"" + cube.name + "\" contains unsupported fact type, " + cube.fact));
            }
            return messages;
        }
        String relationName = ((MondrianDef.Table)cube.fact).name;
        String schemaName = ((MondrianDef.Table)cube.fact).schema;
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("checking that primary key exists on relation \"" + (null == schemaName ? "" : schemaName + ".") + relationName + "\""));
        }
        ResultSet rs = null;
        try {
            rs = meta.getPrimaryKeys(null, schemaName, relationName);
        }
        catch (SQLException e) {
            if (logger.isErrorEnabled()) {
                logger.error((Object)"an exception occurred", (Throwable)e);
            }
            return this.fatal(e, messages);
        }
        boolean pkFound = false;
        try {
            if (rs.next()) {
                pkFound = true;
            }
        }
        catch (SQLException e) {
            if (logger.isErrorEnabled()) {
                logger.error((Object)"an exception occurred", (Throwable)e);
            }
            return this.fatal(e, messages);
        }
        if (!pkFound) {
            this.append(messages, ValidationMessage.Type.ERROR, "ERROR_FACT_TABLE_PK_CHECK", cube.name, relationName);
        } else {
            this.append(messages, ValidationMessage.Type.OK, "OK_FACT_TABLE_PK_CHECK", cube.name, relationName);
        }
        return messages;
    }
}

