/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.aggdes.model.mondrian;

import com.google.common.annotations.VisibleForTesting;
import java.sql.Connection;
import java.sql.DriverManager;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import mondrian.olap.Util;
import mondrian.rolap.RolapConnection;
import mondrian.rolap.RolapCube;
import mondrian.rolap.RolapSchema;
import mondrian.rolap.RolapStar;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.aggdes.algorithm.impl.AlgorithmImpl;
import org.pentaho.aggdes.algorithm.util.ArgumentUtils;
import org.pentaho.aggdes.model.Parameter;
import org.pentaho.aggdes.model.Schema;
import org.pentaho.aggdes.model.SchemaLoader;
import org.pentaho.aggdes.model.ValidationMessage;
import org.pentaho.aggdes.model.mondrian.MondrianSchema;
import org.pentaho.aggdes.model.mondrian.validate.MondrianSchemaValidator;
import org.pentaho.aggdes.model.mondrian.validate.ValidationHelper;

public class MondrianSchemaLoader
implements SchemaLoader {
    private static final Log logger = LogFactory.getLog(MondrianSchemaLoader.class);

    @Override
    public Schema createSchema(Map<Parameter, Object> parameterValues) {
        String connectString = (String)parameterValues.get(MondrianSchemaLoaderParameter.connectString);
        String cubeName = (String)parameterValues.get(MondrianSchemaLoaderParameter.cube);
        RolapConnection connection = (RolapConnection)mondrian.olap.DriverManager.getConnection((String)connectString, null);
        RolapSchema schema = connection.getSchema();
        RolapCube cube = (RolapCube)schema.lookupCube(cubeName, true);
        return new MondrianSchema(connection, cube);
    }

    @Override
    public List<ValidationMessage> validateSchema(Map<Parameter, Object> parameterValues) {
        String connectString = (String)parameterValues.get(MondrianSchemaLoaderParameter.connectString);
        String cubeName = (String)parameterValues.get(MondrianSchemaLoaderParameter.cube);
        Util.PropertyList propertyList = Util.parseConnectString((String)connectString);
        String jdbcDrivers = propertyList.get("JdbcDrivers");
        if (StringUtils.isBlank((String)jdbcDrivers)) {
            throw new RuntimeException("missing 'JdbcDrivers' in connect string");
        }
        Boolean integratedSecurity = Boolean.parseBoolean(propertyList.get("integratedSecurity"));
        String jdbc = this.getJdbcConnectionString(propertyList, integratedSecurity);
        if (StringUtils.isBlank((String)jdbcDrivers)) {
            throw new RuntimeException("missing 'Jdbc' in connect string");
        }
        String catalog = propertyList.get("Catalog");
        if (StringUtils.isBlank((String)jdbcDrivers)) {
            throw new RuntimeException("missing 'Catalog' in connect string");
        }
        String jdbcUser = propertyList.get("JdbcUser");
        String jdbcPassword = propertyList.get("JdbcPassword");
        ArrayList<ValidationMessage> messages = new ArrayList();
        try {
            List<MondrianSchemaValidator> validators = this.loadValidators(parameterValues);
            Class.forName(jdbcDrivers);
            Connection conn = integratedSecurity != false ? DriverManager.getConnection(jdbc) : DriverManager.getConnection(jdbc, jdbcUser, jdbcPassword);
            messages = ValidationHelper.validateCube(catalog, cubeName, conn, validators);
            conn.close();
        }
        catch (Exception e) {
            if (logger.isErrorEnabled()) {
                logger.error((Object)"an exception occurred", (Throwable)e);
            }
            ValidationMessage msg = new ValidationMessage(ValidationMessage.Type.ERROR, e.getClass().getName() + ": " + e.getLocalizedMessage());
            messages.add(msg);
        }
        return messages;
    }

    protected List<MondrianSchemaValidator> loadValidators(Map<Parameter, Object> parameterValues) throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        String validatorClassString = (String)parameterValues.get(MondrianSchemaLoaderParameter.validators);
        if (null == validatorClassString || "".equals(validatorClassString)) {
            return Collections.emptyList();
        }
        String[] validatorClassNames = validatorClassString.split(",");
        ArrayList<MondrianSchemaValidator> validators = new ArrayList<MondrianSchemaValidator>();
        for (String className : validatorClassNames) {
            Class<?> clazz = Class.forName(className);
            if (!MondrianSchemaValidator.class.isAssignableFrom(clazz)) {
                throw new ArgumentUtils.ValidationException(null, "Class '" + className + "' does not implement required interface 'MondrianSchemaValidator'");
            }
            validators.add((MondrianSchemaValidator)MondrianSchemaValidator.class.cast(clazz.newInstance()));
        }
        return validators;
    }

    @Override
    public List<Parameter> getParameters() {
        return Arrays.asList((Parameter[])MondrianSchemaLoaderParameter.values());
    }

    @Override
    public String getName() {
        return AlgorithmImpl.getBaseName(this.getClass());
    }

    public static double estimateAggregateCount(double[] cardinalities, double factCount) {
        double comboCount = 1.0;
        for (double cardinality : cardinalities) {
            comboCount *= cardinality;
        }
        return MondrianSchemaLoader.estimateAggregateCount(comboCount, factCount);
    }

    public static double estimateAggregateCount(double comboCount, double factCount) {
        if (comboCount > factCount * 10.0) {
            return factCount;
        }
        double rowProb = 1.0 / comboCount;
        double aggProb = Math.pow(1.0 - rowProb, factCount);
        return comboCount - comboCount * aggProb;
    }

    static double estimateSpaceForColumn(RolapStar.Column column) {
        switch (column.getDatatype()) {
            case Boolean: {
                return 1.0;
            }
            case Date: {
                return 4.0;
            }
            case Integer: {
                return 4.0;
            }
            case Numeric: {
                return 4.0;
            }
            case String: {
                return 20.0;
            }
            case Time: {
                return 4.0;
            }
            case Timestamp: {
                return 8.0;
            }
        }
        throw Util.unexpected((Enum)column.getDatatype());
    }

    @VisibleForTesting
    String getJdbcConnectionString(Util.PropertyList propertyList, Boolean integratedSecurity) {
        String jdbc = propertyList.get("Jdbc");
        if (StringUtils.isBlank((String)jdbc)) {
            return null;
        }
        String database = StringUtils.isBlank((String)propertyList.get("databaseName")) ? "" : ";databaseName=" + propertyList.get("databaseName");
        String sIntegratedSecurity = integratedSecurity != false ? ";integratedSecurity=true" : "";
        return jdbc + database + sIntegratedSecurity;
    }

    public static enum MondrianSchemaLoaderParameter implements Parameter
    {
        connectString("Mondrian connect string", true, Parameter.Type.STRING),
        cube("Name of cube", true, Parameter.Type.STRING),
        validators("Comma-separated list of validators", false, Parameter.Type.STRING);

        private final String description;
        private final boolean required;
        private final Parameter.Type type;

        private MondrianSchemaLoaderParameter(String description, boolean required, Parameter.Type type) {
            this.description = description;
            this.required = required;
            this.type = type;
        }

        @Override
        public boolean isRequired() {
            return this.required;
        }

        @Override
        public Parameter.Type getType() {
            return this.type;
        }

        @Override
        public String getDescription() {
            return this.description;
        }

        @Override
        public String getName() {
            return this.name();
        }
    }
}

