/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.aggdes.model.mondrian;

import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import mondrian.spi.Dialect;
import org.pentaho.aggdes.model.Dialect;

public class MondrianDialect
implements Dialect {
    private final mondrian.spi.Dialect dialect;

    public MondrianDialect(mondrian.spi.Dialect dialect) {
        this.dialect = dialect;
    }

    @Override
    public void quoteIdentifier(StringBuilder buf, String ... names) {
        this.dialect.quoteIdentifier(buf, names);
    }

    @Override
    public String getIntegerTypeString() {
        if (this.dialect.getDatabaseProduct() == Dialect.DatabaseProduct.POSTGRESQL) {
            return "INT8";
        }
        return "INTEGER";
    }

    @Override
    public String getDoubleTypeString() {
        if (this.dialect.getDatabaseProduct() == Dialect.DatabaseProduct.ORACLE) {
            return "NUMBER";
        }
        if (this.dialect.getDatabaseProduct() == Dialect.DatabaseProduct.POSTGRESQL) {
            return "FLOAT8";
        }
        if (this.dialect.getDatabaseProduct() == Dialect.DatabaseProduct.MSSQL) {
            return "FLOAT";
        }
        return "DOUBLE";
    }

    @Override
    public String removeInvalidIdentifierCharacters(String str) {
        return str.replaceAll("\\s", "_").replaceAll("[^\\w_]", "");
    }

    @Override
    public int getMaximumTableNameLength() {
        return 30;
    }

    @Override
    public int getMaximumColumnNameLength() {
        return 30;
    }

    public mondrian.spi.Dialect getMondrianDialect() {
        return this.dialect;
    }

    @Override
    public void comment(StringBuilder buf, String s) {
        buf.append("-- ").append(s).append(NL);
    }

    @Override
    public void terminateCommand(StringBuilder buf) {
        buf.append(";").append(NL);
    }

    @Override
    public boolean supportsPrecision(DatabaseMetaData meta, String type) throws SQLException {
        return meta.getDatabaseProductName().toUpperCase().indexOf("HSQL") < 0 && (this.dialect.getDatabaseProduct() != Dialect.DatabaseProduct.POSTGRESQL && this.dialect.getDatabaseProduct() != Dialect.DatabaseProduct.LUCIDDB || type.toUpperCase().indexOf("CHAR") >= 0) && this.dialect.getDatabaseProduct() == Dialect.DatabaseProduct.MSSQL && type.toUpperCase().indexOf("INT") < 0;
    }
}

