/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.aggdes.ui.util;

import com.thoughtworks.xstream.converters.Converter;
import com.thoughtworks.xstream.converters.MarshallingContext;
import com.thoughtworks.xstream.converters.UnmarshallingContext;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import org.pentaho.aggdes.model.Measure;
import org.pentaho.aggdes.model.Schema;

public class MeasureConverter
implements Converter {
    Schema schema;

    public MeasureConverter(Schema schema) {
        this.schema = schema;
    }

    public void marshal(Object object, HierarchicalStreamWriter writer, MarshallingContext context) {
        Measure measure = (Measure)object;
        writer.startNode("label");
        writer.setValue(measure.getLabel());
        writer.endNode();
        writer.startNode("table");
        writer.setValue(measure.getTable().getLabel());
        writer.endNode();
    }

    public Object unmarshal(HierarchicalStreamReader reader, UnmarshallingContext context) {
        reader.moveDown();
        String label = reader.getValue();
        reader.moveUp();
        reader.moveDown();
        String tableLabel = reader.getValue();
        reader.moveUp();
        Measure foundMeasure = null;
        for (Measure measure : this.schema.getMeasures()) {
            if (!measure.getLabel().equals(label) || !measure.getTable().getLabel().equals(tableLabel)) continue;
            foundMeasure = measure;
            break;
        }
        if (foundMeasure == null) {
            throw new RuntimeException("Error: Unable to find measure");
        }
        return foundMeasure;
    }

    public boolean canConvert(Class clazz) {
        return Measure.class.isAssignableFrom(clazz);
    }
}

