/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.aggdes.ui.util;

import java.util.ArrayList;
import java.util.List;
import org.pentaho.aggdes.Main;
import org.pentaho.aggdes.model.Schema;
import org.pentaho.aggdes.model.mondrian.MondrianSchema;
import org.pentaho.aggdes.ui.model.UIAggregate;
import org.pentaho.aggdes.ui.util.AggregateNamingService;

public class AggregateNamingServiceImpl
implements AggregateNamingService {
    @Override
    public void nameAggregate(UIAggregate newAggregate, Iterable<UIAggregate> existingAggregates, Schema schema) {
        ArrayList<UIAggregate> newAggregates = new ArrayList<UIAggregate>();
        newAggregates.add(newAggregate);
        this.nameAggregates(newAggregates, existingAggregates, schema);
    }

    @Override
    public void nameAggregates(List<UIAggregate> newAggregates, Iterable<UIAggregate> existingAggregates, Schema schema) {
        String schemaName = ((MondrianSchema)schema).getRolapConnection().getSchema().getName();
        if ((schemaName = Main.depunctify((String)schemaName)).length() > 10) {
            schemaName = schemaName.substring(0, 10);
        }
        String cubeName = ((MondrianSchema)schema).getRolapCube().getName();
        if ((cubeName = Main.depunctify((String)cubeName)).length() > 10) {
            cubeName = cubeName.substring(0, 10);
        }
        String aggNamePre = schemaName + "_" + cubeName + "_";
        int max = 0;
        if (existingAggregates != null) {
            for (UIAggregate agg : existingAggregates) {
                if (!agg.getName().startsWith(aggNamePre)) continue;
                String val = agg.getName().substring(aggNamePre.length());
                try {
                    int curr = Integer.parseInt(val);
                    if (curr <= max) continue;
                    max = curr;
                }
                catch (NumberFormatException numberFormatException) {}
            }
        }
        for (UIAggregate agg : newAggregates) {
            agg.setName(aggNamePre + ++max);
        }
    }
}

