/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.aggdes.ui.form.model;

import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.aggdes.model.Attribute;
import org.pentaho.aggdes.model.Dimension;
import org.pentaho.aggdes.model.Hierarchy;
import org.pentaho.aggdes.model.Level;
import org.pentaho.ui.xul.XulEventSourceAdapter;

public class DimensionRowModel
extends XulEventSourceAdapter {
    private String dimensionName;
    private Dimension dimension;
    private Vector<String> levelNames;
    private int selectedIndex = 0;
    List<Attribute> allLevelAttributes = new ArrayList<Attribute>();
    List<Level> allLevels = new ArrayList<Level>();
    private static final Log logger = LogFactory.getLog(DimensionRowModel.class);

    public void setDimension(Dimension dimension) {
        this.dimension = dimension;
        Vector<String> hierarchyLevelVector = new Vector<String>();
        for (Hierarchy h : dimension.getHierarchies()) {
            List levels = h.getLevels();
            for (Level level : levels) {
                this.allLevelAttributes.add(level.getAttribute());
                this.allLevels.add(level);
                String prefix = dimension.getHierarchies().size() > 1 ? h.getName() + " : " : "";
                hierarchyLevelVector.add(prefix + level.getName());
            }
        }
        this.setLevelNames(hierarchyLevelVector);
    }

    public int getSelectedIndex() {
        return this.selectedIndex;
    }

    public void setSelectedIndex(int selectedIndex) {
        this.selectedIndex = selectedIndex;
        this.firePropertyChange("selectedIndex", null, selectedIndex);
    }

    public Level getSelectedItem() {
        if (this.allLevels.isEmpty()) {
            return null;
        }
        return this.allLevels.get(this.selectedIndex);
    }

    public String getDimensionName() {
        return this.dimension.getName();
    }

    public void setDimensionName(String dimensionName) {
    }

    public Vector<String> getLevelNames() {
        return this.levelNames;
    }

    public void setLevelNames(Vector<String> levelNames) {
        this.levelNames = levelNames;
    }

    public void initSelected(List<Attribute> attributes) {
        for (Attribute attribute : attributes) {
            int index = this.allLevelAttributes.indexOf(attribute);
            if (index < 0) continue;
            this.setSelectedIndex(index);
        }
    }
}

