/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.aggdes.ui.form.model;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.aggdes.model.Schema;
import org.pentaho.aggdes.ui.form.model.ConnectionModel;
import org.pentaho.aggdes.ui.model.SchemaModel;
import org.pentaho.aggdes.ui.util.Messages;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.ui.xul.XulEventSourceAdapter;
import org.pentaho.ui.xul.stereotype.FormModel;

@FormModel
public class ConnectionModelImpl
extends XulEventSourceAdapter
implements ConnectionModel {
    private static final Log logger = LogFactory.getLog(ConnectionModelImpl.class);
    private DatabaseMeta databaseMeta;
    private List<String> cubeNames;
    private String schemaName;
    private boolean connectEnabled = false;
    private boolean schemaSourceSelectionEnabled = false;
    private boolean schemaUpToDate = false;
    private String databaseName;
    private String cubeName;
    private Schema schema;
    private SchemaModel schemaModel;
    private boolean applySchemaSourceEnabled = false;
    private boolean schemaLocked = false;

    @Override
    public void setSchema(Schema schema) {
        this.schema = schema;
        this.firePropertyChange("schema", null, schema);
    }

    @Override
    public Schema getSchema() {
        return this.schema;
    }

    @Override
    public String getDatabaseName() {
        return this.databaseMeta != null ? this.databaseMeta.getDatabaseName() : null;
    }

    @Override
    public void setDatabaseMeta(DatabaseMeta databaseMeta) {
        this.databaseMeta = databaseMeta;
        this.setSchemaSourceSelectionEnabled(databaseMeta != null);
        this.setDatabaseName(databaseMeta != null ? databaseMeta.getName() : "");
        if (databaseMeta != null) {
            try {
                File file = new File(".databaseMetaInfo");
                PrintWriter pw = new PrintWriter(new FileWriter(file));
                pw.println(databaseMeta.getXML());
                pw.close();
                logger.debug((Object)databaseMeta.getURL());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public DatabaseMeta getDatabaseMeta() {
        File file;
        if (this.databaseMeta == null && (file = new File(".databaseMetaInfo")).exists()) {
            try {
                this.databaseMeta = new DatabaseMeta(this.getFileContents(file));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return this.databaseMeta;
    }

    @Override
    public String getCubeName() {
        if (this.schemaModel == null) {
            return null;
        }
        return this.schemaModel.getCubeName();
    }

    @Override
    public void setCubeName(String cubeName) {
        if (cubeName != null && cubeName.equals(Messages.getString("select_cube", new Object[0]))) {
            cubeName = null;
        }
        String oldVal = this.cubeName;
        if (this.schemaModel != null) {
            this.schemaModel.setCubeName(cubeName);
        }
        if (cubeName == null) {
            cubeName = Messages.getString("select_cube", new Object[0]);
        }
        this.cubeName = cubeName;
        this.firePropertyChange("cubeName", oldVal, cubeName);
        this.validate();
    }

    private void validate() {
        this.setConnectEnabled(this.databaseMeta != null && this.getCubeName() != null);
    }

    @Override
    public List<String> getCubeNames() {
        return this.cubeNames;
    }

    @Override
    public boolean isCubeSelectionEnabled() {
        return this.cubeNames != null && this.cubeNames.size() > 0;
    }

    @Override
    public void setCubeNames(List<String> cubeNames) {
        List<String> prevNames = this.cubeNames;
        boolean prevEnabled = this.isCubeSelectionEnabled();
        this.cubeNames = cubeNames;
        this.firePropertyChange("cubeSelectionEnabled", prevEnabled, this.isCubeSelectionEnabled());
        if (cubeNames == null) {
            cubeNames = new ArrayList<String>();
            cubeNames.add(Messages.getString("select_cube", new Object[0]));
        }
        this.firePropertyChange("cubeNames", prevNames, cubeNames);
    }

    @Override
    public void setConnectEnabled(boolean b) {
        this.connectEnabled = b;
        this.firePropertyChange("connectEnabled", null, b);
    }

    @Override
    public boolean isConnectEnabled() {
        return this.connectEnabled;
    }

    @Override
    public void setSchemaSourceSelectionEnabled(boolean b) {
        this.schemaSourceSelectionEnabled = b;
        this.firePropertyChange("schemaSourceSelectionEnabled", null, b);
    }

    @Override
    public boolean isSchemaSourceSelectionEnabled() {
        return this.schemaSourceSelectionEnabled;
    }

    @Override
    public boolean isApplySchemaSourceEnabled() {
        return this.applySchemaSourceEnabled;
    }

    @Override
    public void setApplySchemaSourceEnabled(boolean applySchemaSourceEnabled) {
        Boolean oldVal = this.applySchemaSourceEnabled;
        this.applySchemaSourceEnabled = applySchemaSourceEnabled;
        this.firePropertyChange("applySchemaSourceEnabled", oldVal, applySchemaSourceEnabled);
    }

    @Override
    public String getSchemaName() {
        return this.schemaName;
    }

    @Override
    public void setSchemaName(String schemaName) {
        String oldSchemaName = this.schemaName;
        this.schemaName = schemaName;
        this.firePropertyChange("schemaName", oldSchemaName, schemaName);
    }

    @Override
    public boolean getSchemaUpToDate() {
        return this.schemaUpToDate;
    }

    @Override
    public void setSchemaUpToDate(boolean upToDate) {
        this.schemaUpToDate = upToDate;
        this.firePropertyChange("schemaUpToDate", null, this.schemaUpToDate);
    }

    public void setDatabaseName(String databaseName) {
        String oldVal = this.databaseName;
        this.databaseName = databaseName;
        this.firePropertyChange("databaseName", oldVal, databaseName);
    }

    @Override
    public SchemaModel getSelectedSchemaModel() {
        return this.schemaModel;
    }

    @Override
    public void setSelectedSchemaModel(SchemaModel schemaModel) {
        this.schemaModel = schemaModel;
        this.firePropertyChange("selectedSchemaModel", null, schemaModel);
    }

    @Override
    public void reset() {
        this.setCubeName(null);
        this.setCubeNames(null);
        this.setSelectedSchemaModel(null);
        this.setDatabaseMeta(null);
        this.setSchemaLocked(false);
        this.setSchema(null);
        this.setSchemaName(null);
        this.firePropertyChange("schemaName", "", this.schemaName);
        this.setApplySchemaSourceEnabled(false);
        this.firePropertyChange("applySchemaSourceEnabled", null, this.applySchemaSourceEnabled);
        this.setSchemaSourceSelectionEnabled(false);
        this.setSchemaUpToDate(false);
    }

    private String getFileContents(File file) {
        try {
            BufferedReader br = new BufferedReader(new FileReader(file));
            StringBuilder sb = new StringBuilder();
            String line = null;
            while ((line = br.readLine()) != null) {
                sb.append(line + "\n");
            }
            return sb.toString();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public boolean isSchemaLocked() {
        return this.schemaLocked;
    }

    @Override
    public void setSchemaLocked(boolean locked) {
        boolean oldVal = this.schemaLocked;
        this.schemaLocked = locked;
        this.firePropertyChange("schemaLocked", oldVal, this.schemaLocked);
    }
}

