/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.aggdes.ui.form.controller;

import java.io.File;
import javax.swing.JFrame;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.aggdes.model.mondrian.MondrianSchema;
import org.pentaho.aggdes.ui.Workspace;
import org.pentaho.aggdes.ui.ext.impl.MondrianFileSchemaModel;
import org.pentaho.aggdes.ui.form.controller.ExportHandler;
import org.pentaho.aggdes.ui.form.model.ConnectionModel;
import org.pentaho.mondrian.publish.Messages;
import org.pentaho.mondrian.publish.PublishSchemaPluginParent;
import org.pentaho.mondrian.publish.PublishToServerCommand;
import org.pentaho.ui.xul.XulException;
import org.pentaho.ui.xul.components.XulMessageBox;
import org.pentaho.ui.xul.impl.AbstractXulEventHandler;
import org.pentaho.ui.xul.stereotype.Controller;

@Controller
public class PublishController
extends AbstractXulEventHandler
implements PublishSchemaPluginParent {
    private static final Log logger = LogFactory.getLog(PublishController.class);
    ExportHandler exportHandler;
    private Workspace workspace;
    private ConnectionModel connectionModel;

    public void setWorkspace(Workspace workspace) {
        this.workspace = workspace;
    }

    public void setExportHandler(ExportHandler exportHandler) {
        this.exportHandler = exportHandler;
    }

    public void publishSchema() throws XulException {
        if (!(this.connectionModel.getSelectedSchemaModel() instanceof MondrianFileSchemaModel)) {
            XulMessageBox msgBox = (XulMessageBox)this.document.createElement("messagebox");
            msgBox.setMessage("Inconsistent application state: Only MondrianFileSchemaModel should call into this method");
            msgBox.open();
            logger.error((Object)"Inconsistent application state: Only MondrianFileSchemaModel should call into this method");
            return;
        }
        File schemaFile = new File(((MondrianFileSchemaModel)this.connectionModel.getSelectedSchemaModel()).getMondrianSchemaFilename());
        if (!this.connectionModel.getSchemaUpToDate()) {
            XulMessageBox msgBox = (XulMessageBox)this.document.createElement("messagebox");
            msgBox.setTitle(Messages.getString((String)"SchemaModifiedWarning.Title"));
            msgBox.setMessage(Messages.getString((String)"SchemaModifiedWarning.Message"));
            msgBox.setButtons((Object[])new String[]{"Yes", "No", "Cancel"});
            int option = msgBox.open();
            if (option == 0) {
                schemaFile = this.exportHandler.saveOlap();
            } else if (option == 2) {
                return;
            }
        }
        if (schemaFile != null) {
            PublishToServerCommand command = new PublishToServerCommand();
            command.execute((PublishSchemaPluginParent)this);
        }
    }

    public JFrame getFrame() {
        return (JFrame)this.document.getRootElement().getManagedObject();
    }

    public File getSchemaFile() {
        return new File(((MondrianFileSchemaModel)this.connectionModel.getSelectedSchemaModel()).getMondrianSchemaFilename());
    }

    public String getSchemaName() {
        return ((MondrianSchema)this.connectionModel.getSchema()).getRolapConnection().getSchema().getName();
    }

    public String getProperty(String name) {
        return this.workspace.getWorkspaceProperty(name);
    }

    public void setProperty(String name, String value) {
        this.workspace.setWorkspaceProperty(name, value);
    }

    public void storeProperties() {
        this.workspace.storeWorkspaceProperties();
    }

    public void setConnectionModel(ConnectionModel connectionModel) {
        this.connectionModel = connectionModel;
    }
}

