/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.aggdes.ui.form.controller;

import edu.stanford.ejalbert.BrowserLauncher;
import edu.stanford.ejalbert.exception.BrowserLaunchingInitializingException;
import edu.stanford.ejalbert.exception.UnsupportedOperatingSystemException;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.util.Date;
import java.util.Properties;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.aggdes.AggDesignerException;
import org.pentaho.aggdes.model.Schema;
import org.pentaho.aggdes.ui.Workspace;
import org.pentaho.aggdes.ui.form.controller.AggListController;
import org.pentaho.aggdes.ui.form.controller.ConnectionController;
import org.pentaho.aggdes.ui.form.model.ConnectionModel;
import org.pentaho.aggdes.ui.model.AggList;
import org.pentaho.aggdes.ui.util.Messages;
import org.pentaho.aggdes.ui.util.SerializationService;
import org.pentaho.ui.xul.XulException;
import org.pentaho.ui.xul.XulRunner;
import org.pentaho.ui.xul.binding.Binding;
import org.pentaho.ui.xul.binding.BindingConvertor;
import org.pentaho.ui.xul.binding.BindingFactory;
import org.pentaho.ui.xul.components.XulFileDialog;
import org.pentaho.ui.xul.components.XulLabel;
import org.pentaho.ui.xul.components.XulMenuitem;
import org.pentaho.ui.xul.components.XulMessageBox;
import org.pentaho.ui.xul.containers.XulDeck;
import org.pentaho.ui.xul.containers.XulDialog;
import org.pentaho.ui.xul.containers.XulWindow;
import org.pentaho.ui.xul.impl.AbstractXulEventHandler;
import org.pentaho.ui.xul.stereotype.Controller;
import org.springframework.beans.factory.annotation.Autowired;

@Controller
public class MainController
extends AbstractXulEventHandler {
    public static XulRunner mainFrameInstance;
    private static final Log logger;
    private Workspace workspace;
    private XulMenuitem paste;
    private XulDeck rightDeck = null;
    private AggListController aggListController;
    private AggList aggList;
    private SerializationService serializationService;
    private ConnectionModel connectionModel;
    private ConnectionController connectionController;
    private BindingFactory bindingFactory;

    @Autowired
    public void setBindingFactory(BindingFactory bindingFactory) {
        this.bindingFactory = bindingFactory;
    }

    public void setAggListController(AggListController aggListController) {
        this.aggListController = aggListController;
    }

    public void setConnectionController(ConnectionController connectionController) {
        this.connectionController = connectionController;
    }

    public void setSerializationService(SerializationService serializationService) {
        this.serializationService = serializationService;
    }

    public void setAggList(AggList aggList) {
        this.aggList = aggList;
    }

    public void onLoad() {
        this.bindingFactory.setDocument(this.document);
        this.bindingFactory.setBindingType(Binding.Type.ONE_WAY);
        this.bindingFactory.createBinding((Object)this.workspace, "saveEnabled", "save_button", "!disabled", new BindingConvertor[0]);
        this.bindingFactory.createBinding((Object)this.workspace, "saveEnabled", "save_menuitem", "!disabled", new BindingConvertor[0]);
        this.bindingFactory.createBinding((Object)this.workspace, "applicationUnlocked", "save_as_button", "!disabled", new BindingConvertor[0]);
        this.bindingFactory.createBinding((Object)this.workspace, "applicationUnlocked", "save_as_menuitem", "!disabled", new BindingConvertor[0]);
    }

    public void show(int idx) {
        if (this.rightDeck == null) {
            this.rightDeck = (XulDeck)this.document.getElementById("rightDeck");
        }
        this.rightDeck.setSelectedIndex(idx);
        if (idx == 2) {
            this.aggListController.displayNewOrExistingAgg();
        }
    }

    public void openWorkspace() throws XulException {
        if (!this.promptIfSaveRequired()) {
            return;
        }
        File selectedFile = this.workspace.getWorkspaceLocation();
        XulFileDialog fc = (XulFileDialog)this.document.createElement("filedialog");
        XulFileDialog.RETURN_CODE retVal = fc.showOpenDialog((Object)selectedFile);
        if (retVal == XulFileDialog.RETURN_CODE.OK) {
            selectedFile = (File)fc.getFile();
            try {
                String cubeName;
                String xml = FileUtils.readFileToString((File)selectedFile);
                String[] connAndAgg = this.serializationService.getConnectionAndAggListElements(xml);
                this.serializationService.deserializeConnection(this.connectionModel.getSchema(), connAndAgg[0], connAndAgg[1]);
                if (!this.connectionModel.getSelectedSchemaModel().schemaExists()) {
                    XulMessageBox msgBox = (XulMessageBox)this.document.createElement("messagebox");
                    msgBox.setMessage(this.connectionModel.getSelectedSchemaModel().getSchemaDoesNotExistErrorMessage());
                    msgBox.open();
                    return;
                }
                long checksum = this.connectionModel.getSelectedSchemaModel().recalculateSchemaChecksum();
                if (checksum != this.connectionModel.getSelectedSchemaModel().getSchemaChecksum()) {
                    XulMessageBox msgBox = (XulMessageBox)this.document.createElement("messagebox");
                    msgBox.setMessage(Messages.getString("MainController.WarningSchemaChanged", new Object[0]));
                    msgBox.open();
                }
                if (StringUtils.isEmpty((String)(cubeName = this.connectionModel.getCubeName()))) {
                    throw new IllegalArgumentException("Could not initialize workspace: cubeName is empty");
                }
                this.connectionController.apply();
                this.connectionModel.setCubeName(cubeName);
                this.connectionController.connect();
                if (!this.workspace.isApplicationUnlocked()) {
                    XulMessageBox msgBox = (XulMessageBox)this.document.createElement("messagebox");
                    msgBox.setMessage(Messages.getString("MainController.ErrorFailedToConnect", new Object[0]));
                    msgBox.open();
                    return;
                }
                this.serializationService.deserializeAggList(this.connectionModel.getSchema(), connAndAgg[2]);
                this.workspace.setWorkspaceUpToDate(true);
            }
            catch (AggDesignerException e) {
                XulMessageBox msgBox = (XulMessageBox)this.document.createElement("messagebox");
                msgBox.setMessage(e.getMessage());
                msgBox.open();
                e.printStackTrace();
            }
            catch (Exception e) {
                XulMessageBox msgBox = (XulMessageBox)this.document.createElement("messagebox");
                msgBox.setMessage(Messages.getString("MainController.OpenExceptionMessage", new Object[0]));
                msgBox.open();
                e.printStackTrace();
            }
        }
    }

    public boolean saveWorkspace(boolean saveAs) throws XulException {
        Schema schema = this.workspace.getSchema();
        if (!this.workspace.isApplicationUnlocked()) {
            XulMessageBox msgBox = (XulMessageBox)this.document.createElement("messagebox");
            msgBox.setMessage(Messages.getString("MainController.CannotSaveUntilConnected", new Object[0]));
            msgBox.open();
            return false;
        }
        File selectedFile = this.workspace.getWorkspaceLocation();
        if (saveAs || selectedFile == null) {
            XulFileDialog fc = (XulFileDialog)this.document.createElement("filedialog");
            XulFileDialog.RETURN_CODE retVal = fc.showSaveDialog();
            if (retVal == XulFileDialog.RETURN_CODE.OK) {
                selectedFile = (File)fc.getFile();
            } else {
                return false;
            }
        }
        try {
            PrintWriter pw = new PrintWriter(new FileWriter(selectedFile));
            pw.println(this.serializationService.serializeWorkspace(schema));
            pw.close();
            this.workspace.setWorkspaceLocation(selectedFile);
            this.workspace.setWorkspaceUpToDate(true);
            return true;
        }
        catch (Exception e) {
            XulMessageBox msgBox = (XulMessageBox)this.document.createElement("messagebox");
            msgBox.setMessage(Messages.getString("MainController.SaveExceptionMessage", new Object[0]));
            msgBox.open();
            e.printStackTrace();
            return false;
        }
    }

    public boolean promptIfSaveRequired() throws XulException {
        if (this.workspace.isApplicationUnlocked() && !this.workspace.getWorkspaceUpToDate()) {
            XulMessageBox msgBox = (XulMessageBox)this.document.createElement("messagebox");
            msgBox.setTitle(Messages.getString("MainController.SaveWorkspaceTitle", new Object[0]));
            msgBox.setMessage(Messages.getString("MainController.SaveWorkspaceMessage", new Object[0]));
            msgBox.setButtons((Object[])new String[]{Messages.getString("MainController.SaveButton", new Object[0]), Messages.getString("MainController.DoNotSaveButton", new Object[0]), Messages.getString("MainController.CancelButton", new Object[0])});
            int id = msgBox.open();
            if (id == 2) {
                return false;
            }
            if (id == 0) {
                return this.saveWorkspace(false);
            }
        }
        return true;
    }

    public void newWorkspace() throws Exception {
        if (!this.promptIfSaveRequired()) {
            return;
        }
        this.aggList.clearAggs();
        this.workspace.setApplicationUnlocked(false);
        this.connectionController.reset();
        this.document.invokeLater(new Runnable(){

            @Override
            public void run() {
                MainController.this.connectionController.showConnectionDialog();
            }
        });
    }

    public boolean onClose() throws XulException {
        return this.promptIfSaveRequired();
    }

    public void close() throws XulException {
        this.getXulDomContainer().close();
    }

    public void cut() {
        try {
            ((XulWindow)this.getXulDomContainer().getDocumentRoot().getRootElement()).cut();
            this.paste.setDisabled(false);
        }
        catch (XulException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    public void copy() {
        try {
            ((XulWindow)this.getXulDomContainer().getDocumentRoot().getRootElement()).copy();
            this.paste.setDisabled(false);
        }
        catch (XulException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    public void paste() {
        try {
            ((XulWindow)this.getXulDomContainer().getDocumentRoot().getRootElement()).paste();
            this.paste.setDisabled(false);
        }
        catch (XulException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    public void validation1Done() {
        XulDialog validationDialog1 = (XulDialog)this.document.getElementById("validationDialog1");
        validationDialog1.hide();
    }

    public void validation2Done() {
        XulDialog validationDialog2 = (XulDialog)this.document.getElementById("validationDialog2");
        validationDialog2.hide();
    }

    public void helpAboutOpen() {
        XulDialog helpAboutDialog = (XulDialog)this.document.getElementById("helpAboutDialog");
        helpAboutDialog.show();
    }

    public void helpAboutClose() {
        XulDialog helpAboutDialog = (XulDialog)this.document.getElementById("helpAboutDialog");
        helpAboutDialog.hide();
    }

    public void helpAboutLoad() {
        XulLabel helpAboutVersionLabel = (XulLabel)this.document.getElementById("aboutVersion");
        Properties versionProps = new Properties();
        try {
            InputStream is = ((Object)((Object)this)).getClass().getResourceAsStream("/version.properties");
            if (is == null) {
                logger.error((Object)"Failed to locate version.properties on classpath");
            } else {
                versionProps.load(is);
            }
        }
        catch (IOException e) {
            if (logger.isErrorEnabled()) {
                logger.error((Object)"an exception occurred", (Throwable)e);
            }
            return;
        }
        helpAboutVersionLabel.setValue(versionProps.getProperty("version"));
        XulLabel helpAboutCopyrightLabel = (XulLabel)this.document.getElementById("aboutCopyright");
        helpAboutCopyrightLabel.setValue(Messages.getString("about_copyright", "" + (new Date().getYear() + 1900)));
    }

    public void setWorkspace(Workspace workspace) {
        this.workspace = workspace;
    }

    public void showUserGuide() {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                try {
                    BrowserLauncher launcher = new BrowserLauncher(null);
                    launcher.openURLinBrowser(Messages.getString("MainController.UserGuideURL", new Object[0]));
                }
                catch (BrowserLaunchingInitializingException ex) {
                    logger.error((Object)"an exception occurred", (Throwable)ex);
                }
                catch (UnsupportedOperatingSystemException ex) {
                    logger.error((Object)"an exception occurred", (Throwable)ex);
                }
            }
        };
        new Thread(runnable).start();
    }

    public ConnectionModel getConnectionModel() {
        return this.connectionModel;
    }

    public void setConnectionModel(ConnectionModel connectionModel) {
        this.connectionModel = connectionModel;
    }

    static {
        logger = LogFactory.getLog(MainController.class);
    }
}

