/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.aggdes.ui.form.controller;

import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collections;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.aggdes.algorithm.Result;
import org.pentaho.aggdes.algorithm.util.ArgumentUtils;
import org.pentaho.aggdes.model.Aggregate;
import org.pentaho.aggdes.model.Attribute;
import org.pentaho.aggdes.model.Measure;
import org.pentaho.aggdes.output.OutputService;
import org.pentaho.aggdes.output.OutputValidationException;
import org.pentaho.aggdes.ui.AlgorithmRunner;
import org.pentaho.aggdes.ui.ext.AlgorithmUiExtension;
import org.pentaho.aggdes.ui.form.model.ConnectionModel;
import org.pentaho.aggdes.ui.model.AggList;
import org.pentaho.aggdes.ui.model.UIAggregate;
import org.pentaho.aggdes.ui.model.impl.UIAggregateImpl;
import org.pentaho.aggdes.ui.util.AggregateNamingService;
import org.pentaho.aggdes.ui.util.Messages;
import org.pentaho.ui.xul.XulException;
import org.pentaho.ui.xul.components.XulMessageBox;
import org.pentaho.ui.xul.containers.XulDialog;
import org.pentaho.ui.xul.impl.AbstractXulEventHandler;
import org.pentaho.ui.xul.stereotype.Controller;

@Controller
public class AlgorithmController
extends AbstractXulEventHandler {
    private static final Log logger = LogFactory.getLog(AlgorithmController.class);
    private AlgorithmRunner algorithmRunner;
    private OutputService outputService;
    private AlgorithmUiExtension algorithmUiExtension;
    private AggregateNamingService aggNamingService;
    private ConnectionModel connectionModel;
    private AggList aggList;
    private XulDialog dialog;

    public void setAlgorithmRunner(AlgorithmRunner algorithmRunner) {
        this.algorithmRunner = algorithmRunner;
    }

    public void setOutputService(OutputService outputService) {
        this.outputService = outputService;
    }

    public void setAlgorithmUiExtension(AlgorithmUiExtension algorithmUiExtension) {
        this.algorithmUiExtension = algorithmUiExtension;
    }

    public void setAggregateNamingService(AggregateNamingService aggNamingService) {
        this.aggNamingService = aggNamingService;
    }

    public void onLoad() throws XulException {
        if (this.algorithmUiExtension != null) {
            logger.info((Object)("Adding algorithm overlay: " + this.algorithmUiExtension));
            this.document.addOverlay(this.algorithmUiExtension.getOverlayPath());
            this.algorithmUiExtension.onLoad();
        }
    }

    public void openDialog() {
        this.dialog = (XulDialog)this.document.getElementById("algorithm_dialog");
        this.dialog.show();
    }

    public void closeDialog() {
        this.dialog.hide();
    }

    public void startAlgo() throws XulException {
        try {
            XulDialog dialog = (XulDialog)this.document.getElementById("progressDialog");
            PrintWriter pw = new PrintWriter(System.out);
            try {
                this.algorithmRunner.start(this.algorithmUiExtension.getAlgorithmParameters(), new AlgorithmRunner.Callback(){

                    @Override
                    public void algorithmDone() {
                        AlgorithmController.this.algoDone();
                    }
                });
            }
            finally {
                pw.flush();
            }
            dialog.show();
            Result result = this.algorithmRunner.getResult();
            logger.debug((Object)("result=" + result));
            if (result == null || result.getAggregates() == null || result.getAggregates().size() == 0) {
                XulMessageBox box = (XulMessageBox)this.document.createElement("messagebox");
                box.setTitle(Messages.getString("AlgorithmController.NoResultsTitle", new Object[0]));
                box.setMessage(Messages.getString("AlgorithmController.NoResultsMessage", new Object[0]));
                box.open();
                return;
            }
            ArrayList<UIAggregate> algorithmAggs = new ArrayList<UIAggregate>();
            for (Aggregate aggregate : result.getAggregates()) {
                UIAggregateImpl cagg = new UIAggregateImpl();
                cagg.setName(aggregate.getCandidateTableName());
                cagg.setAlgoAgg(true);
                cagg.setDescription(aggregate.getDescription());
                cagg.setEstimateRowCount(aggregate.estimateRowCount());
                cagg.setEstimateSpace(aggregate.estimateSpace());
                ArrayList<Attribute> list = new ArrayList<Attribute>(aggregate.getAttributes());
                cagg.setAttributes(list);
                ArrayList<Measure> measureList = new ArrayList<Measure>(aggregate.getMeasures());
                cagg.setMeasures(measureList);
                algorithmAggs.add(cagg);
            }
            Collections.reverse(algorithmAggs);
            this.aggNamingService.nameAggregates(algorithmAggs, this.getAggList(), this.connectionModel.getSchema());
            for (UIAggregate uIAggregate : algorithmAggs) {
                try {
                    uIAggregate.setOutput(this.outputService.generateDefaultOutput((Aggregate)uIAggregate));
                }
                catch (OutputValidationException e) {
                    System.err.println("Failed to create output, skipping UIAggregate");
                    e.printStackTrace();
                }
            }
            this.getAggList().addAggs(algorithmAggs);
            this.closeDialog();
        }
        catch (ArgumentUtils.ValidationException validationException) {
            logger.error((Object)"error", (Throwable)validationException);
            XulMessageBox box = (XulMessageBox)this.document.createElement("messagebox");
            box.setTitle(Messages.getString("AlgorithmController.ErrorTitle", new Object[0]));
            box.setMessage(Messages.getString("AlgorithmController.ValidationErrorMessage", validationException.getMessage()));
            box.open();
        }
        catch (Throwable throwable) {
            logger.error((Object)"error", throwable);
            XulMessageBox box = (XulMessageBox)this.document.createElement("messagebox");
            box.setTitle(Messages.getString("AlgorithmController.ErrorTitle", new Object[0]));
            box.setMessage(Messages.getString("AlgorithmController.GeneralErrorMessage", new Object[0]));
            box.open();
        }
    }

    public void stopAlgo() {
        logger.debug((Object)"enter stopAlgo");
        XulDialog dialog = (XulDialog)this.document.getElementById("progressDialog");
        dialog.hide();
        this.algorithmRunner.stop();
    }

    private void algoDone() {
        logger.debug((Object)"enter algoDone");
        XulDialog dialog = (XulDialog)this.document.getElementById("progressDialog");
        dialog.hide();
    }

    public AggList getAggList() {
        return this.aggList;
    }

    public void setAggList(AggList aggList) {
        this.aggList = aggList;
    }

    public ConnectionModel getConnectionModel() {
        return this.connectionModel;
    }

    public void setConnectionModel(ConnectionModel connectionModel) {
        this.connectionModel = connectionModel;
    }
}

