/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.aggdes.ui.form.controller;

import java.awt.Color;
import java.awt.Paint;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.plot.DatasetRenderingOrder;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.chart.renderer.xy.XYLineAndShapeRenderer;
import org.jfree.data.xy.DefaultIntervalXYDataset;
import org.jfree.data.xy.IntervalXYDataset;
import org.jfree.data.xy.XYDataset;
import org.jfree.data.xy.XYSeries;
import org.jfree.data.xy.XYSeriesCollection;
import org.pentaho.aggdes.algorithm.Algorithm;
import org.pentaho.aggdes.algorithm.util.ArgumentUtils;
import org.pentaho.aggdes.model.Aggregate;
import org.pentaho.aggdes.model.Component;
import org.pentaho.aggdes.output.OutputService;
import org.pentaho.aggdes.output.OutputValidationException;
import org.pentaho.aggdes.ui.Workspace;
import org.pentaho.aggdes.ui.ext.AlgorithmUiExtension;
import org.pentaho.aggdes.ui.form.model.AggModel;
import org.pentaho.aggdes.ui.form.model.AggregateSummaryModel;
import org.pentaho.aggdes.ui.form.model.ConnectionModel;
import org.pentaho.aggdes.ui.model.AggList;
import org.pentaho.aggdes.ui.model.AggListEvent;
import org.pentaho.aggdes.ui.model.AggListListener;
import org.pentaho.aggdes.ui.model.UIAggregate;
import org.pentaho.aggdes.ui.model.impl.UIAggregateImpl;
import org.pentaho.aggdes.ui.util.AggregateNamingService;
import org.pentaho.aggdes.ui.util.Messages;
import org.pentaho.ui.xul.XulException;
import org.pentaho.ui.xul.binding.Binding;
import org.pentaho.ui.xul.binding.BindingConvertor;
import org.pentaho.ui.xul.binding.BindingFactory;
import org.pentaho.ui.xul.components.XulImage;
import org.pentaho.ui.xul.components.XulTreeCell;
import org.pentaho.ui.xul.containers.XulTree;
import org.pentaho.ui.xul.containers.XulTreeRow;
import org.pentaho.ui.xul.impl.AbstractXulEventHandler;
import org.pentaho.ui.xul.stereotype.Controller;
import org.springframework.beans.factory.annotation.Autowired;

@Controller
public class AggListController
extends AbstractXulEventHandler {
    private final DecimalFormat format = new DecimalFormat("#0");
    private static final Log logger = LogFactory.getLog(AggListController.class);
    @Deprecated
    private XulTree aggLevelTable;
    @Deprecated
    private XulTree aggTable;
    private OutputService outputService;
    private AggModel aggModel;
    private AggregateNamingService aggNamingService;
    private AggregateSummaryModel aggregateSummaryModel;
    private Algorithm algorithm;
    private AlgorithmUiExtension algorithmUiExtension;
    private AggList aggList;
    private Workspace workspace;
    private ConnectionModel connectionModel;
    private BindingFactory bindingFactory;

    @Autowired
    public void setBindingFactory(BindingFactory bindingFactory) {
        this.bindingFactory = bindingFactory;
    }

    public AggList getAggList() {
        return this.aggList;
    }

    public void setAggList(AggList aggList) {
        this.aggList = aggList;
    }

    public void setAggModel(AggModel aggModel) {
        this.aggModel = aggModel;
    }

    public void setWorkspace(Workspace workspace) {
        this.workspace = workspace;
    }

    public void setOutputService(OutputService outputService) {
        this.outputService = outputService;
    }

    public void setAggregateNamingService(AggregateNamingService aggNamingService) {
        this.aggNamingService = aggNamingService;
    }

    public void setAggregateSummaryModel(AggregateSummaryModel aggregateSummaryModel) {
        this.aggregateSummaryModel = aggregateSummaryModel;
    }

    public void setAlgorithm(Algorithm algorithm) {
        this.algorithm = algorithm;
    }

    public void setAlgorithmUiExtension(AlgorithmUiExtension algorithmUiExtension) {
        this.algorithmUiExtension = algorithmUiExtension;
    }

    public void changeInAggregates() {
        this.workspace.setWorkspaceUpToDate(false);
        if (this.getConnectionModel().getSchema() != null) {
            this.getConnectionModel().setSchemaUpToDate(false);
        }
        int totalAggregatesSelected = 0;
        double totalRows = 0.0;
        double totalSpace = 0.0;
        double totalLoadTime = 0.0;
        this.firePropertyChange("aggList", null, this.aggList);
        ArrayList<Aggregate> algoAggregates = new ArrayList<Aggregate>();
        for (UIAggregate aggregate : this.getAggList()) {
            if (!aggregate.getEnabled()) continue;
            ++totalAggregatesSelected;
            totalRows += aggregate.estimateRowCount();
            totalSpace += aggregate.estimateSpace();
            algoAggregates.add(this.algorithm.createAggregate(this.connectionModel.getSchema(), aggregate.getAttributes()));
        }
        double[] xs = new double[algoAggregates.size()];
        double[] startx = new double[algoAggregates.size()];
        double[] endx = new double[algoAggregates.size()];
        double[] ys = new double[algoAggregates.size()];
        double[] starty = new double[algoAggregates.size()];
        double[] endy = new double[algoAggregates.size()];
        XYSeries series1 = new XYSeries((Comparable)((Object)"CostBenefit"));
        XYSeriesCollection dataset = new XYSeriesCollection();
        dataset.addSeries(series1);
        DefaultIntervalXYDataset datasetxy = new DefaultIntervalXYDataset();
        if (this.connectionModel.getSchema() != null) {
            Map algorithmParams = ArgumentUtils.validateParameters((Component)this.algorithm, this.algorithmUiExtension.getAlgorithmParameters());
            List costBenefit = this.algorithm.computeAggregateCosts(this.connectionModel.getSchema(), algorithmParams, algoAggregates);
            double totalbenefit = 0.0;
            double x = 0.0;
            int count = 0;
            for (Algorithm.CostBenefit cb : costBenefit) {
                Aggregate agg = (Aggregate)algoAggregates.get(count);
                double estimateSpace = agg.estimateSpace();
                double hx = estimateSpace / 2.0;
                totalLoadTime += cb.getLoadTime();
                series1.add(x + hx, totalbenefit += cb.getSavedQueryRowCount());
                xs[count] = x + hx;
                startx[count] = x;
                endx[count] = x += estimateSpace;
                ys[count] = totalbenefit;
                starty[count] = 0.0;
                endy[count] = 0.0;
                ++count;
            }
            this.aggregateSummaryModel.setSelectedAggregateCount(this.format.format(totalAggregatesSelected));
            this.aggregateSummaryModel.setSelectedAggregateRows(this.format.format(totalRows));
            this.aggregateSummaryModel.setSelectedAggregateSpace(this.format.format(totalSpace) + " bytes");
            this.aggregateSummaryModel.setSelectedAggregateLoadTime(this.format.format(totalLoadTime));
        } else {
            this.aggregateSummaryModel.setSelectedAggregateCount("");
            this.aggregateSummaryModel.setSelectedAggregateRows("");
            this.aggregateSummaryModel.setSelectedAggregateSpace("");
            this.aggregateSummaryModel.setSelectedAggregateLoadTime("");
        }
        double[][] data = new double[][]{xs, startx, endx, ys, starty, endy};
        datasetxy.addSeries((Comparable)((Object)""), (double[][])data);
        JFreeChart chart = ChartFactory.createXYBarChart((String)"", (String)"Cost", (boolean)false, (String)"Benefit", (IntervalXYDataset)datasetxy, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)false, (boolean)false, (boolean)false);
        ((XYPlot)chart.getPlot()).getDomainAxis().setTickLabelsVisible(false);
        ((XYPlot)chart.getPlot()).getRangeAxis().setTickLabelsVisible(false);
        ((XYPlot)chart.getPlot()).setDataset(1, (XYDataset)dataset);
        XYLineAndShapeRenderer renderer = new XYLineAndShapeRenderer();
        chart.setBackgroundPaint((Paint)new Color(Integer.parseInt(Messages.getString("chart_background_color", new Object[0]).toUpperCase(), 16)));
        renderer.setSeriesPaint(0, (Paint)new Color(Integer.parseInt(Messages.getString("chart_line_color", new Object[0]).toUpperCase(), 16)));
        ((XYPlot)chart.getPlot()).getRenderer(0).setSeriesPaint(0, (Paint)new Color(Integer.parseInt(Messages.getString("chart_bar_color", new Object[0]).toUpperCase(), 16)));
        ((XYPlot)chart.getPlot()).setRenderer(1, (XYItemRenderer)renderer);
        ((XYPlot)chart.getPlot()).setDatasetRenderingOrder(DatasetRenderingOrder.FORWARD);
        XulImage image = (XulImage)this.document.getElementById("chart");
        image.setSrc((Object)chart.createBufferedImage(309, 168));
    }

    public void onLoad() {
        this.bindingFactory.setDocument(this.document);
        this.bindingFactory.setBindingType(Binding.Type.BI_DIRECTIONAL);
        this.bindingFactory.createBinding((Object)this.aggregateSummaryModel, "selectedAggregateCount", "num_aggs", "value", new BindingConvertor[0]);
        this.bindingFactory.createBinding((Object)this.aggregateSummaryModel, "selectedAggregateRows", "num_rows", "value", new BindingConvertor[0]);
        this.bindingFactory.createBinding((Object)this.aggregateSummaryModel, "selectedAggregateSpace", "disk_space", "value", new BindingConvertor[0]);
        BindingConvertor convertor = new BindingConvertor<AggList, Boolean>(){

            public Boolean sourceToTarget(AggList list) {
                return list.getSize() <= 0;
            }

            public AggList targetToSource(Boolean value) {
                return null;
            }
        };
        this.bindingFactory.setBindingType(Binding.Type.ONE_WAY);
        this.bindingFactory.createBinding((Object)this, "aggList", "agg_checkall", "disabled", new BindingConvertor[]{convertor});
        this.bindingFactory.createBinding((Object)this, "aggList", "agg_uncheckall", "disabled", new BindingConvertor[]{convertor});
        convertor = new BindingConvertor<AggList, Boolean>(){

            public Boolean sourceToTarget(AggList list) {
                return list.getSize() > 0;
            }

            public AggList targetToSource(Boolean value) {
                return null;
            }
        };
        this.bindingFactory.createBinding((Object)this, "aggList", (Object)this.connectionModel, "schemaLocked", new BindingConvertor[]{convertor});
        this.aggLevelTable = (XulTree)this.document.getElementById("dimtable");
        this.aggTable = (XulTree)this.document.getElementById("definedAggTable");
        AggListListener aggListListener = new AggListListener(){

            @Override
            public void listChanged(AggListEvent e) {
                String ESTIMATE_UNKNOWN = "unknown";
                AggList list = (AggList)e.getSource();
                switch (e.getType()) {
                    case AGGS_ADDED: {
                        try {
                            for (int i = e.getIndex(); i < list.getSize(); ++i) {
                                UIAggregate newAgg = list.getAgg(i);
                                XulTreeRow newRow = (XulTreeRow)AggListController.this.document.createElement("treerow");
                                XulTreeCell newCell = (XulTreeCell)AggListController.this.document.createElement("treecell");
                                newCell.setValue((Object)newAgg.getEnabled());
                                newRow.addCell(newCell);
                                newCell = (XulTreeCell)AggListController.this.document.createElement("treecell");
                                newCell.setLabel(newAgg.isAlgoAgg() ? Messages.getString("agg_type_advisor", new Object[0]) : Messages.getString("agg_type_custom", new Object[0]));
                                newRow.addCell(newCell);
                                newCell = (XulTreeCell)AggListController.this.document.createElement("treecell");
                                newCell.setLabel(newAgg.getName());
                                newRow.addCell(newCell);
                                newCell = (XulTreeCell)AggListController.this.document.createElement("treecell");
                                double rowCount = newAgg.estimateRowCount();
                                if (rowCount == 0.0) {
                                    newCell.setLabel("unknown");
                                } else {
                                    newCell.setLabel(AggListController.this.format.format(rowCount));
                                }
                                newRow.addCell(newCell);
                                newCell = (XulTreeCell)AggListController.this.document.createElement("treecell");
                                double space = newAgg.estimateSpace();
                                if (space == 0.0) {
                                    newCell.setLabel("unknown");
                                } else {
                                    newCell.setLabel(AggListController.this.format.format(space));
                                }
                                newRow.addCell(newCell);
                                AggListController.this.aggTable.addTreeRow(newRow);
                            }
                            AggListController.this.changeInAggregates();
                        }
                        catch (XulException xe) {
                            logger.error((Object)"Error adding new row to Agg table", (Throwable)xe);
                        }
                        break;
                    }
                    case AGG_ADDED: {
                        try {
                            UIAggregate newAgg = list.getAgg(e.getIndex());
                            XulTreeRow newRow = (XulTreeRow)AggListController.this.document.createElement("treerow");
                            XulTreeCell newCell = (XulTreeCell)AggListController.this.document.createElement("treecell");
                            newCell.setValue((Object)newAgg.getEnabled());
                            newRow.addCell(newCell);
                            newCell = (XulTreeCell)AggListController.this.document.createElement("treecell");
                            newCell.setLabel(newAgg.isAlgoAgg() ? Messages.getString("agg_type_advisor", new Object[0]) : Messages.getString("agg_type_custom", new Object[0]));
                            newRow.addCell(newCell);
                            newCell = (XulTreeCell)AggListController.this.document.createElement("treecell");
                            newCell.setLabel(newAgg.getName());
                            newRow.addCell(newCell);
                            newCell = (XulTreeCell)AggListController.this.document.createElement("treecell");
                            double rowCount = newAgg.estimateRowCount();
                            if (rowCount == 0.0) {
                                newCell.setLabel("unknown");
                            } else {
                                newCell.setLabel(AggListController.this.format.format(rowCount));
                            }
                            newRow.addCell(newCell);
                            newCell = (XulTreeCell)AggListController.this.document.createElement("treecell");
                            double space = newAgg.estimateSpace();
                            if (space == 0.0) {
                                newCell.setLabel("unknown");
                            } else {
                                newCell.setLabel(AggListController.this.format.format(space));
                            }
                            newRow.addCell(newCell);
                            AggListController.this.aggTable.addTreeRow(newRow);
                            AggListController.this.changeInAggregates();
                        }
                        catch (XulException xe) {
                            logger.error((Object)"Error adding new row to Agg table", (Throwable)xe);
                        }
                        break;
                    }
                    case AGGS_CLEARED: {
                        AggListController.this.aggTable.getRootChildren().removeAll();
                        AggListController.this.aggModel.setThinAgg(null);
                        AggListController.this.changeInAggregates();
                        break;
                    }
                    case AGG_REMOVED: {
                        AggListController.this.aggTable.removeTreeRows(new int[]{e.getIndex()});
                        AggListController.this.aggTable.clearSelection();
                        int[] tableSelection = AggListController.this.aggTable.getSelectedRows();
                        if (e.getIndex() < list.getSize()) {
                            list.setSelectedIndex(e.getIndex());
                        }
                        UIAggregate tempAgg = list.getSelectedValue();
                        AggListController.this.aggModel.setThinAgg(list.getSelectedValue());
                        AggListController.this.changeInAggregates();
                        break;
                    }
                    case SELECTION_CHANGED: {
                        if (AggListController.this.aggTable.getSelectedRows().length > 0) {
                            logger.info((Object)("Event index: " + e.getIndex() + " aggTable.selectedRow0: " + AggListController.this.aggTable.getSelectedRows()[0]));
                        }
                        int[] rows = AggListController.this.aggTable.getSelectedRows();
                        if (AggListController.this.aggTable.getSelectedRows().length > 0 && e.getIndex() == AggListController.this.aggTable.getSelectedRows()[0]) {
                            AggListController.this.aggModel.setThinAgg(list.getSelectedValue());
                        }
                        int[] curSelection = AggListController.this.aggTable.getSelectedRows();
                        logger.debug((Object)"selecting new row");
                        AggListController.this.aggTable.setSelectedRows(new int[]{e.getIndex()});
                        AggListController.this.aggModel.setThinAgg(list.getSelectedValue());
                        break;
                    }
                    case AGG_CHANGED: {
                        logger.debug((Object)"agg list controller responding to AGG_CHANGED event from aggList");
                        int idx = e.getIndex();
                        UIAggregate agg = list.getAgg(idx);
                        AggListController.this.aggTable.getRootChildren().getItem(idx).getRow().getCell(0).setValue((Object)agg.getEnabled());
                        AggListController.this.aggTable.getRootChildren().getItem(idx).getRow().getCell(1).setLabel(agg.isAlgoAgg() ? Messages.getString("agg_type_advisor", new Object[0]) : Messages.getString("agg_type_custom", new Object[0]));
                        AggListController.this.aggTable.getRootChildren().getItem(idx).getRow().getCell(2).setLabel(agg.getName());
                        double rowCount = agg.estimateRowCount();
                        if (rowCount == 0.0) {
                            AggListController.this.aggTable.getRootChildren().getItem(idx).getRow().getCell(3).setLabel("unknown");
                        } else {
                            AggListController.this.aggTable.getRootChildren().getItem(idx).getRow().getCell(3).setLabel(AggListController.this.format.format(rowCount));
                        }
                        double space = agg.estimateSpace();
                        if (space == 0.0) {
                            AggListController.this.aggTable.getRootChildren().getItem(idx).getRow().getCell(4).setLabel("unknown");
                        } else {
                            AggListController.this.aggTable.getRootChildren().getItem(idx).getRow().getCell(4).setLabel(AggListController.this.format.format(space));
                        }
                        AggListController.this.document.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                AggListController.this.aggTable.update();
                            }
                        });
                        AggListController.this.changeInAggregates();
                    }
                }
            }
        };
        this.getAggList().addAggListListener(aggListListener);
        this.changeInAggregates();
    }

    public void addAgg() {
        try {
            UIAggregateImpl newAgg = new UIAggregateImpl();
            this.aggNamingService.nameAggregate(newAgg, this.getAggList(), this.connectionModel.getSchema());
            newAgg.setOutput(this.outputService.generateDefaultOutput((Aggregate)newAgg));
            this.getAggList().addAgg(newAgg);
            this.getAggList().setSelectedIndex(this.getAggList().getSize() - 1);
        }
        catch (OutputValidationException e) {
            System.err.println("Failed to create output, skipping UIAggregate");
            e.printStackTrace();
        }
    }

    public void showAgg(int idx) {
        this.aggLevelTable.clearSelection();
        UIAggregate agg = this.getAggList().getAgg(idx);
        if (agg == null) {
            logger.info((Object)String.format("List and Table out of sync, %s does not exist", idx));
        } else {
            this.getAggList().setSelectedIndex(idx);
        }
    }

    public void saveAggChange(int idx) {
        UIAggregate agg = this.getAggList().getAgg(idx);
        XulTree aggTable = (XulTree)this.document.getElementById("definedAggTable");
        XulTreeRow row = aggTable.getRootChildren().getItem(idx).getRow();
        agg.setEnabled((Boolean)row.getCell(0).getValue());
        Aggregate algoAggregate = this.algorithm.createAggregate(this.connectionModel.getSchema(), agg.getAttributes());
        agg.setEstimateRowCount(algoAggregate.estimateRowCount());
        agg.setEstimateSpace(algoAggregate.estimateSpace());
        this.getAggList().aggChanged(agg);
        System.out.println("Saving agg, enabled? " + row.getCell(0).getValue());
    }

    public void displayNewOrExistingAgg() {
        if (this.getAggList().getSize() == 0) {
            this.addAgg();
        } else if (this.getAggList().getSelectedIndex() == -1) {
            this.showAgg(0);
        } else {
            this.showAgg(this.getAggList().getSelectedIndex());
        }
    }

    public void removeAgg() {
        int[] selectedIndexes;
        if (this.aggTable == null) {
            return;
        }
        for (int pos : selectedIndexes = this.aggTable.getSelectedRows()) {
            this.aggModel.reset();
            this.getAggList().removeAgg(pos);
        }
    }

    public void moveAggUp() {
        this.getAggList().moveAggUp(this.getAggList().getSelectedValue());
    }

    public void moveAggDown() {
        this.getAggList().moveAggDown(this.getAggList().getSelectedValue());
    }

    public void checkAll() {
        this.getAggList().checkAll();
    }

    public void uncheckAll() {
        this.getAggList().uncheckAll();
    }

    public ConnectionModel getConnectionModel() {
        return this.connectionModel;
    }

    public void setConnectionModel(ConnectionModel connectionModel) {
        this.connectionModel = connectionModel;
    }
}

