/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.aggdes.ui;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.aggdes.model.Schema;
import org.pentaho.aggdes.ui.util.Messages;
import org.pentaho.ui.xul.XulEventSourceAdapter;

public class Workspace
extends XulEventSourceAdapter {
    private static final Log logger = LogFactory.getLog(Workspace.class);
    private static final String CONFIG_DIR = System.getProperty("user.home") + File.separator + ".aggdesigner";
    private static final String CONFIG_FILE = CONFIG_DIR + File.separator + "aggdesigner.properties";
    private Properties workspaceProperties;
    private File workspaceLocation;
    private Schema schema;
    private boolean workspaceUpToDate = true;
    private boolean applicationUnlocked = false;
    private boolean saveEnabled = false;

    public Workspace() {
        this.loadWorkspaceProperties();
    }

    private void loadWorkspaceProperties() {
        this.workspaceProperties = new Properties();
        try {
            File f = new File(CONFIG_FILE);
            if (f.exists()) {
                FileInputStream in = new FileInputStream(f);
                this.workspaceProperties.load(in);
                in.close();
            } else {
                logger.debug((Object)(CONFIG_FILE + " does not exist."));
            }
        }
        catch (Exception e) {
            logger.error((Object)Messages.getString("Workspace.ERROR_0001_LOAD_PROPS_EXCEPTION", new Object[0]), (Throwable)e);
        }
    }

    public String getWorkspaceProperty(String key) {
        return this.workspaceProperties.getProperty(key);
    }

    public void setWorkspaceProperty(String key, String value) {
        this.workspaceProperties.setProperty(key, value);
    }

    public File getWorkspaceLocation() {
        return this.workspaceLocation;
    }

    public void setWorkspaceUpToDate(boolean workspaceUpToDate) {
        boolean oldVal = this.workspaceUpToDate;
        this.workspaceUpToDate = workspaceUpToDate;
        this.firePropertyChange("workspaceUpToDate", oldVal, workspaceUpToDate);
        this.setSaveEnabled(this.applicationUnlocked && !workspaceUpToDate);
    }

    public boolean getWorkspaceUpToDate() {
        return this.workspaceUpToDate;
    }

    public void setWorkspaceLocation(File workspaceLocation) {
        this.workspaceLocation = workspaceLocation;
    }

    public void setSchema(Schema schema) {
        this.schema = schema;
    }

    public Schema getSchema() {
        return this.schema;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void storeWorkspaceProperties() {
        File dir = new File(CONFIG_DIR);
        try {
            if (dir.exists()) {
                if (!dir.isDirectory()) {
                    logger.error((Object)Messages.getString("Workspace.ERROR_0002_CONFIG_NOT_DIR", CONFIG_DIR));
                    return;
                }
            } else {
                dir.mkdirs();
            }
        }
        catch (Exception ex) {
            logger.error((Object)Messages.getString("Workspace.ERROR_0003_STORE_PROPS_EXCEPTION", new Object[0]), (Throwable)ex);
            return;
        }
        OutputStream out = null;
        try {
            out = new FileOutputStream(new File(CONFIG_FILE));
            this.workspaceProperties.store(out, "aggdesigner configuration");
        }
        catch (Exception e) {
            logger.error((Object)Messages.getString("Workspace.ERROR_0002_STORE_PROPS_EXCEPTION", new Object[0]), (Throwable)e);
        }
        finally {
            try {
                out.close();
            }
            catch (IOException eIO) {
                logger.error((Object)Messages.getString("Workspace.ERROR_0002_STORE_PROPS_EXCEPTION", new Object[0]), (Throwable)eIO);
            }
        }
    }

    public boolean isApplicationUnlocked() {
        return this.applicationUnlocked;
    }

    public void setApplicationUnlocked(boolean applicationUnlocked) {
        boolean prevVal = this.applicationUnlocked;
        this.applicationUnlocked = applicationUnlocked;
        this.firePropertyChange("applicationUnlocked", prevVal, applicationUnlocked);
        this.setSaveEnabled(applicationUnlocked && !this.workspaceUpToDate);
    }

    public boolean isSaveEnabled() {
        return this.saveEnabled;
    }

    public void setSaveEnabled(boolean enabled) {
        boolean oldVal = this.saveEnabled;
        this.saveEnabled = enabled;
        this.firePropertyChange("saveEnabled", oldVal, this.saveEnabled);
    }
}

