/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.core.search;

import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.SearchParticipant;
import org.eclipse.jdt.core.search.SearchPattern;
import org.eclipse.jdt.internal.core.JavaModelManager;
import org.eclipse.jdt.internal.core.index.IIndex;
import org.eclipse.jdt.internal.core.index.impl.BlocksIndexInput;
import org.eclipse.jdt.internal.core.index.impl.IndexInput;
import org.eclipse.jdt.internal.core.search.IndexQueryRequestor;
import org.eclipse.jdt.internal.core.search.PatternSearchJob;
import org.eclipse.jdt.internal.core.search.indexing.IndexManager;
import org.eclipse.jdt.internal.core.search.indexing.ReadWriteMonitor;

public class SubTypeSearchJob
extends PatternSearchJob {
    Map inputs = new HashMap(5);

    public SubTypeSearchJob(SearchPattern pattern, SearchParticipant participant, IJavaSearchScope scope, IndexQueryRequestor requestor) {
        super(pattern, participant, scope, requestor);
    }

    public void closeAll() {
        Iterator openedInputs = this.inputs.values().iterator();
        while (openedInputs.hasNext()) {
            IndexInput input = (IndexInput)openedInputs.next();
            try {
                input.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean search(IIndex index, IProgressMonitor progressMonitor) {
        if (progressMonitor != null && progressMonitor.isCanceled()) {
            throw new OperationCanceledException();
        }
        if (index == null) {
            return true;
        }
        IndexManager indexManager = JavaModelManager.getJavaModelManager().getIndexManager();
        ReadWriteMonitor monitor = indexManager.getMonitorFor(index);
        if (monitor == null) {
            return true;
        }
        try {
            try {
                block13: {
                    monitor.enterRead();
                    if (!index.hasChanged()) break block13;
                    try {
                        try {
                            monitor.exitRead();
                            monitor.enterWrite();
                            indexManager.saveIndex(index);
                        }
                        catch (IOException e) {
                            Object var6_8 = null;
                            monitor.exitWriteEnterRead();
                            Object var8_11 = null;
                            monitor.exitRead();
                            return false;
                        }
                    }
                    catch (Throwable throwable) {
                        Object var6_9 = null;
                        monitor.exitWriteEnterRead();
                        throw throwable;
                    }
                    {
                        Object var6_10 = null;
                        monitor.exitWriteEnterRead();
                    }
                }
                long start = System.currentTimeMillis();
                IndexInput input = (IndexInput)this.inputs.get(index);
                if (input == null) {
                    input = new BlocksIndexInput(index.getIndexFile());
                    input.open();
                    this.inputs.put(index, input);
                }
                this.pattern.findIndexMatches(input, this.requestor, this.participant, this.scope, progressMonitor);
                this.executionTime += System.currentTimeMillis() - start;
                Object var8_12 = null;
                monitor.exitRead();
                return true;
            }
            catch (IOException e) {
                Object var8_13 = null;
                monitor.exitRead();
                return false;
            }
        }
        catch (Throwable throwable) {
            Object var8_14 = null;
            monitor.exitRead();
            throw throwable;
        }
    }
}

