/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.codeassist.impl;

import java.util.Map;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.internal.codeassist.ISearchableNameEnvironment;
import org.eclipse.jdt.internal.codeassist.impl.AssistOptions;
import org.eclipse.jdt.internal.codeassist.impl.AssistParser;
import org.eclipse.jdt.internal.compiler.CompilationResult;
import org.eclipse.jdt.internal.compiler.ast.ASTNode;
import org.eclipse.jdt.internal.compiler.ast.AbstractMethodDeclaration;
import org.eclipse.jdt.internal.compiler.ast.CompilationUnitDeclaration;
import org.eclipse.jdt.internal.compiler.ast.FieldDeclaration;
import org.eclipse.jdt.internal.compiler.ast.Initializer;
import org.eclipse.jdt.internal.compiler.ast.TypeDeclaration;
import org.eclipse.jdt.internal.compiler.env.IBinaryType;
import org.eclipse.jdt.internal.compiler.env.ICompilationUnit;
import org.eclipse.jdt.internal.compiler.env.ISourceType;
import org.eclipse.jdt.internal.compiler.impl.CompilerOptions;
import org.eclipse.jdt.internal.compiler.impl.ITypeRequestor;
import org.eclipse.jdt.internal.compiler.lookup.CompilationUnitScope;
import org.eclipse.jdt.internal.compiler.lookup.ImportBinding;
import org.eclipse.jdt.internal.compiler.lookup.LookupEnvironment;
import org.eclipse.jdt.internal.compiler.lookup.PackageBinding;
import org.eclipse.jdt.internal.compiler.parser.SourceTypeConverter;

public abstract class Engine
implements ITypeRequestor {
    public LookupEnvironment lookupEnvironment;
    protected CompilationUnitScope unitScope;
    protected ISearchableNameEnvironment nameEnvironment;
    public AssistOptions options;
    public CompilerOptions compilerOptions;

    public Engine(Map settings) {
        this.options = new AssistOptions(settings);
        this.compilerOptions = new CompilerOptions(settings);
    }

    public void accept(IBinaryType binaryType, PackageBinding packageBinding) {
        this.lookupEnvironment.createBinaryTypeFrom(binaryType, packageBinding);
    }

    public void accept(ICompilationUnit sourceUnit) {
        CompilationResult result = new CompilationResult(sourceUnit, 1, 1, this.compilerOptions.maxProblemsPerUnit);
        CompilationUnitDeclaration parsedUnit = this.getParser().dietParse(sourceUnit, result);
        this.lookupEnvironment.buildTypeBindings(parsedUnit);
        this.lookupEnvironment.completeTypeBindings(parsedUnit, true);
    }

    public void accept(ISourceType[] sourceTypes, PackageBinding packageBinding) {
        CompilationResult result = new CompilationResult(sourceTypes[0].getFileName(), 1, 1, this.compilerOptions.maxProblemsPerUnit);
        CompilationUnitDeclaration unit = SourceTypeConverter.buildCompilationUnit(sourceTypes, 15, this.lookupEnvironment.problemReporter, result);
        if (unit != null) {
            this.lookupEnvironment.buildTypeBindings(unit);
            this.lookupEnvironment.completeTypeBindings(unit, true);
        }
    }

    public abstract AssistParser getParser();

    protected boolean mustQualifyType(char[] packageName, char[] typeName) {
        if (this.unitScope == null) {
            return true;
        }
        char[][] compoundPackageName = CharOperation.splitOn('.', packageName);
        char[] readableTypeName = CharOperation.concat(packageName, typeName, '.');
        if (CharOperation.equals(this.unitScope.fPackage.compoundName, compoundPackageName)) {
            return false;
        }
        ImportBinding[] imports = this.unitScope.imports;
        if (imports != null) {
            int i = 0;
            int length = imports.length;
            while (i < length) {
                if (imports[i].onDemand) {
                    if (CharOperation.equals(imports[i].compoundName, compoundPackageName)) {
                        int j = 0;
                        while (j < imports.length) {
                            if (i != j && (imports[j].onDemand ? this.nameEnvironment.findType(typeName, imports[j].compoundName) != null : CharOperation.equals(CharOperation.lastSegment(imports[j].readableName(), '.'), typeName) && !CharOperation.equals(imports[j].compoundName, CharOperation.splitOn('.', readableTypeName)))) {
                                return true;
                            }
                            ++j;
                        }
                        return false;
                    }
                } else if (CharOperation.equals(imports[i].readableName(), readableTypeName)) {
                    return false;
                }
                ++i;
            }
        }
        return true;
    }

    protected ASTNode parseBlockStatements(CompilationUnitDeclaration unit, int position) {
        int length = unit.types.length;
        int i = 0;
        while (i < length) {
            TypeDeclaration type = unit.types[i];
            if (type.declarationSourceStart < position && type.declarationSourceEnd >= position) {
                this.getParser().scanner.setSource(unit.compilationResult.compilationUnit.getContents());
                return this.parseBlockStatements(type, unit, position);
            }
            ++i;
        }
        return null;
    }

    private ASTNode parseBlockStatements(TypeDeclaration type, CompilationUnitDeclaration unit, int position) {
        FieldDeclaration[] fields;
        AbstractMethodDeclaration[] methods;
        TypeDeclaration[] memberTypes = type.memberTypes;
        if (memberTypes != null) {
            int length = memberTypes.length;
            int i = 0;
            while (i < length) {
                TypeDeclaration memberType = memberTypes[i];
                if (memberType.bodyStart <= position && memberType.declarationSourceEnd >= position) {
                    return this.parseBlockStatements(memberType, unit, position);
                }
                ++i;
            }
        }
        if ((methods = type.methods) != null) {
            int length = methods.length;
            int i = 0;
            while (i < length) {
                AbstractMethodDeclaration method = methods[i];
                if (method.bodyStart <= position && method.declarationSourceEnd >= position) {
                    this.getParser().parseBlockStatements(method, unit);
                    return method;
                }
                ++i;
            }
        }
        if ((fields = type.fields) != null) {
            int length = fields.length;
            int i = 0;
            while (i < length) {
                FieldDeclaration field = fields[i];
                if (field.sourceStart <= position && field.declarationSourceEnd >= position) {
                    if (field instanceof Initializer) {
                        this.getParser().parseBlockStatements((Initializer)field, type, unit);
                    }
                    return field;
                }
                ++i;
            }
        }
        return null;
    }

    protected void reset() {
        this.lookupEnvironment.reset();
    }
}

