/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.core.search;

import java.util.HashMap;
import java.util.HashSet;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.IWorkingCopy;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.WorkingCopyOwner;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.core.search.IJavaSearchResultCollector;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.ISearchPattern;
import org.eclipse.jdt.core.search.ITypeNameRequestor;
import org.eclipse.jdt.core.search.SearchDocument;
import org.eclipse.jdt.core.search.SearchMatch;
import org.eclipse.jdt.core.search.SearchParticipant;
import org.eclipse.jdt.core.search.SearchPattern;
import org.eclipse.jdt.core.search.SearchRequestor;
import org.eclipse.jdt.internal.compiler.DefaultErrorHandlingPolicies;
import org.eclipse.jdt.internal.compiler.impl.CompilerOptions;
import org.eclipse.jdt.internal.compiler.parser.Parser;
import org.eclipse.jdt.internal.compiler.problem.DefaultProblemFactory;
import org.eclipse.jdt.internal.compiler.problem.ProblemReporter;
import org.eclipse.jdt.internal.core.CompilationUnit;
import org.eclipse.jdt.internal.core.DefaultWorkingCopyOwner;
import org.eclipse.jdt.internal.core.JavaModelManager;
import org.eclipse.jdt.internal.core.search.HierarchyScope;
import org.eclipse.jdt.internal.core.search.JavaSearchDocument;
import org.eclipse.jdt.internal.core.search.JavaSearchParticipant;
import org.eclipse.jdt.internal.core.search.JavaSearchScope;
import org.eclipse.jdt.internal.core.search.JavaWorkspaceScope;
import org.eclipse.jdt.internal.core.search.matching.AndPattern;
import org.eclipse.jdt.internal.core.search.matching.DeclarationOfAccessedFieldsPattern;
import org.eclipse.jdt.internal.core.search.matching.DeclarationOfReferencedMethodsPattern;
import org.eclipse.jdt.internal.core.search.matching.DeclarationOfReferencedTypesPattern;
import org.eclipse.jdt.internal.core.search.matching.JavaSearchMatch;
import org.eclipse.jdt.internal.core.search.matching.OrPattern;

public class SearchEngine {
    private Parser parser;
    private CompilerOptions compilerOptions;
    private ICompilationUnit[] workingCopies;
    private WorkingCopyOwner workingCopyOwner;
    public static boolean VERBOSE = false;

    public SearchEngine() {
    }

    public SearchEngine(ICompilationUnit[] workingCopies) {
        this.workingCopies = workingCopies;
    }

    public SearchEngine(IWorkingCopy[] workingCopies) {
        int length = workingCopies.length;
        this.workingCopies = new ICompilationUnit[length];
        System.arraycopy(workingCopies, 0, this.workingCopies, 0, length);
    }

    public SearchEngine(WorkingCopyOwner workingCopyOwner) {
        this.workingCopyOwner = workingCopyOwner;
    }

    public static IJavaSearchScope createHierarchyScope(IType type) throws JavaModelException {
        return SearchEngine.createHierarchyScope(type, DefaultWorkingCopyOwner.PRIMARY);
    }

    public static IJavaSearchScope createHierarchyScope(IType type, WorkingCopyOwner owner) throws JavaModelException {
        return new HierarchyScope(type, owner);
    }

    public static IJavaSearchScope createJavaSearchScope(IResource[] resources) {
        int length = resources.length;
        IJavaElement[] elements = new IJavaElement[length];
        int i = 0;
        while (i < length) {
            elements[i] = JavaCore.create(resources[i]);
            ++i;
        }
        return SearchEngine.createJavaSearchScope(elements);
    }

    public static IJavaSearchScope createJavaSearchScope(IJavaElement[] elements) {
        return SearchEngine.createJavaSearchScope(elements, true);
    }

    public static IJavaSearchScope createJavaSearchScope(IJavaElement[] elements, boolean includeReferencedProjects) {
        JavaSearchScope scope = new JavaSearchScope();
        HashSet visitedProjects = new HashSet(2);
        int i = 0;
        int length = elements.length;
        while (i < length) {
            IJavaElement element = elements[i];
            if (element != null) {
                try {
                    if (element instanceof IJavaProject) {
                        scope.add((IJavaProject)element, includeReferencedProjects, visitedProjects);
                    } else {
                        scope.add(element);
                    }
                }
                catch (JavaModelException javaModelException) {
                    // empty catch block
                }
            }
            ++i;
        }
        return scope;
    }

    public static SearchPattern createAndSearchPattern(final SearchPattern leftPattern, final SearchPattern rightPattern) {
        return new AndPattern(0, 0){
            SearchPattern current;
            {
                this.current = searchPattern;
            }

            public void decodeIndexKey(char[] key) {
                this.current.decodeIndexKey(key);
            }

            public char[] encodeIndexKey() {
                return this.current.encodeIndexKey();
            }

            public SearchPattern getIndexRecord() {
                return this.current.getIndexRecord();
            }

            public char[][] getMatchCategories() {
                return this.current.getMatchCategories();
            }

            public int getMatchRule() {
                return this.current.getMatchRule();
            }

            protected boolean hasNextQuery() {
                if (this.current == leftPattern) {
                    this.current = rightPattern;
                    return true;
                }
                return false;
            }

            public boolean isMatchingIndexRecord() {
                return this.current.isMatchingIndexRecord();
            }

            protected void resetQuery() {
                this.current = leftPattern;
            }
        };
    }

    public static ISearchPattern createOrSearchPattern(ISearchPattern leftPattern, ISearchPattern rightPattern) {
        return new OrPattern((SearchPattern)leftPattern, (SearchPattern)rightPattern);
    }

    public static ISearchPattern createSearchPattern(String stringPattern, int searchFor, int limitTo, boolean isCaseSensitive) {
        int matchMode = stringPattern.indexOf(42) != -1 || stringPattern.indexOf(63) != -1 ? 2 : 0;
        return SearchPattern.createPattern(stringPattern, searchFor, limitTo, matchMode, isCaseSensitive);
    }

    public static ISearchPattern createSearchPattern(IJavaElement element, int limitTo) {
        return SearchPattern.createPattern(element, limitTo);
    }

    public static IJavaSearchScope createWorkspaceScope() {
        return new JavaWorkspaceScope();
    }

    public static SearchParticipant getDefaultSearchParticipant() {
        return new JavaSearchParticipant(null);
    }

    public static SearchParticipant[] getSearchParticipants() {
        Plugin plugin = JavaCore.getPlugin();
        if (plugin == null) {
            return SearchParticipant.NO_PARTICIPANT;
        }
        IExtensionPoint extension = plugin.getDescriptor().getExtensionPoint("searchParticipant");
        if (extension != null) {
            IExtension[] extensions = extension.getExtensions();
            int length = extensions.length;
            SearchParticipant[] participants = new SearchParticipant[length + 1];
            participants[0] = SearchEngine.getDefaultSearchParticipant();
            int found = 1;
            int i = 0;
            while (i < extensions.length) {
                IConfigurationElement[] configElements = extensions[i].getConfigurationElements();
                int j = 0;
                int configLength = configElements.length;
                while (j < configLength) {
                    block9: {
                        try {
                            Object execExt = configElements[j].createExecutableExtension("class");
                            if (execExt != null && execExt instanceof SearchParticipant) {
                                participants[found++] = (SearchParticipant)execExt;
                            }
                        }
                        catch (CoreException e) {
                            if (!VERBOSE) break block9;
                            System.out.println("Search - failed to instanciate participant: " + configElements[j].getAttribute("class"));
                            e.printStackTrace();
                        }
                    }
                    ++j;
                }
                ++i;
            }
            if (found == 0) {
                return SearchParticipant.NO_PARTICIPANT;
            }
            if (found < length) {
                SearchParticipant[] searchParticipantArray = participants;
                participants = new SearchParticipant[found];
                System.arraycopy(searchParticipantArray, 0, participants, 0, found);
            }
            return participants;
        }
        return new SearchParticipant[]{SearchEngine.getDefaultSearchParticipant()};
    }

    private Parser getParser() {
        if (this.parser == null) {
            this.compilerOptions = new CompilerOptions(JavaCore.getOptions());
            ProblemReporter problemReporter = new ProblemReporter(DefaultErrorHandlingPolicies.proceedWithAllProblems(), this.compilerOptions, new DefaultProblemFactory());
            this.parser = new Parser(problemReporter, true);
        }
        return this.parser;
    }

    private IResource getResource(IJavaElement element) {
        ICompilationUnit cu;
        if (element instanceof IMember && (cu = ((IMember)element).getCompilationUnit()) != null) {
            return cu.getResource();
        }
        return element.getResource();
    }

    private ICompilationUnit[] getWorkingCopies() {
        int length;
        ICompilationUnit[] copies;
        if (this.workingCopies != null) {
            if (this.workingCopyOwner == null) {
                copies = JavaModelManager.getJavaModelManager().getWorkingCopies(DefaultWorkingCopyOwner.PRIMARY, false);
                if (copies == null) {
                    copies = this.workingCopies;
                } else {
                    ICompilationUnit unit;
                    HashMap<IPath, ICompilationUnit> pathToCUs = new HashMap<IPath, ICompilationUnit>();
                    int i = 0;
                    int length2 = copies.length;
                    while (i < length2) {
                        unit = copies[i];
                        pathToCUs.put(unit.getPath(), unit);
                        ++i;
                    }
                    i = 0;
                    length2 = this.workingCopies.length;
                    while (i < length2) {
                        unit = this.workingCopies[i];
                        pathToCUs.put(unit.getPath(), unit);
                        ++i;
                    }
                    length = pathToCUs.size();
                    copies = new ICompilationUnit[length];
                    pathToCUs.values().toArray(copies);
                }
            } else {
                copies = this.workingCopies;
            }
        } else {
            copies = this.workingCopyOwner != null ? JavaModelManager.getJavaModelManager().getWorkingCopies(this.workingCopyOwner, true) : JavaModelManager.getJavaModelManager().getWorkingCopies(DefaultWorkingCopyOwner.PRIMARY, false);
        }
        if (copies == null) {
            return null;
        }
        ICompilationUnit[] result = null;
        length = copies.length;
        int index = 0;
        int i = 0;
        while (i < length) {
            CompilationUnit copy = (CompilationUnit)copies[i];
            try {
                if (!copy.isPrimary() || copy.hasUnsavedChanges() || copy.hasResourceChanged()) {
                    if (result == null) {
                        result = new ICompilationUnit[length];
                    }
                    result[index++] = copy;
                }
            }
            catch (JavaModelException javaModelException) {
                // empty catch block
            }
            ++i;
        }
        if (index != length && result != null) {
            ICompilationUnit[] iCompilationUnitArray = result;
            result = new ICompilationUnit[index];
            System.arraycopy(iCompilationUnitArray, 0, result, 0, index);
        }
        return result;
    }

    private ICompilationUnit[] getWorkingCopies(IJavaElement element) {
        ICompilationUnit cu;
        if (element instanceof IMember && (cu = ((IMember)element).getCompilationUnit()) != null && cu.isWorkingCopy()) {
            int length;
            ICompilationUnit[] copies = this.getWorkingCopies();
            int n = length = copies == null ? 0 : copies.length;
            if (length > 0) {
                ICompilationUnit[] newWorkingCopies = new ICompilationUnit[length + 1];
                System.arraycopy(copies, 0, newWorkingCopies, 0, length);
                newWorkingCopies[length] = cu;
                return newWorkingCopies;
            }
            return new ICompilationUnit[]{cu};
        }
        return this.getWorkingCopies();
    }

    boolean match(char classOrInterface, char[] patternPkg, char[] patternTypeName, int matchMode, boolean isCaseSensitive, boolean isClass, char[] pkg, char[] typeName) {
        switch (classOrInterface) {
            case 'C': {
                if (!isClass) {
                    return false;
                }
            }
            case 'I': {
                if (!isClass) break;
                return false;
            }
        }
        if (patternPkg != null && !CharOperation.equals(patternPkg, pkg, isCaseSensitive)) {
            return false;
        }
        if (patternTypeName != null) {
            switch (matchMode) {
                case 0: {
                    return CharOperation.equals(patternTypeName, typeName, isCaseSensitive);
                }
                case 1: {
                    return CharOperation.prefixEquals(patternTypeName, typeName, isCaseSensitive);
                }
                case 2: {
                    return CharOperation.match(patternTypeName, typeName, isCaseSensitive);
                }
            }
        }
        return true;
    }

    public void search(IWorkspace workspace, String patternString, int searchFor, int limitTo, IJavaSearchScope scope, IJavaSearchResultCollector resultCollector) throws JavaModelException {
        this.search(workspace, SearchEngine.createSearchPattern(patternString, searchFor, limitTo, true), scope, resultCollector);
    }

    public void search(IWorkspace workspace, IJavaElement element, int limitTo, IJavaSearchScope scope, IJavaSearchResultCollector resultCollector) throws JavaModelException {
        this.search(workspace, SearchEngine.createSearchPattern(element, limitTo), scope, resultCollector);
    }

    public void search(IWorkspace workspace, ISearchPattern searchPattern, IJavaSearchScope scope, IJavaSearchResultCollector resultCollector) throws JavaModelException {
        try {
            this.search((SearchPattern)searchPattern, new SearchParticipant[]{new JavaSearchParticipant(this.getWorkingCopies())}, scope, new ResultCollectorAdapter(resultCollector), resultCollector.getProgressMonitor());
        }
        catch (CoreException e) {
            if (e instanceof JavaModelException) {
                throw (JavaModelException)e;
            }
            throw new JavaModelException(e);
        }
    }

    public void search(SearchPattern pattern, SearchParticipant[] participants, IJavaSearchScope scope, SearchRequestor requestor, IProgressMonitor monitor) throws CoreException {
        pattern.findMatches(participants, scope, requestor, monitor);
    }

    /*
     * Exception decompiling
     */
    public void searchAllTypeNames(IWorkspace workspace, char[] packageName, char[] typeName, int matchMode, boolean isCaseSensitive, int searchFor, IJavaSearchScope scope, ITypeNameRequestor nameRequestor, int waitingPolicy, IProgressMonitor progressMonitor) throws JavaModelException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 1[TRYBLOCK] [1 : 649->653)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void searchDeclarations(IWorkspace workspace, IJavaElement enclosingElement, IJavaSearchResultCollector resultCollector, SearchPattern pattern) throws JavaModelException {
        IJavaSearchScope scope = SearchEngine.createJavaSearchScope(new IJavaElement[]{enclosingElement});
        IResource resource = this.getResource(enclosingElement);
        if (resource instanceof IFile) {
            if (VERBOSE) {
                System.out.println("Searching for " + pattern + " in " + resource.getFullPath());
            }
            try {
                JavaSearchParticipant participant = new JavaSearchParticipant(this.getWorkingCopies(enclosingElement));
                ((SearchParticipant)participant).locateMatches(new SearchDocument[]{new JavaSearchDocument(enclosingElement.getPath().toString(), (SearchParticipant)participant)}, pattern, scope, new ResultCollectorAdapter(resultCollector), resultCollector.getProgressMonitor());
            }
            catch (CoreException e) {
                if (e instanceof JavaModelException) {
                    throw (JavaModelException)e;
                }
                throw new JavaModelException(e);
            }
        } else {
            this.search(workspace, pattern, scope, resultCollector);
        }
    }

    public void searchDeclarationsOfAccessedFields(IWorkspace workspace, IJavaElement enclosingElement, IJavaSearchResultCollector resultCollector) throws JavaModelException {
        DeclarationOfAccessedFieldsPattern pattern = new DeclarationOfAccessedFieldsPattern(enclosingElement);
        this.searchDeclarations(workspace, enclosingElement, resultCollector, pattern);
    }

    public void searchDeclarationsOfReferencedTypes(IWorkspace workspace, IJavaElement enclosingElement, IJavaSearchResultCollector resultCollector) throws JavaModelException {
        DeclarationOfReferencedTypesPattern pattern = new DeclarationOfReferencedTypesPattern(enclosingElement);
        this.searchDeclarations(workspace, enclosingElement, resultCollector, pattern);
    }

    public void searchDeclarationsOfSentMessages(IWorkspace workspace, IJavaElement enclosingElement, IJavaSearchResultCollector resultCollector) throws JavaModelException {
        DeclarationOfReferencedMethodsPattern pattern = new DeclarationOfReferencedMethodsPattern(enclosingElement);
        this.searchDeclarations(workspace, enclosingElement, resultCollector, pattern);
    }

    class ResultCollectorAdapter
    extends SearchRequestor {
        IJavaSearchResultCollector resultCollector;

        ResultCollectorAdapter(IJavaSearchResultCollector resultCollector) {
            this.resultCollector = resultCollector;
        }

        public boolean acceptSearchMatch(SearchMatch match) throws CoreException {
            JavaSearchMatch javaSearchMatch = (JavaSearchMatch)match;
            this.resultCollector.accept(javaSearchMatch.resource, javaSearchMatch.getSourceStart(), javaSearchMatch.getSourceEnd(), javaSearchMatch.element, javaSearchMatch.getAccuracy());
            return true;
        }

        public void beginReporting() {
            this.resultCollector.aboutToStart();
        }

        public void endReporting() {
            this.resultCollector.done();
        }

        public void enterParticipant(SearchParticipant participant) {
        }

        public void exitParticipant(SearchParticipant participant) {
        }
    }
}

