/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.runtime;

import java.io.File;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import org.eclipse.core.internal.runtime.Policy;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.osgi.framework.Bundle;

public class PlatformMetaArea {
    IPath location;
    static final String F_DESCRIPTION = ".platform";
    static final String F_META_AREA = ".metadata";
    static final String F_PLUGIN_PATH = ".plugin-path";
    static final String F_PLUGIN_DATA = ".plugins";
    static final String F_REGISTRY = ".registry";
    static final String F_SNAP = ".snap";
    static final String F_LOG = ".log";
    static final String F_BACKUP = ".bak";
    static final String F_OPTIONS = ".options";
    static final String F_KEYRING = ".keyring";
    static final String F_LOCK_FILE = ".lock";
    static final String F_VERSION = "version.ini";
    static final String PREFERENCES_FILE_NAME = "pref_store.ini";

    public PlatformMetaArea(IPath location) {
        this.location = location;
    }

    private Properties buildPathProperties(Hashtable paths) {
        Properties result = new Properties();
        Enumeration keys = paths.keys();
        while (keys.hasMoreElements()) {
            String key = (String)keys.nextElement();
            StringBuffer entry = new StringBuffer(100);
            IPath[] list = (IPath[])paths.get(key);
            int i = 0;
            while (i < list.length) {
                entry.append(list[i].toOSString());
                entry.append(";");
                ++i;
            }
            result.put(key, entry.toString());
        }
        return result;
    }

    public void createLocation() throws CoreException {
        File file = this.getLocation().toFile();
        try {
            file.mkdirs();
        }
        catch (Exception e) {
            String message = Policy.bind("meta.couldNotCreate", file.getAbsolutePath());
            throw new CoreException(new Status(4, "org.eclipse.core.runtime", 5, message, e));
        }
        if (!file.canWrite()) {
            String message = Policy.bind("meta.readonly", file.getAbsolutePath());
            throw new CoreException(new Status(4, "org.eclipse.core.runtime", 5, message, null));
        }
    }

    public IPath getBackupFilePathFor(IPath file) {
        return file.removeLastSegments(1).append(String.valueOf(file.lastSegment()) + F_BACKUP);
    }

    public IPath getLocation() {
        return this.location.append(F_META_AREA);
    }

    public IPath getLogLocation() {
        return this.getLocation().append(F_LOG);
    }

    public IPath getStateLocation(Bundle bundle) {
        return this.getLocation().append(F_PLUGIN_DATA).append(bundle.getGlobalName());
    }

    public IPath getOptionsLocation() {
        return this.getLocation().append(F_OPTIONS);
    }

    public IPath getPreferenceLocation(Bundle bundle, boolean create) {
        IPath result = this.getStateLocation(bundle);
        if (create) {
            result.toFile().mkdirs();
        }
        return result.append(PREFERENCES_FILE_NAME);
    }

    public IPath getRegistryPath() {
        return this.getLocation().append(F_REGISTRY);
    }

    public IPath getVersionPath() {
        return this.getLocation().append(F_VERSION);
    }

    public IPath getSnapshotPath() {
        return this.getLocation().append(F_SNAP);
    }

    private Hashtable parsePathProperties(Properties props) {
        Hashtable<String, Object[]> result = new Hashtable<String, Object[]>(5);
        Enumeration<?> keys = props.propertyNames();
        while (keys.hasMoreElements()) {
            String key = (String)keys.nextElement();
            String entry = props.getProperty(key);
            Vector<Path> list = new Vector<Path>(4);
            StringTokenizer tokens = new StringTokenizer(entry, ";");
            while (tokens.hasMoreTokens()) {
                list.addElement(new Path(tokens.nextToken()));
            }
            Object[] paths = new IPath[list.size()];
            list.copyInto(paths);
            result.put(key, paths);
        }
        return result;
    }

    /*
     * Exception decompiling
     */
    public Hashtable readPluginPath(IPath location) throws CoreException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 2[TRYBLOCK] [1 : 78->84)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    public void writePluginPath(Hashtable paths, IPath location) throws CoreException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 2[TRYBLOCK] [1 : 79->85)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public IPath getPluginPreferenceLocation(Bundle bundle, boolean create) {
        IPath result = this.getStateLocation(bundle);
        if (create) {
            result.toFile().mkdirs();
        }
        return result.append(PREFERENCES_FILE_NAME);
    }
}

