/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.boot;

import java.io.IOException;
import java.net.URL;
import org.eclipse.core.internal.boot.PlatformURLConnection;
import org.eclipse.core.internal.boot.PlatformURLHandler;
import org.eclipse.core.internal.runtime.Policy;

public class PlatformURLBaseConnection
extends PlatformURLConnection {
    public static final String PLATFORM = "base";
    public static final String PLATFORM_URL_STRING = "platform:/base/";
    private static URL installURL;
    static /* synthetic */ Class class$0;

    public PlatformURLBaseConnection(URL url) {
        super(url);
    }

    protected boolean allowCaching() {
        return true;
    }

    protected URL resolve() throws IOException {
        String spec = this.url.getFile().trim();
        if (spec.startsWith("/")) {
            spec = spec.substring(1);
        }
        if (!spec.startsWith("base/")) {
            String message = Policy.bind("url.badVariant", this.url.toString());
            throw new IOException(message);
        }
        return spec.length() == PLATFORM.length() + 1 ? installURL : new URL(installURL, spec.substring(PLATFORM.length() + 1));
    }

    public static void startup(URL url) {
        if (installURL != null) {
            return;
        }
        installURL = url;
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("[Lorg.eclipse.core.internal.boot.PlatformURLBaseConnection;").getComponentType();
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        PlatformURLHandler.register(PLATFORM, clazz);
    }
}

