/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.weaver;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.aspectj.weaver.CrosscuttingMembers;
import org.aspectj.weaver.ResolvedTypeX;
import org.aspectj.weaver.TypeX;
import org.aspectj.weaver.World;
import org.aspectj.weaver.patterns.DeclareParents;

public class CrosscuttingMembersSet {
    private World world;
    private Map members = new HashMap();
    private List shadowMungers = null;
    private List typeMungers = null;
    private List declareSofts = null;
    private List declareParents = null;
    private List declareDominates = null;

    public CrosscuttingMembersSet(World world) {
        this.world = world;
    }

    public boolean addOrReplaceAspect(ResolvedTypeX aspectType) {
        CrosscuttingMembers xcut = (CrosscuttingMembers)this.members.get(aspectType);
        if (xcut == null) {
            this.members.put(aspectType, aspectType.collectCrosscuttingMembers());
            this.clearCaches();
            return true;
        }
        if (xcut.replaceWith(aspectType.collectCrosscuttingMembers())) {
            this.clearCaches();
            return true;
        }
        return false;
    }

    public void addAdviceLikeDeclares(ResolvedTypeX aspectType) {
        CrosscuttingMembers xcut = (CrosscuttingMembers)this.members.get(aspectType);
        xcut.addDeclares(aspectType.collectDeclares(true));
    }

    public boolean deleteAspect(TypeX aspectType) {
        boolean isAspect = this.members.remove(aspectType) != null;
        this.clearCaches();
        return isAspect;
    }

    public boolean containsAspect(TypeX aspectType) {
        return this.members.containsKey(aspectType);
    }

    public void addFixedCrosscuttingMembers(ResolvedTypeX aspectType) {
        this.members.put(aspectType, aspectType.crosscuttingMembers);
        this.clearCaches();
    }

    private void clearCaches() {
        this.shadowMungers = null;
        this.typeMungers = null;
        this.declareSofts = null;
        this.declareParents = null;
        this.declareDominates = null;
    }

    public List getShadowMungers() {
        if (this.shadowMungers == null) {
            ArrayList ret = new ArrayList();
            Iterator i = this.members.values().iterator();
            while (i.hasNext()) {
                ret.addAll(((CrosscuttingMembers)i.next()).getShadowMungers());
            }
            this.shadowMungers = ret;
        }
        return this.shadowMungers;
    }

    public List getTypeMungers() {
        if (this.typeMungers == null) {
            ArrayList ret = new ArrayList();
            Iterator i = this.members.values().iterator();
            while (i.hasNext()) {
                ret.addAll(((CrosscuttingMembers)i.next()).getTypeMungers());
            }
            this.typeMungers = ret;
        }
        return this.typeMungers;
    }

    public List getDeclareSofts() {
        if (this.declareSofts == null) {
            ArrayList ret = new ArrayList();
            Iterator i = this.members.values().iterator();
            while (i.hasNext()) {
                ret.addAll(((CrosscuttingMembers)i.next()).getDeclareSofts());
            }
            this.declareSofts = ret;
        }
        return this.declareSofts;
    }

    public List getDeclareParents() {
        if (this.declareParents == null) {
            ArrayList ret = new ArrayList();
            Iterator i = this.members.values().iterator();
            while (i.hasNext()) {
                ret.addAll(((CrosscuttingMembers)i.next()).getDeclareParents());
            }
            this.declareParents = ret;
        }
        return this.declareParents;
    }

    public List getDeclareDominates() {
        if (this.declareDominates == null) {
            ArrayList ret = new ArrayList();
            Iterator i = this.members.values().iterator();
            while (i.hasNext()) {
                ret.addAll(((CrosscuttingMembers)i.next()).getDeclareDominates());
            }
            this.declareDominates = ret;
        }
        return this.declareDominates;
    }

    public ResolvedTypeX findAspectDeclaringParents(DeclareParents p) {
        HashSet result = new HashSet();
        Set keys = this.members.keySet();
        Iterator iter = keys.iterator();
        while (iter.hasNext()) {
            ResolvedTypeX element = (ResolvedTypeX)iter.next();
            Iterator i = ((CrosscuttingMembers)this.members.get(element)).getDeclareParents().iterator();
            if (!i.hasNext()) continue;
            DeclareParents dp = (DeclareParents)i.next();
            return element;
        }
        return null;
    }
}

