/*!
* TableSorter 2.13.3 min - Client-side table sorting with ease!
* Copyright (c) 2007 Christian Bach
*/
!(function($){"use strict";$.extend({tablesorter:new function(){var ts=this;ts.version="2.13.3";ts.parsers=[];ts.widgets=[];ts.defaults={theme:'default',widthFixed:false,showProcessing:false,headerTemplate:'{content}',onRenderTemplate:null,onRenderHeader:null,cancelSelection:true,dateFormat:'mmddyyyy',sortMultiSortKey:'shiftKey',sortResetKey:'ctrlKey',usNumberFormat:true,delayInit:false,serverSideSorting:false,headers:{},ignoreCase:true,sortForce:null,sortList:[],sortAppend:null,sortInitialOrder:'asc',sortLocaleCompare:false,sortReset:false,sortRestart:false,emptyTo:'bottom',stringTo:'max',textExtraction:'simple',textSorter:null,numberSorter:null,widgets:[],widgetOptions:{zebra:['even','odd']},initWidgets:true,initialized:null,tableClass:'',cssAsc:'',cssDesc:'',cssHeader:'',cssHeaderRow:'',cssProcessing:'',cssChildRow:'tablesorter-childRow',cssIcon:'tablesorter-icon',cssInfoBlock:'tablesorter-infoOnly',selectorHeaders:'> thead th, > thead td',selectorSort:'th, td',selectorRemove:'.remove-me',debug:false,headerList:[],empties:{},strings:{},parsers:[]};ts.css={table:'tablesorter',childRow:'tablesorter-childRow',header:'tablesorter-header',headerRow:'tablesorter-headerRow',icon:'tablesorter-icon',info:'tablesorter-infoOnly',processing:'tablesorter-processing',sortAsc:'tablesorter-headerAsc',sortDesc:'tablesorter-headerDesc'};function log(){var s=arguments.length>1?Array.prototype.slice.call(arguments):arguments[0];if(typeof console!=="undefined"&&typeof console.log!=="undefined"){console.log(s);}else{alert(s);}}
function benchmark(s,d){log(s+" ("+(new Date().getTime()-d.getTime())+"ms)");}
ts.log=log;ts.benchmark=benchmark;function isEmptyObject(obj){for(var name in obj){return false;}
return true;}
function getElementText(table,node,cellIndex){if(!node){return"";}
var c=table.config,t=c.textExtraction,text="";if(t==="simple"){if(c.supportsTextContent){text=node.textContent;}else{text=$(node).text();}}else{if(typeof t==="function"){text=t(node,table,cellIndex);}else if(typeof t==="object"&&t.hasOwnProperty(cellIndex)){text=t[cellIndex](node,table,cellIndex);}else{text=c.supportsTextContent?node.textContent:$(node).text();}}
return $.trim(text);}
function detectParserForColumn(table,rows,rowIndex,cellIndex){var cur,i=ts.parsers.length,node=false,nodeValue='',keepLooking=true;while(nodeValue===''&&keepLooking){rowIndex++;if(rows[rowIndex]){node=rows[rowIndex].cells[cellIndex];nodeValue=getElementText(table,node,cellIndex);if(table.config.debug){log('Checking if value was empty on row '+rowIndex+', column: '+cellIndex+': "'+nodeValue+'"');}}else{keepLooking=false;}}
while(--i>=0){cur=ts.parsers[i];if(cur&&cur.id!=='text'&&cur.is&&cur.is(nodeValue,table,node)){return cur;}}
return ts.getParserById('text');}
function buildParserCache(table){var c=table.config,tb=c.$tbodies=c.$table.children('tbody:not(.'+c.cssInfoBlock+')'),rows,list,l,i,h,ch,p,time,parsersDebug="";if(tb.length===0){return c.debug?log('*Empty table!* Not building a parser cache'):'';}else if(c.debug){time=new Date();log('Detecting parsers for each column');}
rows=tb[0].rows;if(rows[0]){list=[];l=rows[0].cells.length;for(i=0;i<l;i++){h=c.$headers.filter(':not([colspan])');h=h.add(c.$headers.filter('[colspan="1"]')).filter('[data-column="'+i+'"]:last');ch=c.headers[i];p=ts.getParserById(ts.getData(h,ch,'sorter'));c.empties[i]=ts.getData(h,ch,'empty')||c.emptyTo||(c.emptyToBottom?'bottom':'top');c.strings[i]=ts.getData(h,ch,'string')||c.stringTo||'max';if(!p){p=detectParserForColumn(table,rows,-1,i);}
if(c.debug){parsersDebug+="column:"+i+"; parser:"+p.id+"; string:"+c.strings[i]+'; empty: '+c.empties[i]+"\n";}
list.push(p);}}
if(c.debug){log(parsersDebug);benchmark("Completed detecting parsers",time);}
c.parsers=list;}
function buildCache(table){var b=table.tBodies,tc=table.config,totalRows,totalCells,parsers=tc.parsers,t,v,i,j,k,c,cols,cacheTime,colMax=[];tc.cache={};if(!parsers){return tc.debug?log('*Empty table!* Not building a cache'):'';}
if(tc.debug){cacheTime=new Date();}
if(tc.showProcessing){ts.isProcessing(table,true);}
for(k=0;k<b.length;k++){tc.cache[k]={row:[],normalized:[]};if(!$(b[k]).hasClass(tc.cssInfoBlock)){totalRows=(b[k]&&b[k].rows.length)||0;totalCells=(b[k].rows[0]&&b[k].rows[0].cells.length)||0;for(i=0;i<totalRows;++i){c=$(b[k].rows[i]);cols=[];if(c.hasClass(tc.cssChildRow)){tc.cache[k].row[tc.cache[k].row.length-1]=tc.cache[k].row[tc.cache[k].row.length-1].add(c);continue;}
tc.cache[k].row.push(c);for(j=0;j<totalCells;++j){t=getElementText(table,c[0].cells[j],j);v=parsers[j].format(t,table,c[0].cells[j],j);cols.push(v);if((parsers[j].type||'').toLowerCase()==="numeric"){colMax[j]=Math.max(Math.abs(v)||0,colMax[j]||0);}}
cols.push(tc.cache[k].normalized.length);tc.cache[k].normalized.push(cols);}
tc.cache[k].colMax=colMax;}}
if(tc.showProcessing){ts.isProcessing(table);}
if(tc.debug){benchmark("Building cache for "+totalRows+" rows",cacheTime);}}
function appendToTable(table,init){var c=table.config,wo=c.widgetOptions,b=table.tBodies,rows=[],c2=c.cache,r,n,totalRows,checkCell,$bk,$tb,i,j,k,l,pos,appendTime;if(isEmptyObject(c2)){return;}
if(c.debug){appendTime=new Date();}
for(k=0;k<b.length;k++){$bk=$(b[k]);if($bk.length&&!$bk.hasClass(c.cssInfoBlock)){$tb=ts.processTbody(table,$bk,true);r=c2[k].row;n=c2[k].normalized;totalRows=n.length;checkCell=totalRows?(n[0].length-1):0;for(i=0;i<totalRows;i++){pos=n[i][checkCell];rows.push(r[pos]);if(!c.appender||(c.pager&&(!c.pager.removeRows||!wo.pager_removeRows)&&!c.pager.ajax)){l=r[pos].length;for(j=0;j<l;j++){$tb.append(r[pos][j]);}}}
ts.processTbody(table,$tb,false);}}
if(c.appender){c.appender(table,rows);}
if(c.debug){benchmark("Rebuilt table",appendTime);}
if(!init&&!c.appender){ts.applyWidget(table);}
$(table).trigger("sortEnd",table);$(table).trigger("updateComplete",table);}
function computeThIndexes(t){var matrix=[],lookup={},cols=0,trs=$(t).find('thead:eq(0), tfoot').children('tr'),i,j,k,l,c,cells,rowIndex,cellId,rowSpan,colSpan,firstAvailCol,matrixrow;for(i=0;i<trs.length;i++){cells=trs[i].cells;for(j=0;j<cells.length;j++){c=cells[j];rowIndex=c.parentNode.rowIndex;cellId=rowIndex+"-"+c.cellIndex;rowSpan=c.rowSpan||1;colSpan=c.colSpan||1;if(typeof(matrix[rowIndex])==="undefined"){matrix[rowIndex]=[];}
for(k=0;k<matrix[rowIndex].length+1;k++){if(typeof(matrix[rowIndex][k])==="undefined"){firstAvailCol=k;break;}}
lookup[cellId]=firstAvailCol;cols=Math.max(firstAvailCol,cols);$(c).attr({'data-column':firstAvailCol});for(k=rowIndex;k<rowIndex+rowSpan;k++){if(typeof(matrix[k])==="undefined"){matrix[k]=[];}
matrixrow=matrix[k];for(l=firstAvailCol;l<firstAvailCol+colSpan;l++){matrixrow[l]="x";}}}}
t.config.columns=cols+1;return lookup;}
function formatSortingOrder(v){return(/^d/i.test(v)||v===1);}
function buildHeaders(table){var header_index=computeThIndexes(table),ch,$t,h,i,t,lock,time,c=table.config;c.headerList=[];c.headerContent=[];if(c.debug){time=new Date();}
i=c.cssIcon?'<i class="'+c.cssIcon+' '+ts.css.icon+'"></i>':'';c.$headers=$(table).find(c.selectorHeaders).each(function(index){$t=$(this);ch=c.headers[index];c.headerContent[index]=$(this).html();t=c.headerTemplate.replace(/\{content\}/g,$(this).html()).replace(/\{icon\}/g,i);if(c.onRenderTemplate){h=c.onRenderTemplate.apply($t,[index,t]);if(h&&typeof h==='string'){t=h;}}
$(this).html('<div class="tablesorter-header-inner">'+t+'</div>');if(c.onRenderHeader){c.onRenderHeader.apply($t,[index]);}
this.column=header_index[this.parentNode.rowIndex+"-"+this.cellIndex];this.order=formatSortingOrder(ts.getData($t,ch,'sortInitialOrder')||c.sortInitialOrder)?[1,0,2]:[0,1,2];this.count=-1;this.lockedOrder=false;lock=ts.getData($t,ch,'lockedOrder')||false;if(typeof lock!=='undefined'&&lock!==false){this.order=this.lockedOrder=formatSortingOrder(lock)?[1,1,1]:[0,0,0];}
$t.addClass(ts.css.header+' '+c.cssHeader);c.headerList[index]=this;$t.parent().addClass(ts.css.headerRow+' '+c.cssHeaderRow);$t.attr("tabindex",0);});updateHeader(table);if(c.debug){benchmark("Built headers:",time);log(c.$headers);}}
function commonUpdate(table,resort,callback){var c=table.config;c.$table.find(c.selectorRemove).remove();buildParserCache(table);buildCache(table);checkResort(c.$table,resort,callback);}
function updateHeader(table){var s,c=table.config;c.$headers.each(function(index,th){s=ts.getData(th,c.headers[index],'sorter')==='false';th.sortDisabled=s;$(th)[s?'addClass':'removeClass']('sorter-false');});}
function setHeadersCss(table){var f,i,j,l,c=table.config,list=c.sortList,css=[ts.css.sortAsc+' '+c.cssAsc,ts.css.sortDesc+' '+c.cssDesc],$t=$(table).find('tfoot tr').children().removeClass(css.join(' '));c.$headers.removeClass(css.join(' '));l=list.length;for(i=0;i<l;i++){if(list[i][1]!==2){f=c.$headers.not('.sorter-false').filter('[data-column="'+list[i][0]+'"]'+(l===1?':last':''));if(f.length){for(j=0;j<f.length;j++){if(!f[j].sortDisabled){f.eq(j).addClass(css[list[i][1]]);if($t.length){$t.filter('[data-column="'+list[i][0]+'"]').eq(j).addClass(css[list[i][1]]);}}}}}}}
function fixColumnWidth(table){if(table.config.widthFixed&&$(table).find('colgroup').length===0){var colgroup=$('<colgroup>'),overallWidth=$(table).width();$(table.tBodies[0]).find("tr:first").children("td:visible").each(function(){colgroup.append($('<col>').css('width',parseInt(($(this).width()/overallWidth)*1000,10)/10+'%'));});$(table).prepend(colgroup);}}
function updateHeaderSortCount(table,list){var s,t,o,c=table.config,sl=list||c.sortList;c.sortList=[];$.each(sl,function(i,v){s=[parseInt(v[0],10),parseInt(v[1],10)];o=c.$headers[s[0]];if(o){c.sortList.push(s);t=$.inArray(s[1],o.order);o.count=t>=0?t:s[1]%(c.sortReset?3:2);}});}
function getCachedSortType(parsers,i){return(parsers&&parsers[i])?parsers[i].type||'':'';}
function initSort(table,cell,e){var a,i,j,o,s,c=table.config,k=!e[c.sortMultiSortKey],$this=$(table);$this.trigger("sortStart",table);cell.count=e[c.sortResetKey]?2:(cell.count+1)%(c.sortReset?3:2);if(c.sortRestart){i=cell;c.$headers.each(function(){if(this!==i&&(k||!$(this).is('.'+ts.css.sortDesc+',.'+ts.css.sortAsc))){this.count=-1;}});}
i=cell.column;if(k){c.sortList=[];if(c.sortForce!==null){a=c.sortForce;for(j=0;j<a.length;j++){if(a[j][0]!==i){c.sortList.push(a[j]);}}}
o=cell.order[cell.count];if(o<2){c.sortList.push([i,o]);if(cell.colSpan>1){for(j=1;j<cell.colSpan;j++){c.sortList.push([i+j,o]);}}}}else{if(c.sortAppend&&c.sortList.length>1){if(ts.isValueInArray(c.sortAppend[0][0],c.sortList)){c.sortList.pop();}}
if(ts.isValueInArray(i,c.sortList)){for(j=0;j<c.sortList.length;j++){s=c.sortList[j];o=c.$headers[s[0]];if(s[0]===i){s[1]=o.order[cell.count];if(s[1]===2){c.sortList.splice(j,1);o.count=-1;}}}}else{o=cell.order[cell.count];if(o<2){c.sortList.push([i,o]);if(cell.colSpan>1){for(j=1;j<cell.colSpan;j++){c.sortList.push([i+j,o]);}}}}}
if(c.sortAppend!==null){a=c.sortAppend;for(j=0;j<a.length;j++){if(a[j][0]!==i){c.sortList.push(a[j]);}}}
$this.trigger("sortBegin",table);setTimeout(function(){setHeadersCss(table);multisort(table);appendToTable(table);},1);}
function multisort(table){var i,k,e,num,col,colMax,cache,lc,order,orgOrderCol,sortTime,sort,x,y,dir=0,c=table.config,cts=c.textSorter||'',sortList=c.sortList,l=sortList.length,bl=table.tBodies.length;if(c.serverSideSorting||isEmptyObject(c.cache)){return;}
if(c.debug){sortTime=new Date();}
for(k=0;k<bl;k++){colMax=c.cache[k].colMax;cache=c.cache[k].normalized;lc=cache.length;orgOrderCol=(cache&&cache[0])?cache[0].length-1:0;cache.sort(function(a,b){for(i=0;i<l;i++){col=sortList[i][0];order=sortList[i][1];dir=order===0;x=dir?a:b;y=dir?b:a;e=c.string[(c.empties[col]||c.emptyTo)];if(x[col]===''&&e!==0){return((typeof(e)==='boolean')?(e?-1:1):(e||1))*(dir?1:-1);}
if(y[col]===''&&e!==0){return((typeof(e)==='boolean')?(e?1:-1):(-e||-1))*(dir?1:-1);}
num=/n/i.test(getCachedSortType(c.parsers,col));if(num&&c.strings[col]){if(typeof(c.string[c.strings[col]])==='boolean'){num=(dir?1:-1)*(c.string[c.strings[col]]?-1:1);}else{num=(c.strings[col])?c.string[c.strings[col]]||0:0;}
sort=c.numberSorter?c.numberSorter(x[col],y[col],dir,colMax[col],table):ts.sortNumeric(x[col],y[col],num,colMax[col]);}else{if(typeof(cts)==='function'){sort=cts(x[col],y[col],dir,col,table);}else if(typeof(cts)==='object'&&cts.hasOwnProperty(col)){sort=cts[col](x[col],y[col],dir,col,table);}else{sort=ts.sortNatural(x[col],y[col]);}}
if(sort){return sort;}}
return a[orgOrderCol]-b[orgOrderCol];});}
if(c.debug){benchmark("Sorting on "+sortList.toString()+" and dir "+order+" time",sortTime);}}
function resortComplete($table,callback){var c=$table[0].config;if(c.pager&&!c.pager.ajax){$table.trigger('updateComplete');}
if(typeof callback==="function"){callback($table[0]);}}
function checkResort($table,flag,callback){if(flag!==false&&!$table[0].isProcessing){$table.trigger("sorton",[$table[0].config.sortList,function(){resortComplete($table,callback);}]);}else{resortComplete($table,callback);}}
function bindEvents(table){var c=table.config,$this=c.$table,j,downTime;c.$headers.find(c.selectorSort).add(c.$headers.filter(c.selectorSort)).unbind('mousedown.tablesorter mouseup.tablesorter sort.tablesorter keypress.tablesorter').bind('mousedown.tablesorter mouseup.tablesorter sort.tablesorter keypress.tablesorter',function(e,external){if(((e.which||e.button)!==1&&!/sort|keypress/.test(e.type))||(e.type==='keypress'&&e.which!==13)){return;}
if(e.type==='mouseup'&&external!==true&&(new Date().getTime()-downTime>250)){return;}
if(e.type==='mousedown'){downTime=new Date().getTime();return e.target.tagName==="INPUT"?'':!c.cancelSelection;}
if(c.delayInit&&isEmptyObject(c.cache)){buildCache(table);}
var $cell=/TH|TD/.test(this.tagName)?$(this):$(this).parents('th, td').filter(':first'),cell=$cell[0];if(!cell.sortDisabled){initSort(table,cell,e);}});if(c.cancelSelection){c.$headers.attr('unselectable','on').bind('selectstart',false).css({'user-select':'none','MozUserSelect':'none'});}
$this.unbind('sortReset update updateRows updateCell updateAll addRows sorton appendCache applyWidgetId applyWidgets refreshWidgets destroy mouseup mouseleave '.split(' ').join('.tablesorter ')).bind("sortReset.tablesorter",function(e){e.stopPropagation();c.sortList=[];setHeadersCss(table);multisort(table);appendToTable(table);}).bind("updateAll.tablesorter",function(e,resort,callback){e.stopPropagation();ts.refreshWidgets(table,true,true);ts.restoreHeaders(table);buildHeaders(table);bindEvents(table);commonUpdate(table,resort,callback);}).bind("update.tablesorter updateRows.tablesorter",function(e,resort,callback){e.stopPropagation();updateHeader(table);commonUpdate(table,resort,callback);}).bind("updateCell.tablesorter",function(e,cell,resort,callback){e.stopPropagation();$this.find(c.selectorRemove).remove();var l,row,icell,$tb=$this.find('tbody'),tbdy=$tb.index($(cell).parents('tbody').filter(':first')),$row=$(cell).parents('tr').filter(':first');cell=$(cell)[0];if($tb.length&&tbdy>=0){row=$tb.eq(tbdy).find('tr').index($row);icell=cell.cellIndex;l=c.cache[tbdy].normalized[row].length-1;c.cache[tbdy].row[table.config.cache[tbdy].normalized[row][l]]=$row;c.cache[tbdy].normalized[row][icell]=c.parsers[icell].format(getElementText(table,cell,icell),table,cell,icell);checkResort($this,resort,callback);}}).bind("addRows.tablesorter",function(e,$row,resort,callback){e.stopPropagation();var i,rows=$row.filter('tr').length,dat=[],l=$row[0].cells.length,tbdy=$this.find('tbody').index($row.parents('tbody').filter(':first'));if(!c.parsers){buildParserCache(table);}
for(i=0;i<rows;i++){for(j=0;j<l;j++){dat[j]=c.parsers[j].format(getElementText(table,$row[i].cells[j],j),table,$row[i].cells[j],j);}
dat.push(c.cache[tbdy].row.length);c.cache[tbdy].row.push([$row[i]]);c.cache[tbdy].normalized.push(dat);dat=[];}
checkResort($this,resort,callback);}).bind("sorton.tablesorter",function(e,list,callback,init){var c=table.config;e.stopPropagation();$this.trigger("sortStart",this);updateHeaderSortCount(table,list);setHeadersCss(table);if(c.delayInit&&isEmptyObject(c.cache)){buildCache(table);}
$this.trigger("sortBegin",this);multisort(table);appendToTable(table,init);if(typeof callback==="function"){callback(table);}}).bind("appendCache.tablesorter",function(e,callback,init){e.stopPropagation();appendToTable(table,init);if(typeof callback==="function"){callback(table);}}).bind("applyWidgetId.tablesorter",function(e,id){e.stopPropagation();ts.getWidgetById(id).format(table,c,c.widgetOptions);}).bind("applyWidgets.tablesorter",function(e,init){e.stopPropagation();ts.applyWidget(table,init);}).bind("refreshWidgets.tablesorter",function(e,all,dontapply){e.stopPropagation();ts.refreshWidgets(table,all,dontapply);}).bind("destroy.tablesorter",function(e,c,cb){e.stopPropagation();ts.destroy(table,c,cb);});}
ts.construct=function(settings){return this.each(function(){var table=this,c=$.extend(true,{},ts.defaults,settings);if(!table.hasInitialized&&ts.buildTable&&this.tagName!=='TABLE'){ts.buildTable(table,c);}
ts.setup(table,c);});};ts.setup=function(table,c){if(!table||!table.tHead||table.tBodies.length===0||table.hasInitialized===true){return c.debug?log('stopping initialization! No table, thead, tbody or tablesorter has already been initialized'):'';}
var k='',$this=$(table),m=$.metadata;table.hasInitialized=false;table.isProcessing=true;table.config=c;$.data(table,"tablesorter",c);if(c.debug){$.data(table,'startoveralltimer',new Date());}
c.supportsTextContent=$('<span>x</span>')[0].textContent==='x';c.supportsDataObject=(function(version){version[0]=parseInt(version[0],10);return(version[0]>1)||(version[0]===1&&parseInt(version[1],10)>=4);})($.fn.jquery.split("."));c.string={'max':1,'min':-1,'max+':1,'max-':-1,'zero':0,'none':0,'null':0,'top':true,'bottom':false};if(!/tablesorter\-/.test($this.attr('class'))){k=(c.theme!==''?' tablesorter-'+c.theme:'');}
c.$table=$this.addClass(ts.css.table+' '+c.tableClass+k);c.$tbodies=$this.children('tbody:not(.'+c.cssInfoBlock+')');c.widgetInit={};buildHeaders(table);fixColumnWidth(table);buildParserCache(table);if(!c.delayInit){buildCache(table);}
bindEvents(table);if(c.supportsDataObject&&typeof $this.data().sortlist!=='undefined'){c.sortList=$this.data().sortlist;}else if(m&&($this.metadata()&&$this.metadata().sortlist)){c.sortList=$this.metadata().sortlist;}
ts.applyWidget(table,true);if(c.sortList.length>0){$this.trigger("sorton",[c.sortList,{},!c.initWidgets]);}else if(c.initWidgets){ts.applyWidget(table);}
if(c.showProcessing){$this.unbind('sortBegin.tablesorter sortEnd.tablesorter').bind('sortBegin.tablesorter sortEnd.tablesorter',function(e){ts.isProcessing(table,e.type==='sortBegin');});}
table.hasInitialized=true;table.isProcessing=false;if(c.debug){ts.benchmark("Overall initialization time",$.data(table,'startoveralltimer'));}
$this.trigger('tablesorter-initialized',table);if(typeof c.initialized==='function'){c.initialized(table);}};ts.isProcessing=function(table,toggle,$ths){table=$(table);var c=table[0].config,$h=$ths||table.find('.'+ts.css.header);if(toggle){if(c.sortList.length>0){$h=$h.filter(function(){return this.sortDisabled?false:ts.isValueInArray(parseFloat($(this).attr('data-column')),c.sortList);});}
$h.addClass(ts.css.processing+' '+c.cssProcessing);}else{$h.removeClass(ts.css.processing+' '+c.cssProcessing);}};ts.processTbody=function(table,$tb,getIt){var holdr;if(getIt){table.isProcessing=true;$tb.before('<span class="tablesorter-savemyplace"/>');holdr=($.fn.detach)?$tb.detach():$tb.remove();return holdr;}
holdr=$(table).find('span.tablesorter-savemyplace');$tb.insertAfter(holdr);holdr.remove();table.isProcessing=false;};ts.clearTableBody=function(table){$(table)[0].config.$tbodies.empty();};ts.restoreHeaders=function(table){var c=table.config;c.$table.find(c.selectorHeaders).each(function(i){if($(this).find('.tablesorter-header-inner').length){$(this).html(c.headerContent[i]);}});};ts.destroy=function(table,removeClasses,callback){table=$(table)[0];if(!table.hasInitialized){return;}
ts.refreshWidgets(table,true,true);var $t=$(table),c=table.config,$h=$t.find('thead:first'),$r=$h.find('tr.'+ts.css.headerRow).removeClass(ts.css.headerRow+' '+c.cssHeaderRow),$f=$t.find('tfoot:first > tr').children('th, td');$h.find('tr').not($r).remove();$t.removeData('tablesorter').unbind('sortReset update updateAll updateRows updateCell addRows sorton appendCache applyWidgetId applyWidgets refreshWidgets destroy mouseup mouseleave keypress sortBegin sortEnd '.split(' ').join('.tablesorter '));c.$headers.add($f).removeClass([ts.css.header,c.cssHeader,c.cssAsc,c.cssDesc,ts.css.sortAsc,ts.css.sortDesc].join(' ')).removeAttr('data-column');$r.find(c.selectorSort).unbind('mousedown.tablesorter mouseup.tablesorter keypress.tablesorter');ts.restoreHeaders(table);if(removeClasses!==false){$t.removeClass(ts.css.table+' '+c.tableClass+' tablesorter-'+c.theme);}
table.hasInitialized=false;if(typeof callback==='function'){callback(table);}};ts.regex={chunk:/(^([+\-]?(?:0|[1-9]\d*)(?:\.\d*)?(?:[eE][+\-]?\d+)?)?$|^0x[0-9a-f]+$|\d+)/gi,hex:/^0x[0-9a-f]+$/i};ts.sortNatural=function(a,b){if(a===b){return 0;}
var xN,xD,yN,yD,xF,yF,i,mx,r=ts.regex;if(r.hex.test(b)){xD=parseInt(a.match(r.hex),16);yD=parseInt(b.match(r.hex),16);if(xD<yD){return-1;}
if(xD>yD){return 1;}}
xN=a.replace(r.chunk,'\\0$1\\0').replace(/\\0$/,'').replace(/^\\0/,'').split('\\0');yN=b.replace(r.chunk,'\\0$1\\0').replace(/\\0$/,'').replace(/^\\0/,'').split('\\0');mx=Math.max(xN.length,yN.length);for(i=0;i<mx;i++){xF=isNaN(xN[i])?xN[i]||0:parseFloat(xN[i])||0;yF=isNaN(yN[i])?yN[i]||0:parseFloat(yN[i])||0;if(isNaN(xF)!==isNaN(yF)){return(isNaN(xF))?1:-1;}
if(typeof xF!==typeof yF){xF+='';yF+='';}
if(xF<yF){return-1;}
if(xF>yF){return 1;}}
return 0;};ts.sortText=function(a,b){return a>b?1:(a<b?-1:0);};ts.getTextValue=function(a,d,mx){if(mx){var i,l=a?a.length:0,n=mx+d;for(i=0;i<l;i++){n+=a.charCodeAt(i);}
return d*n;}
return 0;};ts.sortNumeric=function(a,b,dir,mx){if(a===b){return 0;}
if(isNaN(a)){a=ts.getTextValue(a,dir,mx);}
if(isNaN(b)){b=ts.getTextValue(b,dir,mx);}
return a-b;};ts.characterEquivalents={"a":"\u00e1\u00e0\u00e2\u00e3\u00e4\u0105\u00e5","A":"\u00c1\u00c0\u00c2\u00c3\u00c4\u0104\u00c5","c":"\u00e7\u0107\u010d","C":"\u00c7\u0106\u010c","e":"\u00e9\u00e8\u00ea\u00eb\u011b\u0119","E":"\u00c9\u00c8\u00ca\u00cb\u011a\u0118","i":"\u00ed\u00ec\u0130\u00ee\u00ef\u0131","I":"\u00cd\u00cc\u0130\u00ce\u00cf","o":"\u00f3\u00f2\u00f4\u00f5\u00f6","O":"\u00d3\u00d2\u00d4\u00d5\u00d6","ss":"\u00df","SS":"\u1e9e","u":"\u00fa\u00f9\u00fb\u00fc\u016f","U":"\u00da\u00d9\u00db\u00dc\u016e"};ts.replaceAccents=function(s){var a,acc='[',eq=ts.characterEquivalents;if(!ts.characterRegex){ts.characterRegexArray={};for(a in eq){if(typeof a==='string'){acc+=eq[a];ts.characterRegexArray[a]=new RegExp('['+eq[a]+']','g');}}
ts.characterRegex=new RegExp(acc+']');}
if(ts.characterRegex.test(s)){for(a in eq){if(typeof a==='string'){s=s.replace(ts.characterRegexArray[a],a);}}}
return s;};ts.isValueInArray=function(v,a){var i,l=a.length;for(i=0;i<l;i++){if(a[i][0]===v){return true;}}
return false;};ts.addParser=function(parser){var i,l=ts.parsers.length,a=true;for(i=0;i<l;i++){if(ts.parsers[i].id.toLowerCase()===parser.id.toLowerCase()){a=false;}}
if(a){ts.parsers.push(parser);}};ts.getParserById=function(name){var i,l=ts.parsers.length;for(i=0;i<l;i++){if(ts.parsers[i].id.toLowerCase()===(name.toString()).toLowerCase()){return ts.parsers[i];}}
return false;};ts.addWidget=function(widget){ts.widgets.push(widget);};ts.getWidgetById=function(name){var i,w,l=ts.widgets.length;for(i=0;i<l;i++){w=ts.widgets[i];if(w&&w.hasOwnProperty('id')&&w.id.toLowerCase()===name.toLowerCase()){return w;}}};ts.applyWidget=function(table,init){table=$(table)[0];var c=table.config,wo=c.widgetOptions,widgets=[],time,w,wd;if(c.debug){time=new Date();}
if(c.widgets.length){c.widgets=$.grep(c.widgets,function(v,k){return $.inArray(v,c.widgets)===k;});$.each(c.widgets||[],function(i,n){wd=ts.getWidgetById(n);if(wd&&wd.id){if(!wd.priority){wd.priority=10;}
widgets[i]=wd;}});widgets.sort(function(a,b){return a.priority<b.priority?-1:a.priority===b.priority?0:1;});$.each(widgets,function(i,w){if(w){if(init||!(c.widgetInit[w.id])){if(w.hasOwnProperty('options')){wo=table.config.widgetOptions=$.extend(true,{},w.options,wo);c.widgetInit[w.id]=true;}
if(w.hasOwnProperty('init')){w.init(table,w,c,wo);}}
if(!init&&w.hasOwnProperty('format')){w.format(table,c,wo,false);}}});}
if(c.debug){w=c.widgets.length;benchmark("Completed "+(init===true?"initializing ":"applying ")+w+" widget"+(w!==1?"s":""),time);}};ts.refreshWidgets=function(table,doAll,dontapply){table=$(table)[0];var i,c=table.config,cw=c.widgets,w=ts.widgets,l=w.length;for(i=0;i<l;i++){if(w[i]&&w[i].id&&(doAll||$.inArray(w[i].id,cw)<0)){if(c.debug){log('Refeshing widgets: Removing '+w[i].id);}
if(w[i].hasOwnProperty('remove')){w[i].remove(table,c,c.widgetOptions);c.widgetInit[w[i].id]=false;}}}
if(dontapply!==true){ts.applyWidget(table,doAll);}};ts.getData=function(h,ch,key){var val='',$h=$(h),m,cl;if(!$h.length){return'';}
m=$.metadata?$h.metadata():false;cl=' '+($h.attr('class')||'');if(typeof $h.data(key)!=='undefined'||typeof $h.data(key.toLowerCase())!=='undefined'){val+=$h.data(key)||$h.data(key.toLowerCase());}else if(m&&typeof m[key]!=='undefined'){val+=m[key];}else if(ch&&typeof ch[key]!=='undefined'){val+=ch[key];}else if(cl!==' '&&cl.match(' '+key+'-')){val=cl.match(new RegExp('\\s'+key+'-([\\w-]+)'))[1]||'';}
return $.trim(val);};ts.formatFloat=function(s,table){if(typeof s!=='string'||s===''){return s;}
var i,t=table&&table.config?table.config.usNumberFormat!==false:typeof table!=="undefined"?table:true;if(t){s=s.replace(/,/g,'');}else{s=s.replace(/[\s|\.]/g,'').replace(/,/g,'.');}
if(/^\s*\([.\d]+\)/.test(s)){s=s.replace(/^\s*\(([.\d]+)\)/,'-$1');}
i=parseFloat(s);return isNaN(i)?$.trim(s):i;};ts.isDigit=function(s){return isNaN(s)?(/^[\-+(]?\d+[)]?$/).test(s.toString().replace(/[,.'"\s]/g,'')):true;};}()});var ts=$.tablesorter;$.fn.extend({tablesorter:ts.construct});ts.addParser({id:"text",is:function(){return true;},format:function(s,table){var c=table.config;if(s){s=$.trim(c.ignoreCase?s.toLocaleLowerCase():s);s=c.sortLocaleCompare?ts.replaceAccents(s):s;}
return s;},type:"text"});ts.addParser({id:"digit",is:function(s){return ts.isDigit(s);},format:function(s,table){var n=ts.formatFloat((s||'').replace(/[^\w,. \-()]/g,""),table);return s&&typeof n==='number'?n:s?$.trim(s&&table.config.ignoreCase?s.toLocaleLowerCase():s):s;},type:"numeric"});ts.addParser({id:"currency",is:function(s){return(/^\(?\d+[\u00a3$\u20ac\u00a4\u00a5\u00a2?.]|[\u00a3$\u20ac\u00a4\u00a5\u00a2?.]\d+\)?$/).test((s||'').replace(/[,. ]/g,''));},format:function(s,table){var n=ts.formatFloat((s||'').replace(/[^\w,. \-()]/g,""),table);return s&&typeof n==='number'?n:s?$.trim(s&&table.config.ignoreCase?s.toLocaleLowerCase():s):s;},type:"numeric"});ts.addParser({id:"ipAddress",is:function(s){return(/^\d{1,3}[\.]\d{1,3}[\.]\d{1,3}[\.]\d{1,3}$/).test(s);},format:function(s,table){var i,a=s?s.split("."):'',r="",l=a.length;for(i=0;i<l;i++){r+=("00"+a[i]).slice(-3);}
return s?ts.formatFloat(r,table):s;},type:"numeric"});ts.addParser({id:"url",is:function(s){return(/^(https?|ftp|file):\/\//).test(s);},format:function(s){return s?$.trim(s.replace(/(https?|ftp|file):\/\//,'')):s;},type:"text"});ts.addParser({id:"isoDate",is:function(s){return(/^\d{4}[\/\-]\d{1,2}[\/\-]\d{1,2}/).test(s);},format:function(s,table){return s?ts.formatFloat((s!=="")?(new Date(s.replace(/-/g,"/")).getTime()||""):"",table):s;},type:"numeric"});ts.addParser({id:"percent",is:function(s){return(/(\d\s*?%|%\s*?\d)/).test(s)&&s.length<15;},format:function(s,table){return s?ts.formatFloat(s.replace(/%/g,""),table):s;},type:"numeric"});ts.addParser({id:"usLongDate",is:function(s){return(/^[A-Z]{3,10}\.?\s+\d{1,2},?\s+(\d{4})(\s+\d{1,2}:\d{2}(:\d{2})?(\s+[AP]M)?)?$/i).test(s)||(/^\d{1,2}\s+[A-Z]{3,10}\s+\d{4}/i).test(s);},format:function(s,table){return s?ts.formatFloat((new Date(s.replace(/(\S)([AP]M)$/i,"$1 $2")).getTime()||''),table):s;},type:"numeric"});ts.addParser({id:"shortDate",is:function(s){return(/(^\d{1,2}[\/\s]\d{1,2}[\/\s]\d{4})|(^\d{4}[\/\s]\d{1,2}[\/\s]\d{1,2})/).test((s||'').replace(/\s+/g," ").replace(/[\-.,]/g,"/"));},format:function(s,table,cell,cellIndex){if(s){var c=table.config,ci=c.headerList[cellIndex],format=ci.dateFormat||ts.getData(ci,c.headers[cellIndex],'dateFormat')||c.dateFormat;s=s.replace(/\s+/g," ").replace(/[\-.,]/g,"/");if(format==="mmddyyyy"){s=s.replace(/(\d{1,2})[\/\s](\d{1,2})[\/\s](\d{4})/,"$3/$1/$2");}else if(format==="ddmmyyyy"){s=s.replace(/(\d{1,2})[\/\s](\d{1,2})[\/\s](\d{4})/,"$3/$2/$1");}else if(format==="yyyymmdd"){s=s.replace(/(\d{4})[\/\s](\d{1,2})[\/\s](\d{1,2})/,"$1/$2/$3");}}
return s?ts.formatFloat((new Date(s).getTime()||''),table):s;},type:"numeric"});ts.addParser({id:"time",is:function(s){return(/^(([0-2]?\d:[0-5]\d)|([0-1]?\d:[0-5]\d\s?([AP]M)))$/i).test(s);},format:function(s,table){return s?ts.formatFloat((new Date("2000/01/01 "+s.replace(/(\S)([AP]M)$/i,"$1 $2")).getTime()||""),table):s;},type:"numeric"});ts.addParser({id:"metadata",is:function(){return false;},format:function(s,table,cell){var c=table.config,p=(!c.parserMetadataName)?'sortValue':c.parserMetadataName;return $(cell).metadata()[p];},type:"numeric"});ts.addWidget({id:"zebra",priority:90,format:function(table,c,wo){var $tb,$tv,$tr,row,even,time,k,l,child=new RegExp(c.cssChildRow,'i'),b=c.$tbodies;if(c.debug){time=new Date();}
for(k=0;k<b.length;k++){$tb=b.eq(k);l=$tb.children('tr').length;if(l>1){row=0;$tv=$tb.children('tr:visible');$tv.each(function(){$tr=$(this);if(!child.test(this.className)){row++;}
even=(row%2===0);$tr.removeClass(wo.zebra[even?1:0]).addClass(wo.zebra[even?0:1]);});}}
if(c.debug){ts.benchmark("Applying Zebra widget",time);}},remove:function(table,c,wo){var k,$tb,b=c.$tbodies,rmv=(wo.zebra||["even","odd"]).join(' ');for(k=0;k<b.length;k++){$tb=$.tablesorter.processTbody(table,b.eq(k),true);$tb.children().removeClass(rmv);$.tablesorter.processTbody(table,$tb,false);}}});})(jQuery);