<?php

/** 
 * This file is part of the Froxlor project.
 * Copyright (c) 2003-2009 the SysCP Team (see authors).
 * Copyright (c) 2010 the Froxlor Team (see authors).
 *
 * For the full copyright and license information, please view the COPYING
 * file that was distributed with this source code. You can also view the
 * COPYING file online at http://files.froxlor.org/misc/COPYING.txt
 *
 * @copyright  (c) the authors
 * @author     Staffan Starberg <staff@starberg.com>
 * @author     Froxlor Team <team@froxlor.org>
 * @license    GPLv2 http://files.froxlor.org/misc/COPYING.txt
 * @package    Language
 * @version    $Id: swedish.lng.php 105 2010-01-25 09:11:52Z EleRas $
 */

/**
 * Global
 */

$lng['translator'] = 'Staffan Starberg';
$lng['panel']['edit'] = 'ndra';
$lng['panel']['delete'] = 'Radera';
$lng['panel']['create'] = 'Skapa';
$lng['panel']['save'] = 'Spara';
$lng['panel']['yes'] = 'Ja';
$lng['panel']['no'] = 'Nej';
$lng['panel']['emptyfornochanges'] = 'Tomt flt = ingen ndring';
$lng['panel']['emptyfordefault'] = 'Frvalt vrde anvnds om fltet lmnas tommt';
$lng['panel']['path'] = 'Skvg (Path)';
$lng['panel']['toggle'] = 'Vxla (Toggle)';
$lng['panel']['next'] = 'nsta';
$lng['panel']['dirsmissing'] = 'Kan inte hitta eller lsa katalogen!';

/**
 * Login
 */

$lng['login']['username'] = 'Anvndarnamn';
$lng['login']['password'] = 'Lsenord';
$lng['login']['language'] = 'Sprk';
$lng['login']['login'] = 'Logga in';
$lng['login']['logout'] = 'Logga ut';
$lng['login']['profile_lng'] = 'Profilsprk';

/**
 * Customer
 */

$lng['customer']['documentroot'] = 'Hemkatalog';
$lng['customer']['name'] = 'Efternamn';
$lng['customer']['firstname'] = 'Frnamn';
$lng['customer']['company'] = 'Fretag';
$lng['customer']['street'] = 'Postadress';
$lng['customer']['zipcode'] = 'Postnummer';
$lng['customer']['city'] = 'Postort';
$lng['customer']['phone'] = 'Telefon';
$lng['customer']['fax'] = 'Fax';
$lng['customer']['email'] = 'E-post';
$lng['customer']['customernumber'] = 'Kundnummer';
$lng['customer']['diskspace'] = 'Webb (MB)';
$lng['customer']['traffic'] = 'Trafik (GB)';
$lng['customer']['mysqls'] = 'SQL_DBas';
$lng['customer']['emails'] = 'E-post_adresser';
$lng['customer']['accounts'] = 'E-post_konton';
$lng['customer']['forwarders'] = 'E-post_skicka_vidare';
$lng['customer']['ftps'] = 'FTP_Kto';
$lng['customer']['subdomains'] = 'Sub-Domner';
$lng['customer']['domains'] = 'Domner';
$lng['customer']['unlimited'] = 'Obegrnsad';

/**
 * Customermenue
 */

$lng['menue']['main']['main'] = 'Huvudsidan';
$lng['menue']['main']['changepassword'] = 'ndra lsenord';
$lng['menue']['main']['changelanguage'] = 'ndra sprk';
$lng['menue']['email']['email'] = 'E-post';
$lng['menue']['email']['emails'] = 'E-post';
$lng['menue']['email']['webmail'] = 'WebMail';
$lng['menue']['mysql']['mysql'] = 'MySQL';
$lng['menue']['mysql']['databases'] = 'Databaser';
$lng['menue']['mysql']['phpmyadmin'] = 'phpMyAdmin';
$lng['menue']['domains']['domains'] = 'Domner';
$lng['menue']['domains']['settings'] = 'Instllningar';
$lng['menue']['ftp']['ftp'] = 'FTP';
$lng['menue']['ftp']['accounts'] = 'Konton';
$lng['menue']['ftp']['webftp'] = 'WebFTP';
$lng['menue']['extras']['extras'] = 'Extras';
$lng['menue']['extras']['directoryprotection'] = 'Katalog skerhet';
$lng['menue']['extras']['pathoptions'] = 'Instllningar skvg';

/**
 * Index
 */

$lng['index']['customerdetails'] = 'Kunddetaljer';
$lng['index']['accountdetails'] = 'Kontodetaljer';

/**
 * Change Password
 */

$lng['changepassword']['old_password'] = 'Gammalt lsenord';
$lng['changepassword']['new_password'] = 'Nytt lsenord';
$lng['changepassword']['new_password_confirm'] = 'Nytt lsenord (verifiera)';
$lng['changepassword']['new_password_ifnotempty'] = 'Nytt lsenord (Tomt fltet = inga ndringar)';
$lng['changepassword']['also_change_ftp'] = ' ndra ven lsenord fr huvud FTP kontot';

/**
 * Domains
 */

$lng['domains']['description'] = 'Hr kan du skapa (sub-)domner och ndra i dem.<br />Systemet behver dock lite tid p sig att genomfra ndringarna.';
$lng['domains']['domainsettings'] = 'Domninstllningar';
$lng['domains']['domainname'] = 'Domnnamn';
$lng['domains']['subdomain_add'] = '[Skapa en ny subdomn]';
$lng['domains']['subdomain_edit'] = 'ndra (sub)domn';
$lng['domains']['wildcarddomain'] = 'Skapa som ospecificerad domn (Create as wildcarddomain?)';
$lng['domains']['aliasdomain'] = 'Alias for domn';
$lng['domains']['noaliasdomain'] = '(inget alias)';

/**
 * E-mails
 */

$lng['emails']['description'] = 'Hr kan du skapa eller ndra dina E-postadresser.<br />Ett konto r som en brevlda utanfr huset. Om ngon skickar dig E-post kommer det att hamna i din brevlda (ditt konto).<br /><br />Fr att hmta din E-post s skall du anvnda fljande instllningar i ditt E-postprogram: (Text i kursiv stil <i>italics</i> mste ndras till det som motsvaras av det du knappade in tidigare!)<br />Servernamn (Hostname): <b><i>Domnnamn (Domainname)</i></b><br />Anvndarnamn (Username): <b><i>Konto namn (Account name) / E-postadress</i></b><br />Lsenord (Password): <b><i>lsenordet som du valde</i></b>';
$lng['emails']['emailaddress'] = 'E-postadress';
$lng['emails']['emails_add'] = '[Skapa en E-postadress]';
$lng['emails']['emails_edit'] = 'ndra E-postadressen';
$lng['emails']['catchall'] = 'Maildump';
$lng['emails']['iscatchall'] = 'Skapa en maildump?';
$lng['emails']['account'] = 'Konto';
$lng['emails']['account_add'] = 'Skapa konto';
$lng['emails']['account_delete'] = 'Radera konto';
$lng['emails']['from'] = 'Frn';
$lng['emails']['to'] = 'Till';
$lng['emails']['forwarders'] = 'Skicka vidare:';
$lng['emails']['forwarder_add'] = '[Skapa ny "skicka vidare"]';

/**
 * FTP
 */

$lng['ftp']['description'] = 'Hr kan du skapa eller nra i dina FTP konton.<br />ndringen genomfrs omedelbart s man kan anvnda det nya/ndrade kontot direkt.';
$lng['ftp']['account_add'] = '[Skapa ett nytt FTP konto]';

/**
 * MySQL
 */

$lng['mysql']['databasename'] = 'Anvndare/databasnamn';
$lng['mysql']['databasedescription'] = 'Beskrivning av databasen';
$lng['mysql']['database_create'] = '[Skapa en ny databas]';

/**
 * Extras
 */

$lng['extras']['description'] = 'Hr kan du ndra vriga saker ssom katalogskydd mm.<br />Systemet behver dock lite tid p sig att genomfra ndringarna.';
$lng['extras']['directoryprotection_add'] = '[Skapa ett nytt katalogskydd]';
$lng['extras']['view_directory'] = 'Visa kataloginnehll';
$lng['extras']['pathoptions_add'] = '[Skapa ny regel fr skvgar]';
$lng['extras']['directory_browsing'] = 'Visning av katalogstruktur';
$lng['extras']['pathoptions_edit'] = 'ndra skvgsinstllningar';
$lng['extras']['error404path'] = '404';
$lng['extras']['error403path'] = '403';
$lng['extras']['error500path'] = '500';
$lng['extras']['error401path'] = '401';
$lng['extras']['errordocument404path'] = 'URL to ErrorDocument 404';
$lng['extras']['errordocument403path'] = 'URL to ErrorDocument 403';
$lng['extras']['errordocument500path'] = 'URL to ErrorDocument 500';
$lng['extras']['errordocument401path'] = 'URL to ErrorDocument 401';

/**
 * Errors
 */

$lng['error']['error'] = 'Fljande fel har uppsttt';
$lng['error']['directorymustexist'] = 'Katalogen %s mste finnas. Skapa den med ditt FTP program.';
$lng['error']['filemustexist'] = 'Filen %s mste existera.';
$lng['error']['allresourcesused'] = 'Du har redan skapt s mnga konton som du har tillstnd till.';
$lng['error']['domains_cantdeletemaindomain'] = 'Du kan inte radera en domn som anvndes fr E-post.';
$lng['error']['domains_canteditdomain'] = 'Endast administratrer kan ndra denna domn.';
$lng['error']['domains_cantdeletedomainwithemail'] = 'Du kan inte radera en domn som anvndes fr E-post. Radera alla E-postadresser frst';
$lng['error']['firstdeleteallsubdomains'] = 'Du mste radera alla sub-domner innan du kan skapa en maildump (wildcard domain).';
$lng['error']['youhavealreadyacatchallforthisdomain'] = 'Du har redan skapat en maildump fr denna domn.';
$lng['error']['ftp_cantdeletemainaccount'] = 'Det gr inte att radera huvud FTP kontot fr domnen';
$lng['error']['login'] = 'Anvndarnamnet eller lsenordet var felaktigt, frsk igen!';
$lng['error']['login_blocked'] = 'Kontot har blivit avstngt p grund av fr mnga felaktiga inloggningsfrsk. <br />Frsk igen om ' . $settings['login']['deactivatetime'] . ' sekunder.';
$lng['error']['notallreqfieldsorerrors'] = 'Du har inte fyllt i alla flt eller s har du skrivit in ngot som inte accepteras.';
$lng['error']['oldpasswordnotcorrect'] = 'Det gamla lsenordet r fel.';
$lng['error']['youcantallocatemorethanyouhave'] = 'Du kan inte skapa fler resurser n du ger sjlv (You cannot allocate more resources than you own for yourself).';
$lng['error']['mustbeurl'] = 'Du har inte skrivit in en korrekt url (e.g. http://somedomain.com/error404.htm)';
$lng['error']['invalidpath'] = 'Du har inte valt en korrekt url (Kanske har du lagt till en katalogskerhet s att katalogerna inte kan visas?)';
$lng['error']['stringisempty'] = 'Du mste skriva in ngot i fltet';
$lng['error']['stringiswrong'] = 'Fel inatningsflt';
$lng['error']['myloginname'] = '\'' . $lng['login']['username'] . '\'';
$lng['error']['mypassword'] = '\'' . $lng['login']['password'] . '\'';
$lng['error']['oldpassword'] = '\'' . $lng['changepassword']['old_password'] . '\'';
$lng['error']['newpassword'] = '\'' . $lng['changepassword']['new_password'] . '\'';
$lng['error']['newpasswordconfirm'] = '\'' . $lng['changepassword']['new_password_confirm'] . '\'';
$lng['error']['newpasswordconfirmerror'] = 'New password and confirmation does not match';
$lng['error']['myname'] = '\'' . $lng['customer']['name'] . '\'';
$lng['error']['myfirstname'] = '\'' . $lng['customer']['firstname'] . '\'';
$lng['error']['emailadd'] = '\'' . $lng['customer']['email'] . '\'';
$lng['error']['mydomain'] = '\'Domain\'';
$lng['error']['mydocumentroot'] = '\'Documentroot\'';
$lng['error']['loginnameexists'] = 'Login-Name %s r upptaget';
$lng['error']['emailiswrong'] = 'E-post-Adressen "%s" innehller ogiltiga tecken eller s r den inte komplett';
$lng['error']['loginnameiswrong'] = 'Login-Namnet %s innehller ogiltiga tecken';
$lng['error']['userpathcombinationdupe'] = 'Anvndarnamnet och skvgen tillsammans finns redan';
$lng['error']['patherror'] = 'Generellt Fel! skvgen till katalogen kan inte vara tom';
$lng['error']['errordocpathdupe'] = 'Option fr skvgen %s finns redan';
$lng['error']['adduserfirst'] = 'Skapa anvndaren frst';
$lng['error']['domainalreadyexists'] = 'Domnen %s gs redan av en kund';
$lng['error']['nolanguageselect'] = 'Inget sprk r valt.';
$lng['error']['nosubjectcreate'] = 'Du mste ha ett rubrik fr denna E-postmall.';
$lng['error']['nomailbodycreate'] = 'Du mste ha skrivit in en E-post text fr denna mall.';
$lng['error']['templatenotfound'] = 'E-postmallen hittades inte.';
$lng['error']['alltemplatesdefined'] = 'Du kan inte skapa flera mallar, alla sprk finns redan.';
$lng['error']['wwwnotallowed'] = 'www r inte tilltet att anvnda fr subdomner.';
$lng['error']['subdomainiswrong'] = 'Subdomnen %s innehller ogiltiga tecken.';
$lng['error']['domaincantbeempty'] = 'Fltet fr domnnamn fr inte vara tommt.';
$lng['error']['domainexistalready'] = 'Domnen %s finns redan.';
$lng['error']['domainisaliasorothercustomer'] = 'Den valda domnen r antingen en aliasdomn eller s gs den redan av en annan kund.';
$lng['error']['emailexistalready'] = 'E-postadressen %s finns redan.';
$lng['error']['maindomainnonexist'] = 'Huvuddomnen %s finns inte.';
$lng['error']['destinationnonexist'] = 'Skapa en forwarder i fltet \'Destination\'.';
$lng['error']['destinationalreadyexistasmail'] = 'Denna forwarder %s, finns redan som aktiv E-postadress.';
$lng['error']['destinationalreadyexist'] = 'Du har redan skapat en forwarder till %s .';
$lng['error']['destinationiswrong'] = 'Denna forwarder: %s innehller ogiltiga tecken eller s r den inte komplett adress.';
$lng['error']['domainname'] = $lng['domains']['domainname'];

/**
 * Questions
 */

$lng['question']['question'] = 'Skerhetsfrga';
$lng['question']['admin_customer_reallydelete'] = 'r du sker p att du vill radera kunden %s? Om du vljer att radera gr det inte att ngra sig eftert!';
$lng['question']['admin_domain_reallydelete'] = 'r du riktigt sker p att du vill radera domnen %s?';
$lng['question']['admin_domain_reallydisablesecuritysetting'] = 'r du riktigt sker p att du vill avaktivera skerhetsinstllningarna (OpenBasedir and/or SafeMode)?';
$lng['question']['admin_admin_reallydelete'] = 'r du riktigt sker p att du vill radera adminkontot %s? Alla kunder och domner kommer att flyttas till ditt konto istllet.';
$lng['question']['admin_template_reallydelete'] = 'r du riktigt sker p att du vill radera mallen \'%s\'?';
$lng['question']['domains_reallydelete'] = 'r du riktigt sker p att du vill radera domnen %s?';
$lng['question']['email_reallydelete'] = 'r du riktigt sker p att du vill radera E-postadressen %s?';
$lng['question']['email_reallydelete_account'] = 'r du riktigt sker p att du vill radera E-postkontot %s?';
$lng['question']['email_reallydelete_forwarder'] = 'r du riktigt sker p att du vill radera forwardern till %s?';
$lng['question']['extras_reallydelete'] = 'r du riktigt sker p att du vill radera katalogskerheten (directory protection) fr %s?';
$lng['question']['extras_reallydelete_pathoptions'] = 'r du riktigt sker p att du vill radera katalogalternativen (path options) fr %s?';
$lng['question']['ftp_reallydelete'] = 'r du riktigt sker p att du vill radera FTP kontot %s?';
$lng['question']['mysql_reallydelete'] = 'r du riktigt sker p att du vill radera databasen %s? Om du vljer att radera gr det inte att ngra sig eftert!';
$lng['question']['admin_configs_reallyrebuild'] = 'r du riktigt sker p att du vill skapa nya konfigurationsfiler fr apache och bind?';

/**
 * Mails
 */

$lng['mails']['pop_success']['mailbody'] = 'Hej,\n\nDitt E-postkonto {EMAIL}\nhar nu skapats.\n\nDetta r ett automatgenererat E-post meddelande\n, Det gr drfr inte att svara p detta meddelande!\n';
$lng['mails']['pop_success']['subject'] = 'E-postkontot r nu skapat';
$lng['mails']['createcustomer']['mailbody'] = 'Hej {FIRSTNAME} {NAME},\n\nHr kommer kontoinformationen fr ditt konto:\n\nAnvndarnamn (Username): {USERNAME}\nLsenord (Password): {PASSWORD}\n\n';
$lng['mails']['createcustomer']['subject'] = 'Kontoinformation';

/**
 * Admin
 */

$lng['admin']['overview'] = 'versikt';
$lng['admin']['ressourcedetails'] = 'Anvnda resurser';
$lng['admin']['systemdetails'] = 'System Detaljer';
$lng['admin']['froxlordetails'] = 'Froxlor Detaljer';
$lng['admin']['installedversion'] = 'Installerad version av Froxlor';
$lng['admin']['latestversion'] = 'Senaste version av Froxlor';
$lng['admin']['lookfornewversion']['clickhere'] = '[Sk senaste verison av Froxlor via Internet]';
$lng['admin']['lookfornewversion']['error'] = 'Fel vid lsning, kontrollera uppkopplingen mot Froxlor';
$lng['admin']['resources'] = 'Resurser';
$lng['admin']['customer'] = 'Kunder';
$lng['admin']['customers'] = 'Kunder';
$lng['admin']['customer_add'] = '[Skapa en ny kund]';
$lng['admin']['customer_edit'] = 'ndra ny kund';
$lng['admin']['domains'] = 'Domner';
$lng['admin']['domain_add'] = '[Skapa en ny domn]';
$lng['admin']['domain_edit'] = 'Tillt ndring av domnen';
$lng['admin']['subdomainforemail'] = 'Sub-domn som E-postdomn (Subdomains as emaildomains)';
$lng['admin']['admin'] = 'Admin';
$lng['admin']['admins'] = 'Admins';
$lng['admin']['admin_add'] = '[Skapa en ny admin]';
$lng['admin']['admin_edit'] = 'ndra admin';
$lng['admin']['customers_see_all'] = 'Kan se alla kunder?';
$lng['admin']['domains_see_all'] = 'Kan se alla domner?';
$lng['admin']['change_serversettings'] = 'Kan ndra serverinstllningar?';
$lng['admin']['server'] = 'Server';
$lng['admin']['serversettings'] = 'Instllningar';
$lng['admin']['rebuildconf'] = 'Uppdatera konfig filer';
$lng['admin']['stdsubdomain'] = 'Standard subdomn';
$lng['admin']['stdsubdomain_add'] = '[Skapa en ny standard subdomn]';
$lng['admin']['phpenabled'] = 'PHP pslagen';
$lng['admin']['deactivated'] = 'Inaktiv';
$lng['admin']['deactivated_user'] = 'Avaktivera anvndare';
$lng['admin']['sendpassword'] = 'Skicka lsenord';
$lng['admin']['ownvhostsettings'] = 'Egna vHost-Instllningar';
$lng['admin']['configfiles']['serverconfiguration'] = 'Konfiguration';
$lng['admin']['configfiles']['files'] = '<b>Konfigurationsfiler:</b> ndra eller skapa fljande filer med<br />fljande innehll om de inte finns redan.<br /><b>Notera:</b> MySQL-lsenordet har inte ndrats p grund av skerhetsskl.<br />Du mste sjlv ndra lsenordet &quot;MYSQL_PASSWORD&quot; p egen hand. Om du glmt bort ditt MySQL-password<br />s kan du hitta det hr &quot;lib/userdata.inc.php&quot;.';
$lng['admin']['configfiles']['commands'] = '<b>Kommandon:</b> Kr fljande kommandon i ett terminalfnster.';
$lng['admin']['configfiles']['restart'] = '<b>Omstart:</b> Kr fljande kommandon i ett terminalfnster fr att ladda in den nya konfigurationen.';
$lng['admin']['templates']['templates'] = 'Mallar';
$lng['admin']['templates']['template_add'] = '[Lgg till en ny mall]';
$lng['admin']['templates']['template_edit'] = 'ndra en befintlig mall';
$lng['admin']['templates']['action'] = 'Action';
$lng['admin']['templates']['email'] = 'E-Post';
$lng['admin']['templates']['subject'] = 'Rubrik (subjekt)';
$lng['admin']['templates']['mailbody'] = 'E-Postinnehll (Mail body)';
$lng['admin']['templates']['createcustomer'] = 'E-Post till nya kunder (Vlkommen)';
$lng['admin']['templates']['pop_success'] = 'E-Post fr nya konton (Vlkommen)';
$lng['admin']['templates']['template_replace_vars'] = 'Variabler som kan ndras i mallen:';
$lng['admin']['templates']['FIRSTNAME'] = 'ndra till kundens frnamn.';
$lng['admin']['templates']['NAME'] = 'ndra till kundens efternamn.';
$lng['admin']['templates']['USERNAME'] = 'ndra till kundens kontonamns anvndarnamn.';
$lng['admin']['templates']['PASSWORD'] = 'ndra till kundens kontonamns lsenord.';
$lng['admin']['templates']['EMAIL'] = 'ndra till adressen fr POP3/IMAP kontot.';

/**
 * Serversettings
 */

$lng['serversettings']['session_timeout']['title'] = 'Sessionen har avslutats fr att den tog fr lng tid att utfra (session Timeout)';
$lng['serversettings']['session_timeout']['description'] = 'Tiden (i sekunder) som anvndaren fr vara inaktiv innan han mste logga in igen r (seconds)?';
$lng['serversettings']['accountprefix']['title'] = 'Kund ID (Customer prefix)';
$lng['serversettings']['accountprefix']['description'] = 'Vilket prefix skall anvndas till ett kundkonto?';
$lng['serversettings']['mysqlprefix']['title'] = 'SQL ID (SQL Prefix)';
$lng['serversettings']['mysqlprefix']['description'] = 'Vilket prefix skall anvndas till mysql?';
$lng['serversettings']['ftpprefix']['title'] = 'FTP ID (FTP Prefix)';
$lng['serversettings']['ftpprefix']['description'] = 'Vilket prefix skall anvndas till ftp?';
$lng['serversettings']['documentroot_prefix']['title'] = 'Hemkatalog';
$lng['serversettings']['documentroot_prefix']['description'] = 'Vilken skvg skall det vara till hemkatalogen?';
$lng['serversettings']['logfiles_directory']['title'] = 'Loggfilernas hemkatalog (Logfiles directory)';
$lng['serversettings']['logfiles_directory']['description'] = 'Vilken skvg skall det vara till loggfilernas hemkatalog?';
$lng['serversettings']['ipaddress']['title'] = 'IP-Adress';
$lng['serversettings']['ipaddress']['description'] = 'Vilken IP-adress har denna server?';
$lng['serversettings']['hostname']['title'] = 'Datornamn (Hostname)';
$lng['serversettings']['hostname']['description'] = 'Villket Datornamn (Hostname) har denna server?';
$lng['serversettings']['apachereload_command']['title'] = 'Ladda om Apache kommandot (Apache reload)';
$lng['serversettings']['apachereload_command']['description'] = 'Ange skvgen till programmet som laddar om Apache (reload apache) konfigurationsfiler?';
$lng['serversettings']['bindconf_directory']['title'] = 'Bind konfigurationskatalog (Bind config directory)';
$lng['serversettings']['bindconf_directory']['description'] = 'Vilken skvg skall det vara till bind:s konfigurationsfiler?';
$lng['serversettings']['bindreload_command']['title'] = 'Ange skvgen till programmet som laddar om Bind (reload bind) konfigurationsfiler?';
$lng['serversettings']['bindreload_command']['description'] = 'Ange skvgen till programmet som laddar om Bind (reload bind) konfigurationsfiler?';
$lng['serversettings']['binddefaultzone']['title'] = 'Bind standard zone';
$lng['serversettings']['binddefaultzone']['description'] = 'Vad r namnet p standard zonen?';
$lng['serversettings']['vmail_uid']['title'] = 'Mails-UID';
$lng['serversettings']['vmail_uid']['description'] = 'Vilket anvndarID (UserID) ska E-posten ha?';
$lng['serversettings']['vmail_gid']['title'] = 'Mails-GID';
$lng['serversettings']['vmail_gid']['description'] = 'Vilket gruppID (GroupID) ska E-posten ha?';
$lng['serversettings']['vmail_homedir']['title'] = 'E-post hemkatalog';
$lng['serversettings']['vmail_homedir']['description'] = 'I vilken katalog skall E-posten sparas?';
$lng['serversettings']['adminmail']['title'] = 'Avsndare';
$lng['serversettings']['adminmail']['description'] = 'Vilken avsndaradress skall E-post frn admin panelen ha?';
$lng['serversettings']['phpmyadmin_url']['title'] = 'phpMyAdmin URL';
$lng['serversettings']['phpmyadmin_url']['description'] = 'Vilken URL r det till phpMyAdmin? (Mste brja med http(s)://)';
$lng['serversettings']['webmail_url']['title'] = 'WebMail URL';
$lng['serversettings']['webmail_url']['description'] = 'Vilken URL r det till WebMail? (Mste brja med http(s)://)';
$lng['serversettings']['webftp_url']['title'] = 'WebFTP URL';
$lng['serversettings']['webftp_url']['description'] = 'Vilken URL r det till  WebFTP? (Mste brja med http(s)://)';
$lng['serversettings']['language']['description'] = 'Vilket sprk skall anvndas som standardsprk?';
$lng['serversettings']['maxloginattempts']['title'] = 'Max antal Login frsk';
$lng['serversettings']['maxloginattempts']['description'] = 'Maximalt antal inloggningsfrsk innan kontot stngs av.';
$lng['serversettings']['deactivatetime']['title'] = 'Avstngningstid';
$lng['serversettings']['deactivatetime']['description'] = 'Tid (sec.) som kontot stngs av efter fr mnga felaktiga frsk.';
$lng['serversettings']['pathedit']['title'] = 'Typ av (path input)';
$lng['serversettings']['pathedit']['description'] = 'Skall en skvg vljas i en rullist eller matas in fr hand?';
$lng['serversettings']['nameservers']['title'] = 'Nameservers';
$lng['serversettings']['nameservers']['description'] = 'En kommaseparerad lista med namnet (hostname) p alla DNS:er. Den frsta blir den frsta som sks (primary).';
$lng['serversettings']['mxservers']['title'] = 'MX servers';
$lng['serversettings']['mxservers']['description'] = 'En kommaseparerad lista med nummer och namn separerade men mellanslag (ex. \'10 mx.example.com\') innehller mx servrarna.';

/**
 * CHANGED BETWEEN 1.2.12 and 1.2.13
 */

$lng['mysql']['description'] = 'Hr ndras eller skapas MySQL-Databaser.<br />ndringen sker omedelbart och databasen kan anvndas direkt.<br />I menyn p vnster sida finns verktyget phpMyAdmin med vilket man enkelt kan ndra i sin databas.<br /><br />Fr att anvnda databasen i dina egna php-scripts anvnd fljande instllningar: (Data med kursiv stil <i>italics</i> mste ndras till det du matat in!)<br />Servernamn (Hostname): <b><SQL_HOST></b><br />Anvndarnamn (Username): <b><i>Databsnamn (Databasename)</i></b><br />Lsenord (Password): <b><i>Lsenordet som du har valt</i></b><br />Databas (Database): <b><i>Databasnamn (Databasename)</i></b>';

/**
 * ADDED BETWEEN 1.2.12 and 1.2.13
 */

$lng['admin']['cronlastrun'] = 'Konfigurerinsfilerna skapades sist';
$lng['serversettings']['paging']['title'] = 'Antal rader per sida';
$lng['serversettings']['paging']['description'] = 'Hur mnga rader skall det vara p en sida? (0 = Stng av sidbrytning)';
$lng['error']['ipstillhasdomains'] = 'IP/Port kombinationen som du vill radera har fortfarande domner anslutna till sig, Flytta dessa till ngon annan IP/Port kombination innan du raderar denna IP/Port kombination.';
$lng['error']['cantdeletedefaultip'] = 'Det gr inte att ta bort den frvalda terfrsljarens IP/Port kombination, Vlj en annan IP/Port kombination som frval fr terfrsljare innan du raderar denna IP/Port kombination.';
$lng['error']['cantdeletesystemip'] = 'Det gr inte att radera den sista system IP:n, Antingen skapar man en ny IP/Port kombination fr system IP eller s ndrar man system IP:n.';
$lng['error']['myipaddress'] = '\'IP\'';
$lng['error']['myport'] = '\'Port\'';
$lng['error']['myipdefault'] = 'Man mste vlja en IP/Port kombination som skall bli standardvrdet.';
$lng['error']['myipnotdouble'] = 'Denna IP/Port kombination finns redan.';
$lng['question']['admin_ip_reallydelete'] = 'r du sker p att du vill radera IP addressen %s?';
$lng['admin']['ipsandports']['ipsandports'] = 'IPs and Ports';
$lng['admin']['ipsandports']['add'] = '[Lgg till IP/Port]';
$lng['admin']['ipsandports']['edit'] = 'ndra IP/Port';
$lng['admin']['ipsandports']['ipandport'] = 'IP/Port';
$lng['admin']['ipsandports']['ip'] = 'IP';
$lng['admin']['ipsandports']['port'] = 'Port';

// ADDED IN 1.2.13-rc3

$lng['error']['cantchangesystemip'] = 'Man kan inte ndra den senaste system IP-adressen. Skapa en helt ny IP/Port kombination fr system IP:n eller ndra system IP-adressen.';
$lng['question']['admin_domain_reallydocrootoutofcustomerroot'] = 'Dokumentkatalogen fr denna domn inte kommer att ligga under kundkatalogen, r du sker p att du vill ndra detta?';

// ADDED IN 1.2.14-rc1

$lng['admin']['memorylimitdisabled'] = 'Avstngd';
$lng['domain']['openbasedirpath'] = 'OpenBasedir-path';
$lng['domain']['docroot'] = 'Skvgen frn ovanstende flt';
$lng['domain']['homedir'] = 'Hemkatalog';
$lng['admin']['valuemandatory'] = 'Denna ruta mste fyllas i';
$lng['admin']['valuemandatorycompany'] = 'Fyll i &quot;frnamn&quot; och &quot;efternamn&quot; eller &quot;fretagsnamn&quot;';
$lng['menue']['main']['username'] = 'Inloggad som: ';
$lng['panel']['urloverridespath'] = 'URL (skriver ver skvgen)';
$lng['panel']['pathorurl'] = 'Skvg eller URL';
$lng['error']['sessiontimeoutiswrong'] = 'Bara siffror &quot;Session Timeout&quot; r tilltna.';
$lng['error']['maxloginattemptsiswrong'] = 'Bara siffror &quot;Max Login Attempts&quot; r tilltna.';
$lng['error']['deactivatetimiswrong'] = 'Bara siffror &quot;Deactivate Time&quot; r tilltna.';
$lng['error']['accountprefixiswrong'] = 'Det hr &quot;Customerprefix&quot; r fel.';
$lng['error']['mysqlprefixiswrong'] = 'Det hr &quot;SQL Prefix&quot; r fel.';
$lng['error']['ftpprefixiswrong'] = 'Det hr &quot;FTP Prefix&quot; r fel.';
$lng['error']['ipiswrong'] = 'Den hr &quot;IP-Address&quot; r fel. Endast en giltig IP-adress r tillten.';
$lng['error']['vmailuidiswrong'] = 'Den hr &quot;Mails-uid&quot; r fel. Endast numerisk UID r tilltenis allowed.';
$lng['error']['vmailgidiswrong'] = 'Den hr &quot;Mails-gid&quot; r fel. Endast numerisk GID r tilltenis allowed.';
$lng['error']['adminmailiswrong'] = 'Den hr &quot;Sender-address&quot; r fel. Endast en giltig E-postadress r tillten.';
$lng['error']['pagingiswrong'] = 'Den hr &quot;Entries per Page&quot;-vrdet r fel. Endast siffror r tilltna.';
$lng['error']['phpmyadminiswrong'] = 'Den hr phpMyAdmin-link r inte en giltig lnk.';
$lng['error']['webmailiswrong'] = 'Den hr WebMail-link r inte en giltig lnk.';
$lng['error']['webftpiswrong'] = 'Den hr WebFTP-link r inte en giltig lnk.';
$lng['domains']['hasaliasdomains'] = 'Domnen har redan alias';
$lng['serversettings']['defaultip']['title'] = 'Frvald IP/Port';
$lng['serversettings']['defaultip']['description'] = 'Vilken r den frvalda IP/Port kombinationen?';
$lng['domains']['statstics'] = 'Anvndarstatistik';
$lng['panel']['ascending'] = 'Stigande';
$lng['panel']['decending'] = 'Fallande';
$lng['panel']['search'] = 'Sk';
$lng['panel']['used'] = 'anvnd';

// ADDED IN 1.2.14-rc3

$lng['panel']['translator'] = 'versttare';

// ADDED IN 1.2.14-rc4

$lng['error']['stringformaterror'] = 'Vrdet fr fltet &quot;%s&quot; har inte rtt format.';

// ADDED IN 1.2.15-rc1

$lng['admin']['serversoftware'] = 'Webserver version';
$lng['admin']['phpversion'] = 'PHP-Version';
$lng['admin']['phpmemorylimit'] = 'PHP-Minnesgrns';
$lng['admin']['mysqlserverversion'] = 'MySQL Server Version';
$lng['admin']['mysqlclientversion'] = 'MySQL Klient Version';
$lng['admin']['webserverinterface'] = 'Webserver Interface';
$lng['domains']['isassigneddomain'] = 'Tilldelad domn ';
$lng['serversettings']['phpappendopenbasedir']['title'] = 'Skvg att lgga till OpenBasedir';
$lng['serversettings']['phpappendopenbasedir']['description'] = 'Dessa skvgar (separerade med kolon) kommer att lggas till OpenBasedir-statement i alla  vhost-container.';

// CHANGED IN 1.2.15-rc1

$lng['error']['loginnameissystemaccount'] = 'Det gr inte att skapa ett konto som liknar ett systemkonto (Om det till exempel brjar med &quot;%s&quot;). Vlj ett annat kontonamn.';
$lng['error']['youcantdeleteyourself'] = 'Av skerhetsskl gr inte att redera ditt eget konto.';
$lng['error']['youcanteditallfieldsofyourself'] = 'Notera: Av skerhetsskl gr det inte att ndra ditt eget konto.';

// ADDED IN 1.2.16-svn1

$lng['serversettings']['natsorting']['title'] = 'Anvnd mnsklig sortertering i listvisning';
$lng['serversettings']['natsorting']['description'] = 'Sorterar listan s hr web1 -> web2 -> web11 istllet fr web1 -> web11 -> web2.';

// ADDED IN 1.2.16-svn2

$lng['serversettings']['deactivateddocroot']['title'] = 'Dokumentroot fr avstngda anvndare';
$lng['serversettings']['deactivateddocroot']['description'] = 'Nr en anvndare r avstngd kommer denna skvg att anvndas som dokumentroot. Lmna fltet tommt om du inte vill skapa ngon vhost.';

// ADDED IN 1.2.16-svn4

$lng['panel']['reset'] = 'Avbryt ndringarna';
$lng['admin']['accountsettings'] = 'Kontoinstllningar';
$lng['admin']['panelsettings'] = 'Panelinstllningar';
$lng['admin']['systemsettings'] = 'Systeminstllningar';
$lng['admin']['webserversettings'] = 'Webserverinstllningar';
$lng['admin']['mailserversettings'] = 'E-postserverinstllningar';
$lng['admin']['nameserversettings'] = 'Namnserverinstllningar';
$lng['admin']['updatecounters'] = 'Uppdatera status';
$lng['question']['admin_counters_reallyupdate'] = 'Vill du uppdatera alla statusberkningar fr kunder och admins?';
$lng['panel']['pathDescription'] = 'Katalogen kommer att skapas om den inte redan finns.';

// ADDED IN 1.2.16-svn6

$lng['mails']['trafficninetypercent']['mailbody'] = 'Varning {NAME},\n\nDu har nu anvnt {TRAFFICUSED} MB av ditt tillgngliga {TRAFFIC} MB fr trafik.\nDetta r mer n 90%.\n\nHlsningar, Froxlor team';
$lng['mails']['trafficninetypercent']['subject'] = 'Du r p vg att n din tilltna trafikgrns';
$lng['admin']['templates']['trafficninetypercent'] = 'Meddelande till kund nr mer n nittio procent av trafiken utnyttjas';
$lng['admin']['templates']['TRAFFIC'] = 'Ersatt med trafikbegrnsningen som var tilldelad till kunden.';
$lng['admin']['templates']['TRAFFICUSED'] = 'Ersatt med trafikbegrnsningen som var verskriden av kunden.';

// ADDED IN 1.2.16-svn7

$lng['admin']['subcanemaildomain']['never'] = 'Aldrig';
$lng['admin']['subcanemaildomain']['choosableno'] = 'Valbar, standardvrdet r Nej';
$lng['admin']['subcanemaildomain']['choosableyes'] = 'Valbar, standardvrdet r Ja';
$lng['admin']['subcanemaildomain']['always'] = 'Alltid';
$lng['changepassword']['also_change_webalizer'] = ' ndra ven lsenord fr webalizer statistik';

// ADDED IN 1.2.16-svn8

$lng['serversettings']['mailpwcleartext']['title'] = 'Spara ven lsenord till E-postkonton okrypterade i databassen';
$lng['serversettings']['mailpwcleartext']['description'] = 'Om du valt Ja s kommer alla lsenord att sparas okrypterade (klartext, fullt lsbara fr alla som har rttigheter till databasen) i tabellen mail_users-table. Aktivera detta endast om du r sker p vad du gr!';
$lng['serversettings']['mailpwcleartext']['removelink'] = 'Klicka hr fr att radera alla okrypterade lsenord frn tabellen.';
$lng['question']['admin_cleartextmailpws_reallywipe'] = 'r du sker p att du vill radera alla okrupterade lsenord frn tabellen mail_users? Du kan INTE ndra dig eftert!';
$lng['admin']['configfiles']['overview'] = 'versikt';
$lng['admin']['configfiles']['wizard'] = 'Guide';
$lng['admin']['configfiles']['distribution'] = 'Distribution';
$lng['admin']['configfiles']['service'] = 'Service';
$lng['admin']['configfiles']['daemon'] = 'Daemon';
$lng['admin']['configfiles']['http'] = 'Webserver (HTTP)';
$lng['admin']['configfiles']['dns'] = 'Namnserver (DNS)';
$lng['admin']['configfiles']['mail'] = 'E-postserver (POP3/IMAP)';
$lng['admin']['configfiles']['smtp'] = 'E-postserver (SMTP)';
$lng['admin']['configfiles']['ftp'] = 'FTP-Server';
$lng['admin']['configfiles']['etc'] = 'Others (System)';
$lng['admin']['configfiles']['choosedistribution'] = '-- Choose a distribution --';
$lng['admin']['configfiles']['chooseservice'] = '-- Choose a service --';
$lng['admin']['configfiles']['choosedaemon'] = '-- Choose a daemon --';
$lng['admin']['trafficlastrun'] = 'Senaste trafikberkningen gjordes';

// ADDED IN 1.2.16-svn10

$lng['serversettings']['ftpdomain']['title'] = 'FTP konton @domain';
$lng['serversettings']['ftpdomain']['description'] = 'Kunder kan skapa Ftp accounts user@customerdomain?';
$lng['panel']['back'] = 'Tillbaka';

// ADDED IN 1.2.16-svn12

$lng['serversettings']['mod_log_sql']['title'] = 'Tillflligt spara loggfiler i databasen';
$lng['serversettings']['mod_log_sql']['description'] = 'Anvnd <a href="http://www.outoforder.cc/projects/apache/mod_log_sql/" title="mod_log_sql">mod_log_sql</a> fr att spara webfrgor tillflligt<br /><b>Detta behver en special <a href="http://files.froxlor.org/docs/mod_log_sql/" title="mod_log_sql - documentation">apache-configuration</a>!</b>';
$lng['serversettings']['mod_fcgid']['title'] = 'Inkludera PHP via mod_fcgid/suexec';
$lng['serversettings']['mod_fcgid']['description'] = 'Anvnd mod_fcgid/suexec/libnss_mysql fr att kra PHP med tillhrande anvndarkonto.<br/><b>Denna instllning behver en speciell apache-konfiguration!</b>';
$lng['serversettings']['sendalternativemail']['title'] = 'Anvnd en alternativ E-postadress';
$lng['serversettings']['sendalternativemail']['description'] = 'Skicka lsenord med E-post till adressen under email-account-creation';
$lng['emails']['alternative_emailaddress'] = 'Alternative e-mail-address';
$lng['mails']['pop_success_alternative']['mailbody'] = 'Hej,\n\nditt E-postkonto {EMAIL}\nhar ny skapats.\nDitt lsenord r {PASSWORD}.\n\nDetta r ett automatgenererat E-postmeddelande som det INTE gr att svara p!\n\nLycka till nskar, Froxlor';
$lng['mails']['pop_success_alternative']['subject'] = 'E-postkontot r nu skapat';
$lng['admin']['templates']['pop_success_alternative'] = 'Vlkommstmeddelande fr nya E-post konton som skickas till den alternativa adressen';
$lng['admin']['templates']['EMAIL_PASSWORD'] = 'Ersatt med POP3/IMAP kontots lsenord.';

// ADDED IN 1.2.16-svn13

$lng['error']['documentrootexists'] = 'Katalogen &quot;%s&quot; finns redan hos den hr kunden. Radera detta frst innan kunden skapas igen.';

// ADDED IN 1.2.16-svn14

$lng['serversettings']['apacheconf_vhost']['title'] = 'Apache vhost konfiguration fil/katalognamn';
$lng['serversettings']['apacheconf_vhost']['description'] = 'Var skall vhost konfigurationen sparas? Det gr att specificera alla vhost i en fil eller en katalog dr alla filerna ligger (varje vhost i sin egen fil).';
$lng['serversettings']['apacheconf_diroptions']['title'] = 'Apache diroptions konfiguration fil/katalognamn';
$lng['serversettings']['apacheconf_diroptions']['description'] = 'Var skall diroptions konfigurationen sparas? Det gr att specificera alla diroptions i en fil eller en katalog dr alla filerna ligger (varje diroptions i sin egen fil).';
$lng['serversettings']['apacheconf_htpasswddir']['title'] = 'Apache htpasswd katalognamn';
$lng['serversettings']['apacheconf_htpasswddir']['description'] = 'Var skall htpasswd konfigurationen fr katalogskerheten?';

// ADDED IN 1.2.16-svn15

$lng['error']['formtokencompromised'] = 'Den skra anslutningen till Froxlor har avslutats och du har av skerhetsskl automatiskt loggats ur.';
$lng['serversettings']['mysql_access_host']['title'] = 'MySQL-Access-Hosts';
$lng['serversettings']['mysql_access_host']['description'] = 'En kommaseparerad lista med datornamn som tillts att kontakta MySQL servern.';

// ADDED IN 1.2.18-svn1

$lng['admin']['ipsandports']['create_listen_statement'] = 'Skapa "Listen statement"';
$lng['admin']['ipsandports']['create_namevirtualhost_statement'] = 'Skapa NameVirtualHost statement';
$lng['admin']['ipsandports']['create_vhostcontainer'] = 'Skapa vHost-Container';
$lng['admin']['ipsandports']['create_vhostcontainer_servername_statement'] = 'Skapa ServerName statement i vHost-Container';

// ADDED IN 1.2.18-svn2

$lng['admin']['webalizersettings'] = 'Webalizer instllningar';
$lng['admin']['webalizer']['normal'] = 'Normal';
$lng['admin']['webalizer']['quiet'] = 'Tyst';
$lng['admin']['webalizer']['veryquiet'] = 'Vldigt tyst';
$lng['serversettings']['webalizer_quiet']['title'] = 'Webalizer output';
$lng['serversettings']['webalizer_quiet']['description'] = 'Verbosity of the webalizer-program';

// ADDED IN 1.2.18-svn3

$lng['ticket']['admin_email'] = 'root@localhost';
$lng['ticket']['noreply_email'] = 'tickets@froxlor';
$lng['admin']['ticketsystem'] = 'Support';
$lng['menue']['ticket']['ticket'] = 'Supportrenden';
$lng['menue']['ticket']['categories'] = 'Kategorier';
$lng['menue']['ticket']['archive'] = 'Arkivet';
$lng['ticket']['description'] = 'Skriv en beskrivning av rendet hr!';
$lng['ticket']['ticket_new'] = '[Skapa ett nytt rende]';
$lng['ticket']['ticket_reply'] = 'Svara rende';
$lng['ticket']['ticket_reopen'] = 'terppna rende';
$lng['ticket']['ticket_newcateory'] = '[Skapa ny kategori]';
$lng['ticket']['ticket_editcateory'] = 'ndra kategori';
$lng['ticket']['ticket_view'] = 'View ticketcourse';
$lng['ticket']['ticketcount'] = 'rendenummer';
$lng['ticket']['ticket_answers'] = 'Svar';
$lng['ticket']['lastchange'] = 'Senaste ndring';
$lng['ticket']['subject'] = 'Rubrik';
$lng['ticket']['status'] = 'Status';
$lng['ticket']['lastreplier'] = 'gare';
$lng['ticket']['priority'] = 'Prioritet';
$lng['ticket']['low'] = '<span class="rende_lg">Lg</span>';
$lng['ticket']['normal'] = '<span class="rende_norm">Normal</span>';
$lng['ticket']['high'] = '<span class="rende_hg">Hg</span>';
$lng['ticket']['unf_low'] = 'Lg';
$lng['ticket']['unf_normal'] = 'Normal';
$lng['ticket']['unf_high'] = 'Hg';
$lng['ticket']['lastchange'] = 'ndrad';
$lng['ticket']['lastchange_from'] = 'Frn datum (dd.mm.yyyy)';
$lng['ticket']['lastchange_to'] = 'Till datum (dd.mm.yyyy)';
$lng['ticket']['category'] = 'Kategori';
$lng['ticket']['no_cat'] = 'None';
$lng['ticket']['message'] = 'Meddeland';
$lng['ticket']['show'] = 'Visa';
$lng['ticket']['answer'] = 'Svara';
$lng['ticket']['close'] = 'Stng';
$lng['ticket']['reopen'] = 'ppna igen';
$lng['ticket']['archive'] = 'Arkivera';
$lng['ticket']['ticket_delete'] = 'Radera ett rende';
$lng['ticket']['lastarchived'] = 'Recently archived tickets';
$lng['ticket']['archivedtime'] = 'Arkiverad';
$lng['ticket']['open'] = 'ppnad';
$lng['ticket']['wait_reply'] = 'Vntar p svar';
$lng['ticket']['replied'] = 'Besvarad';
$lng['ticket']['closed'] = 'Stngd';
$lng['ticket']['staff'] = 'Staff';
$lng['ticket']['customer'] = 'Kund';
$lng['ticket']['old_tickets'] = 'rende meddelanden';
$lng['ticket']['search'] = 'Sk i arkivet';
$lng['ticket']['nocustomer'] = 'Inget val';
$lng['ticket']['archivesearch'] = 'Arkiv skresultat';
$lng['ticket']['noresults'] = 'Inget rende funnet';
$lng['ticket']['notmorethanxopentickets'] = 'P grund av spamhanteringen kan du inte ha mer n %s ppna renden';
$lng['ticket']['supportstatus'] = 'Support-Status';
$lng['ticket']['supportavailable'] = '<span class="ticket_low">Vra supporttekniker tar nu grna emot era supportrenden.</span>';
$lng['ticket']['supportnotavailable'] = '<span class="ticket_high">Vra supporttekniker r inte tillgngliga just nu.</span>';
$lng['admin']['templates']['ticket'] = 'Informations E-post fr supportrenden';
$lng['admin']['templates']['SUBJECT'] = 'Ersatt med supportrendet rubrik';
$lng['admin']['templates']['new_ticket_for_customer'] = 'Kundinformation som rendet har skickat';
$lng['admin']['templates']['new_ticket_by_customer'] = 'Admininformation fr ett rende ppnat av kund';
$lng['admin']['templates']['new_reply_ticket_by_customer'] = 'Admininformation fr ett svar frn kund';
$lng['admin']['templates']['new_ticket_by_staff'] = 'Kundinformation fr ett rende ppnat av ledningen';
$lng['admin']['templates']['new_reply_ticket_by_staff'] = 'Kundinformation fr ett rende besvarat av ledningen';
$lng['mails']['new_ticket_for_customer']['mailbody'] = 'Hej {FIRSTNAME} {NAME},\n\nDitt supportrende med rubriken "{SUBJECT}" har skickats till supporten.\n\nVi meddelar dig nr ditt rende har blivit besvarat.\n\nMed vnliga hlsningar,\n Froxlor';
$lng['mails']['new_ticket_for_customer']['subject'] = 'Ditt supportrende har nu skickats';
$lng['mails']['new_ticket_by_customer']['mailbody'] = 'Hej admin,\n\nEtt nytt supportrende med rubriken "{SUBJECT}" har nu skapats.\n\nVnligen logga in fr att ppna rendet.\n\nMed vnliga hlsningar,\n Froxlor';
$lng['mails']['new_ticket_by_customer']['subject'] = 'Nytt supportrende skapat';
$lng['mails']['new_reply_ticket_by_customer']['mailbody'] = 'Hej admin,\n\nDitt supportrende "{SUBJECT}" har blivit besvarat an en kund.\n\nVnligen logga in fr att ppna rendet.\n\nMed vnliga hlsningar,\n Froxlor';
$lng['mails']['new_reply_ticket_by_customer']['subject'] = 'Nytt svar fr supportrendet';
$lng['mails']['new_ticket_by_staff']['mailbody'] = 'Hej {FIRSTNAME} {NAME},\n\nEtt nytt supportrende har ppnats med rubriken "{SUBJECT}".\n\nVnligen logga in fr att ppna rendet.\n\nMed vnliga hlsningar,\n Froxlor';
$lng['mails']['new_ticket_by_staff']['subject'] = 'Nytt supportrede behandlat';
$lng['mails']['new_reply_ticket_by_staff']['mailbody'] = 'Hej {FIRSTNAME} {NAME},\n\nSupportrendet med rubriken "{SUBJECT}" har besvarats av vr personal.\n\nVnligen logga in fr att ppna rendet.\n\nMed vnliga hlsningar,\n Froxlor';
$lng['mails']['new_reply_ticket_by_staff']['subject'] = 'Svar p ert supportrende';
$lng['question']['ticket_reallyclose'] = 'r du sker p att du vill stnga supportrendet "%s"?';
$lng['question']['ticket_reallydelete'] = 'r du sker p att du vill radera supportrendet "%s"?';
$lng['question']['ticket_reallydeletecat'] = 'r du sker p att du vill radera kategorin "%s"?';
$lng['question']['ticket_reallyarchive'] = 'r du sker p att du vill flytta supportrendet "%s" till arkivet?';
$lng['error']['mysubject'] = '\'' . $lng['ticket']['subject'] . '\'';
$lng['error']['mymessage'] = '\'' . $lng['ticket']['message'] . '\'';
$lng['error']['mycategory'] = '\'' . $lng['ticket']['category'] . '\'';
$lng['error']['nomoreticketsavailable'] = 'Du har redan anvnt alla supportrenden som du ftt tilldelade. Kontakta administratren om du behver fler.';
$lng['error']['nocustomerforticket'] = 'Det gr inte att skapa ett supportrende utan kunder';
$lng['error']['categoryhastickets'] = 'Denna kategori har fortfarande supportrenden.<br />Du mste radera dessa renden innan du kan radera denna kategori';
$lng['error']['notmorethanxopentickets'] = $lng['ticket']['notmorethanxopentickets'];
$lng['admin']['ticketsettings'] = 'Supportrende instllningar';
$lng['admin']['archivelastrun'] = 'Sista supportrende som arkiverats';
$lng['serversettings']['ticket']['noreply_email']['title'] = 'Svara-Inte E-post adress';
$lng['serversettings']['ticket']['noreply_email']['description'] = 'Avsndaradressen fr support-ticket, exempel: inget-svar@example.org';
$lng['serversettings']['ticket']['worktime_begin']['title'] = 'Start av support-tid (hh:mm)';
$lng['serversettings']['ticket']['worktime_begin']['description'] = 'Start-tid, nr supporten r tillgnglig';
$lng['serversettings']['ticket']['worktime_end']['title'] = 'Slut p support-tid (hh:mm)';
$lng['serversettings']['ticket']['worktime_end']['description'] = 'Slut-tid, nr supporten inte lngre r tillgnglig';
$lng['serversettings']['ticket']['worktime_sat'] = 'Supporten har ppet p lrdagar?';
$lng['serversettings']['ticket']['worktime_sun'] = 'Supporten har ppet p sndagar?';
$lng['serversettings']['ticket']['worktime_all']['title'] = 'Supporten r tillgnglig dygnet runt';
$lng['serversettings']['ticket']['worktime_all']['description'] = 'Om du vljer "Ja" s kommer start och stopp tiderna att skrivas ver';
$lng['serversettings']['ticket']['archiving_days'] = 'Efter hur mnga dagar skall stngda tickets arkiveras?';
$lng['customer']['tickets'] = 'Support renden';

// ADDED IN 1.2.18-svn4

$lng['admin']['domain_nocustomeraddingavailable'] = 'Det gr inte att skapa en ny domn innan det finns mins en upplagd kund.';
$lng['serversettings']['ticket']['enable'] = 'Tillt anvndninga av ticketsystemet';
$lng['serversettings']['ticket']['concurrentlyopen'] = 'Maximalt antal tickets som kan ppnas samtidigt?';
$lng['error']['norepymailiswrong'] = 'Den hr adressen  &quot;Noreply-address&quot; r felaktig. Bara giltiga E-post adresser r tilltna.';
$lng['error']['tadminmailiswrong'] = 'Den hr adressen &quot;Ticketadmin-address&quot; r felaktig. Bara giltiga E-post adresser r tilltna.';
$lng['ticket']['awaitingticketreply'] = 'Du har %s obesvarade support-ticket(s)';

// ADDED IN 1.2.18-svn5

$lng['serversettings']['ticket']['noreply_name'] = 'Supportrendes namn p E-postadressen';

// ADDED IN 1.2.19-svn1

$lng['serversettings']['mod_fcgid']['configdir']['title'] = 'FCGI konfigurationskatalog';
$lng['serversettings']['mod_fcgid']['configdir']['description'] = 'I vilken katalog skall alla fcgi-konfigurationfiler lagras?';
$lng['serversettings']['mod_fcgid']['tmpdir']['title'] = 'FCGI temporrkatalog';

// ADDED IN 1.2.19-svn3

$lng['serversettings']['ticket']['reset_cycle']['title'] = 'terstll cykeln fr anvnda supportrenden';
$lng['serversettings']['ticket']['reset_cycle']['description'] = 'terstll kundens rknare fr anvnda supportrenden. Vald cykel = 0';
$lng['admin']['tickets']['daily'] = 'Dagligen';
$lng['admin']['tickets']['weekly'] = 'Varje vecka';
$lng['admin']['tickets']['monthly'] = 'Varje mnad';
$lng['admin']['tickets']['yearly'] = 'Varje r';
$lng['error']['ticketresetcycleiswrong'] = 'Cykeln fr terstllning av supportrenden mste vara "Dagligen", "Varje vecka", "varje mnad" or "varje r".';

// ADDED IN 1.2.19-svn4

$lng['menue']['traffic']['traffic'] = 'Trafik';
$lng['menue']['traffic']['current'] = 'Nuvarande mnad';
$lng['traffic']['month'] = "Mnad";
$lng['traffic']['day'] = "Dag";
$lng['traffic']['months'][1] = "Januari";
$lng['traffic']['months'][2] = "Februari";
$lng['traffic']['months'][3] = "Mars";
$lng['traffic']['months'][4] = "April";
$lng['traffic']['months'][5] = "Maj";
$lng['traffic']['months'][6] = "Juni";
$lng['traffic']['months'][7] = "Juli";
$lng['traffic']['months'][8] = "Augusti";
$lng['traffic']['months'][9] = "September";
$lng['traffic']['months'][10] = "Oktober";
$lng['traffic']['months'][11] = "November";
$lng['traffic']['months'][12] = "December";
$lng['traffic']['mb'] = "Trafik (MB)";
$lng['traffic']['distribution'] = '<font color="#019522">FTP</font> | <font color="#0000FF">HTTP</font> | <font color="#800000">Mail</font>';
$lng['traffic']['sumhttp'] = 'Summa HTTP-Trafik i';
$lng['traffic']['sumftp'] = 'Summa FTP-Trafik i';
$lng['traffic']['summail'] = 'Summa E-posttrafik i';

?>
