<?php
namespace Froxlor\Http;

use Froxlor\Settings;

class Statistics
{

	/**
	 * Create or modify the AWStats configuration file for the given domain.
	 * Modified by Berend Dekens to allow custom configurations.
	 *
	 * @param
	 *        	logFile
	 * @param
	 *        	siteDomain
	 * @param
	 *        	hostAliases
	 * @return null
	 */
	public static function createAWStatsConf($logFile, $siteDomain, $hostAliases, $customerDocroot, $awstats_params = array())
	{

		// Generation header
		$header = "## GENERATED BY FROXLOR\n";
		$header2 = "## Do not remove the line above! This tells Froxlor to update this configuration\n## If you wish to manually change this configuration file, remove the first line to make sure Froxlor won't rebuild this file\n## Generated for domain {SITE_DOMAIN} on " . date('l dS \of F Y h:i:s A') . "\n";

		$awstats_dir = \Froxlor\FileDir::makeCorrectDir($customerDocroot . '/awstats/' . $siteDomain . '/');
		if (! is_dir($awstats_dir)) {
			\Froxlor\FileDir::safe_exec('mkdir -p ' . escapeshellarg($awstats_dir));
		}
		// chown created folder, #258
		self::makeChownWithNewStats($awstats_params);

		// weird but could happen...
		if (! is_dir(Settings::Get('system.awstats_conf'))) {
			\Froxlor\FileDir::safe_exec('mkdir -p ' . escapeshellarg(Settings::Get('system.awstats_conf')));
		}

		// These are the variables we will replace
		$regex = array(
			'/\{LOG_FILE\}/',
			'/\{SITE_DOMAIN\}/',
			'/\{HOST_ALIASES\}/',
			'/\{CUSTOMER_DOCROOT\}/',
			'/\{AWSTATS_CONF\}/'
		);
		$replace = array(
			\Froxlor\FileDir::makeCorrectFile($logFile),
			$siteDomain,
			$hostAliases,
			$awstats_dir,
			\Froxlor\FileDir::makeCorrectDir(Settings::Get('system.awstats_conf'))
		);

		// File names
		$domain_file = \Froxlor\FileDir::makeCorrectFile(Settings::Get('system.awstats_conf') . '/awstats.' . $siteDomain . '.conf');
		$model_file = \Froxlor\Froxlor::getInstallDir() . '/templates/misc/awstats/awstats.froxlor.model.conf';
		$model_file = \Froxlor\FileDir::makeCorrectFile($model_file);

		// Test if the file exists
		if (file_exists($domain_file)) {
			// Check for the generated header - if this is a manual modification we won't update
			$awstats_domain_conf = fopen($domain_file, 'r');

			if (fgets($awstats_domain_conf, strlen($header)) != $header) {
				fclose($awstats_domain_conf);
				return;
			}

			// Close the file
			fclose($awstats_domain_conf);
		}

		$awstats_domain_conf = fopen($domain_file, 'w');
		$awstats_model_conf = fopen($model_file, 'r');

		// Write the header
		fwrite($awstats_domain_conf, $header);
		fwrite($awstats_domain_conf, preg_replace($regex, $replace, $header2));

		// Write the configuration file
		while (($line = fgets($awstats_model_conf, 4096)) !== false) {
			if (! preg_match('/^#/', $line) && trim($line) != '') {
				fwrite($awstats_domain_conf, preg_replace($regex, $replace, $line));
			}
		}

		fclose($awstats_domain_conf);
		fclose($awstats_model_conf);
	}

	/**
	 * chowns either awstats or webalizer folder,
	 * either with webserver-user or - if fcgid
	 * is used - the customers name, #258
	 *
	 * @param array $row
	 *        	array if panel_customers
	 *        	
	 * @return void
	 */
	public static function makeChownWithNewStats($row)
	{

		// get correct user
		if ((Settings::Get('system.mod_fcgid') == '1' || Settings::Get('phpfpm.enabled') == '1') && isset($row['deactivated']) && $row['deactivated'] == '0') {
			$user = $row['loginname'];
			$group = $row['loginname'];
		} else {
			$user = $row['guid'];
			$group = $row['guid'];
		}

		// get correct directory
		$dir = $row['documentroot'];
		if (Settings::Get('system.awstats_enabled') == '1') {
			$dir .= '/awstats/';
		} else {
			$dir .= '/webalizer/';
		}

		// only run chown if directory exists
		if (file_exists($dir)) {
			// run chown
			\Froxlor\FileDir::safe_exec('chown -R ' . escapeshellarg($user) . ':' . escapeshellarg($group) . ' ' . escapeshellarg(\Froxlor\FileDir::makeCorrectDir($dir)));
		}
	}
}
