/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.flink;

import java.io.IOException;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import org.apache.beam.runners.core.metrics.MetricsContainerStepMap;
import org.apache.beam.sdk.PipelineResult;
import org.apache.beam.sdk.metrics.MetricResults;
import org.apache.flink.api.common.JobStatus;
import org.apache.flink.core.execution.JobClient;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.dataflow.qual.SideEffectFree;
import org.joda.time.Duration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FlinkDetachedRunnerResult
implements PipelineResult {
    private static final @UnknownKeyFor @NonNull @Initialized Logger LOG = LoggerFactory.getLogger(FlinkDetachedRunnerResult.class);
    private @UnknownKeyFor @NonNull @Initialized JobClient jobClient;
    private @UnknownKeyFor @NonNull @Initialized int jobCheckIntervalInSecs;

    FlinkDetachedRunnerResult(@UnknownKeyFor @NonNull @Initialized JobClient jobClient, @UnknownKeyFor @NonNull @Initialized int jobCheckIntervalInSecs) {
        this.jobClient = jobClient;
        this.jobCheckIntervalInSecs = jobCheckIntervalInSecs;
    }

    public // Could not load outer class - annotation placement on inner may be incorrect
    @UnknownKeyFor @NonNull @Initialized PipelineResult.State getState() {
        try {
            return this.toBeamJobState((JobStatus)this.jobClient.getJobStatus().get());
        }
        catch (InterruptedException | ExecutionException e) {
            throw new RuntimeException("Fail to get flink job state", e);
        }
    }

    public @UnknownKeyFor @NonNull @Initialized MetricResults metrics() {
        return MetricsContainerStepMap.asAttemptedOnlyMetricResults((MetricsContainerStepMap)this.getMetricsContainerStepMap());
    }

    private @UnknownKeyFor @NonNull @Initialized MetricsContainerStepMap getMetricsContainerStepMap() {
        try {
            return ((Map)this.jobClient.getAccumulators().get()).getOrDefault("__metricscontainers", new MetricsContainerStepMap());
        }
        catch (InterruptedException | ExecutionException e) {
            LOG.warn("Fail to get flink job accumulators", (Throwable)e);
            return new MetricsContainerStepMap();
        }
    }

    public // Could not load outer class - annotation placement on inner may be incorrect
    @UnknownKeyFor @NonNull @Initialized PipelineResult.State cancel() throws @UnknownKeyFor @NonNull @Initialized IOException {
        try {
            this.jobClient.cancel().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw new RuntimeException("Fail to cancel flink job", e);
        }
        return this.getState();
    }

    public // Could not load outer class - annotation placement on inner may be incorrect
    @UnknownKeyFor @NonNull @Initialized PipelineResult.State waitUntilFinish() {
        return this.waitUntilFinish(Duration.millis((long)Long.MAX_VALUE));
    }

    public // Could not load outer class - annotation placement on inner may be incorrect
    @UnknownKeyFor @NonNull @Initialized PipelineResult.State waitUntilFinish(@UnknownKeyFor @NonNull @Initialized Duration duration) {
        long start = System.currentTimeMillis();
        long durationInMillis = duration.getMillis();
        PipelineResult.State state = PipelineResult.State.UNKNOWN;
        while (durationInMillis < 1L || System.currentTimeMillis() - start < durationInMillis) {
            state = this.getState();
            if (state.isTerminal()) {
                return state;
            }
            try {
                Thread.sleep(this.jobCheckIntervalInSecs * 1000);
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        }
        if (state != null && !state.isTerminal()) {
            LOG.warn("Job is not finished in {} seconds", (Object)duration.getStandardSeconds());
        }
        return state;
    }

    private // Could not load outer class - annotation placement on inner may be incorrect
    @UnknownKeyFor @NonNull @Initialized PipelineResult.State toBeamJobState(@UnknownKeyFor @NonNull @Initialized JobStatus flinkJobStatus) {
        switch (flinkJobStatus) {
            case CANCELLING: 
            case CREATED: 
            case INITIALIZING: 
            case FAILING: 
            case RECONCILING: 
            case RESTARTING: 
            case RUNNING: {
                return PipelineResult.State.RUNNING;
            }
            case FINISHED: {
                return PipelineResult.State.DONE;
            }
            case CANCELED: {
                return PipelineResult.State.CANCELLED;
            }
            case FAILED: {
                return PipelineResult.State.FAILED;
            }
            case SUSPENDED: {
                return PipelineResult.State.STOPPED;
            }
        }
        return PipelineResult.State.UNKNOWN;
    }

    @SideEffectFree
    public @UnknownKeyFor @NonNull @Initialized String toString() {
        return "FlinkDetachedRunnerResult{}";
    }
}

