/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.filemetadata.util.delimiters;

import java.io.BufferedReader;
import java.util.ArrayList;
import java.util.List;
import org.apache.hop.core.logging.ILogChannel;
import org.apache.hop.pipeline.transforms.filemetadata.util.delimiters.DelimiterDetector;

public class DelimiterDetectorBuilder {
    private ArrayList<Character> delimiterCandidates = new ArrayList(5);
    private ArrayList<Character> enclosureCandidates = new ArrayList(5);
    private BufferedReader input = null;
    private ILogChannel log;
    private long maxBadHeaderLines = 10L;
    private long maxBadFooterLines = 10L;
    private long rowLimit = 0L;

    public DelimiterDetectorBuilder withDelimiterCandidates(char ... candidates) {
        this.delimiterCandidates.clear();
        for (char c : candidates) {
            this.delimiterCandidates.add(Character.valueOf(c));
        }
        return this;
    }

    public DelimiterDetectorBuilder withDelimiterCandidates(List<Character> candidates) {
        this.delimiterCandidates.clear();
        for (char c : candidates) {
            this.delimiterCandidates.add(Character.valueOf(c));
        }
        return this;
    }

    public DelimiterDetectorBuilder withEnclosureCandidates(char ... candidates) {
        this.enclosureCandidates.clear();
        for (char c : candidates) {
            this.enclosureCandidates.add(Character.valueOf(c));
        }
        return this;
    }

    public DelimiterDetectorBuilder withEnclosureCandidates(List<Character> candidates) {
        this.enclosureCandidates.clear();
        for (char c : candidates) {
            this.enclosureCandidates.add(Character.valueOf(c));
        }
        return this;
    }

    public DelimiterDetectorBuilder withInput(BufferedReader input) {
        this.input = input;
        return this;
    }

    public DelimiterDetectorBuilder withLogger(ILogChannel log) {
        this.log = log;
        return this;
    }

    public DelimiterDetectorBuilder withMaxBadLines(long header, long footer) {
        this.maxBadHeaderLines = header;
        this.maxBadFooterLines = footer;
        return this;
    }

    public DelimiterDetector build() {
        DelimiterDetector d = new DelimiterDetector();
        d.setDelimiterCandidates(this.delimiterCandidates);
        d.setEnclosureCandidates(this.enclosureCandidates);
        d.setInput(this.input);
        d.setMaxBadHeaderLines(this.maxBadHeaderLines);
        d.setMaxBadFooterLines(this.maxBadFooterLines);
        d.setLog(this.log);
        d.setRowLimit(this.rowLimit);
        return d;
    }

    public DelimiterDetectorBuilder withRowLimit(long limitRows) {
        this.rowLimit = limitRows;
        return this;
    }
}

